/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.drawengines;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.tool.TSEReconnectEdgeTool;
import com.tomsawyer.editor.ui.TSEEdgeUI;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.common.generics.IteratorT;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.ui.controls.drawingarea.GetHelper;
import org.netbeans.modules.uml.ui.controls.drawingarea.SwapEdgeEndsAction;
import org.netbeans.modules.uml.ui.products.ad.application.IMenuManager;
import org.netbeans.modules.uml.ui.products.ad.application.action.ContextMenuActionClass;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETStrokeCache;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.ETArrowHeadFactory;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.IETGraphObjectUI;
import org.netbeans.modules.uml.ui.support.accessibility.UMLAccessibleRole;
import org.netbeans.modules.uml.ui.support.applicationmanager.IEdgePresentation;
import org.netbeans.modules.uml.ui.support.applicationmanager.ILabelPresentation;
import org.netbeans.modules.uml.ui.support.contextmenusupport.IProductContextMenu;
import org.netbeans.modules.uml.ui.support.contextmenusupport.IProductContextMenuItem;
import org.netbeans.modules.uml.ui.support.umltsconversions.RectConversions;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETPointEx;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETRectEx;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETArrowHead;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETEdge;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETNode;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IEdgeDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ILabelManager;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ETEdgeDrawEngine
extends ETDrawEngine
implements IEdgeDrawEngine {
    protected static ETStrokeCache m_stokeCache = new ETStrokeCache();
    private int m_nBorderStringID = -1;
    AccessibleContext accessibleContext;

    @Override
    public void doDraw(IDrawInfo iDrawInfo) {
        if (!this.simpleDrawEdge(iDrawInfo, this.getLineKind())) {
            this.drawEdge(iDrawInfo, this.getStartArrowKind(), this.getEndArrowKind(), this.getLineKind());
        }
    }

    protected IElement getNodeElement(TSENode tSENode) {
        IETGraphObjectUI iETGraphObjectUI = tSENode != null ? (IETGraphObjectUI)tSENode.getUI() : null;
        return iETGraphObjectUI != null ? iETGraphObjectUI.getModelElement() : null;
    }

    protected IElement getSourceElement() {
        return this.getNodeElement(this.getSourceNode());
    }

    protected IElement getTargetElement() {
        return this.getNodeElement(this.getTargetNode());
    }

    protected IETRect getSourcePtBounds() {
        TSConstPoint tSConstPoint = this.getEdge().getSourceClippingPoint();
        double d = this.getGraphWindow().getPreferences().getDoubleValue((Object)"reconnectEdgeSensitivity");
        TSRect tSRect = new TSRect();
        tSRect.setBoundsFromCenter(tSConstPoint.getX(), tSConstPoint.getY(), d, d);
        return RectConversions.newETRect((TSConstRect)tSRect);
    }

    protected IETRect getTargetPtBounds() {
        TSConstPoint tSConstPoint = this.getEdge().getTargetClippingPoint();
        double d = this.getGraphWindow().getPreferences().getDoubleValue((Object)"reconnectEdgeSensitivity");
        TSRect tSRect = new TSRect();
        tSRect.setBoundsFromCenter(tSConstPoint.getX(), tSConstPoint.getY(), d, d);
        return RectConversions.newETRect((TSConstRect)tSRect);
    }

    protected boolean hitEndPoint(IETPoint iETPoint) {
        return this.getTargetPtBounds().contains(iETPoint) || this.getSourcePtBounds().contains(iETPoint);
    }

    protected boolean isReconnecting() {
        return this.getUI().getDrawingArea().getGraphWindow().getCurrentTool() instanceof TSEReconnectEdgeTool;
    }

    protected boolean isReconnectingTarget() {
        TSEReconnectEdgeTool tSEReconnectEdgeTool;
        TSEReconnectEdgeTool tSEReconnectEdgeTool2 = tSEReconnectEdgeTool = this.isReconnecting() ? (TSEReconnectEdgeTool)this.getUI().getDrawingArea().getGraphWindow().getCurrentTool() : null;
        if (tSEReconnectEdgeTool != null) {
            return !tSEReconnectEdgeTool.isReconnectingSource();
        }
        return false;
    }

    public IETGraphObjectUI getUIAt(IETPoint iETPoint) {
        TSEWindowInputTool tSEWindowInputTool = (TSEWindowInputTool)this.getUI().getDrawingArea().getGraphWindow().getCurrentTool();
        TSEObject tSEObject = tSEWindowInputTool.getHitTesting().getGraphObjectAt(new TSConstPoint((double)iETPoint.getX(), (double)iETPoint.getY()), this.getUI().getDrawingArea().getGraphWindow().getGraph(), true);
        if (this.getEdge() == tSEObject) {
            tSEObject = tSEWindowInputTool.getHitTesting().getGraphObjectAt(new TSConstPoint((double)iETPoint.getX(), (double)iETPoint.getY()), this.getUI().getDrawingArea().getGraphWindow().getGraph(), true);
        }
        return tSEObject != null && tSEObject.getUI() instanceof IETGraphObjectUI ? (IETGraphObjectUI)tSEObject.getUI() : null;
    }

    @Override
    public boolean handleLeftMouseButton(MouseEvent mouseEvent) {
        this.postInvalidate();
        return false;
    }

    @Override
    public boolean handleLeftMouseBeginDrag(IETPoint iETPoint, IETPoint iETPoint2) {
        return false;
    }

    @Override
    public boolean handleLeftMouseButtonDoubleClick(MouseEvent mouseEvent) {
        this.postInvalidate();
        return false;
    }

    @Override
    public boolean handleLeftMouseDrag(IETPoint iETPoint, IETPoint iETPoint2) {
        this.postInvalidate();
        return !this.getAllowReconnection();
    }

    @Override
    public boolean handleLeftMouseDrop(IETPoint iETPoint, List list, boolean bl) {
        return false;
    }

    @Override
    public boolean handleRightMouseButton(MouseEvent mouseEvent) {
        return false;
    }

    @Override
    public boolean getAllowReconnection() {
        return !this.getReadOnly();
    }

    @Override
    public TSEColor getColor() {
        return new TSEColor(this.getColor(this.m_nBorderStringID));
    }

    @Override
    public TSEColor getSelectedColor() {
        return this.getEdgeUI().getHighlightedColor();
    }

    @Override
    public TSEColor getStateColor() {
        return this.getEdge().isSelected() ? this.getSelectedColor() : this.getColor();
    }

    protected IETNode getNodeFromID(int n) {
        if (this.getEdge() != null) {
            if (this.getSourceNode().getClass().hashCode() == n) {
                return (IETNode)this.getSourceNode();
            }
            if (this.getTargetNode().getClass().hashCode() == n) {
                return (IETNode)this.getTargetNode();
            }
        }
        return null;
    }

    protected ETPairT<List, List> getPathNodeAndEdges() {
        ETArrayList eTArrayList = new ETArrayList();
        ETArrayList eTArrayList2 = new ETArrayList();
        List list = this.getEdge().pathEdges();
        List list2 = this.getEdge().pathNodes();
        ETArrayList eTArrayList3 = new ETArrayList();
        IteratorT iteratorT = new IteratorT(list);
        while (iteratorT.hasNext()) {
            eTArrayList.add(iteratorT.next());
        }
        IteratorT iteratorT2 = new IteratorT(list2);
        while (iteratorT2.hasNext()) {
            eTArrayList2.add(iteratorT2.next());
        }
        return new ETPairT<List, List>(eTArrayList2, eTArrayList);
    }

    protected ETPairT<List, List> getReconnectEdgeBendPoints() {
        List list = this.getEdge().bendPoints();
        ETArrayList eTArrayList = new ETArrayList();
        IteratorT iteratorT = new IteratorT(list);
        while (iteratorT.hasNext()) {
            eTArrayList.add((TSConstPoint)((TSConstPoint)iteratorT.next()).clone());
        }
        GetHelper.reverseList(this.getGraphWindow(), eTArrayList);
        return new ETPairT<List, List>(list, eTArrayList);
    }

    public boolean setEdgeEnds(IETNode iETNode, IETNode iETNode2) {
        IETNode iETNode3 = (IETNode)this.getSourceNode();
        IETNode iETNode4 = (IETNode)this.getTargetNode();
        TSEEdge tSEEdge = this.getEdge();
        if (tSEEdge != null) {
            ETPairT<List, List> eTPairT = this.getReconnectEdgeBendPoints();
            tSEEdge.setTargetNode((TSNode)((TSENode)iETNode2));
            tSEEdge.setSourceNode((TSNode)((TSENode)iETNode));
            if (iETNode == iETNode4 && iETNode2 == iETNode3) {
                this.getEdge().reroute(eTPairT.getParamTwo());
                TSEEdgeUI tSEEdgeUI = (TSEEdgeUI)this.getEdge().getUI();
                if (tSEEdgeUI != null) {
                    tSEEdgeUI.setArrowType(0);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public long swapEdgeEnds(int n, int n2) {
        IETNode iETNode;
        IETNode iETNode2 = (IETNode)this.getTargetNode();
        return this.setEdgeEnds(iETNode2, iETNode = (IETNode)this.getSourceNode()) ? 1L : 0L;
    }

    protected void postSwapEdgeEnds() {
        try {
            TSEEdge tSEEdge = this.getEdge();
            if (tSEEdge != null) {
                IETNode iETNode = (IETNode)this.getSourceNode();
                IETNode iETNode2 = (IETNode)this.getTargetNode();
                if (iETNode2 != null && iETNode != null) {
                    int n = iETNode2.getClass().hashCode();
                    int n2 = iETNode.getClass().hashCode();
                    SwapEdgeEndsAction swapEdgeEndsAction = new SwapEdgeEndsAction();
                    if (swapEdgeEndsAction != null) {
                        swapEdgeEndsAction.setEdgeToSwap((IETEdge)tSEEdge);
                        swapEdgeEndsAction.setNewTargetEndID(n);
                        swapEdgeEndsAction.setNewSourceEndID(n2);
                        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
                        if (iDrawingAreaControl != null) {
                            iDrawingAreaControl.postDelayedAction(swapEdgeEndsAction);
                            this.postInvalidate();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean simpleDrawEdge(IDrawInfo iDrawInfo, int n) {
        boolean bl = false;
        try {
            if (iDrawInfo != null) {
                bl = iDrawInfo.getOnDrawZoom() < (double)0.3f ? this.drawEdge(iDrawInfo, 0, 0, n) : false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public ETPairT<TSConstPoint, TSConstPoint> getFromLineSegment() {
        TSEEdge tSEEdge = this.getEdge();
        List list = tSEEdge.pathNodes();
        int n = list.size();
        TSConstPoint tSConstPoint = tSEEdge.getTargetClippingPoint();
        TSConstPoint tSConstPoint2 = tSEEdge.getSourceClippingPoint();
        ETPairT<TSConstPoint, TSConstPoint> eTPairT = new ETPairT<TSConstPoint, TSConstPoint>(tSConstPoint, tSConstPoint2);
        List list2 = tSEEdge.bendPoints();
        if (list2 != null && list2.size() >= 1) {
            eTPairT.setParamOne((TSConstPoint)list2.get(0));
        }
        return eTPairT;
    }

    public ETPairT<TSConstPoint, TSConstPoint> getToLineSegment() {
        TSEEdge tSEEdge = this.getEdge();
        TSConstPoint tSConstPoint = tSEEdge.getSourceClippingPoint();
        TSConstPoint tSConstPoint2 = tSEEdge.getTargetClippingPoint();
        ETPairT<TSConstPoint, TSConstPoint> eTPairT = new ETPairT<TSConstPoint, TSConstPoint>(tSConstPoint, tSConstPoint2);
        List list = tSEEdge.bendPoints();
        if (list != null && list.size() >= 1) {
            eTPairT.setParamOne((TSConstPoint)list.get(list.size() - 1));
        }
        return eTPairT;
    }

    public TSEEdgeUI getEdgeUI() {
        return (TSEEdgeUI)this.getParent();
    }

    @Override
    public TSEEdge getEdge() {
        IETGraphObjectUI iETGraphObjectUI;
        TSEEdge tSEEdge = null;
        if (this.getParent() != null && (iETGraphObjectUI = this.getParent()) != null && iETGraphObjectUI.getOwner() instanceof TSEEdge) {
            tSEEdge = (TSEEdge)iETGraphObjectUI.getOwner();
        }
        return tSEEdge;
    }

    @Override
    public TSGraphObject getOwnerGraphObject() {
        return this.getEdge();
    }

    TSENode getSourceNode() {
        return (TSENode)this.getEdge().getSourceNode();
    }

    TSENode getTargetNode() {
        return (TSENode)this.getEdge().getTargetNode();
    }

    IETRect getSourceNodeLogicalBounds() {
        return new ETRectEx(this.getSourceNodeBounds());
    }

    IETRect getTargetNodeLogicalBounds() {
        return new ETRectEx(this.getTargetNodeBounds());
    }

    TSConstRect getSourceNodeBounds() {
        return this.getSourceNode().getBounds();
    }

    TSConstRect getTargetNodeBounds() {
        return this.getTargetNode().getBounds();
    }

    protected boolean drawArrowHead(IDrawInfo iDrawInfo, int n, ETPairT<TSConstPoint, TSConstPoint> eTPairT) {
        return this.drawArrowHead(iDrawInfo, n, eTPairT, this.getStateColor());
    }

    protected boolean drawArrowHead(IDrawInfo iDrawInfo, int n, ETPairT<TSConstPoint, TSConstPoint> eTPairT, TSEColor tSEColor) {
        if (n == 0) {
            return true;
        }
        try {
            return this.drawArrowHead(iDrawInfo, this.createArrowHead(n), eTPairT, tSEColor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected boolean drawArrowHead(IDrawInfo iDrawInfo, IETArrowHead iETArrowHead, ETPairT<TSConstPoint, TSConstPoint> eTPairT, TSEColor tSEColor) {
        return iETArrowHead != null && iETArrowHead.draw(iDrawInfo, eTPairT.getParamOne(), eTPairT.getParamTwo(), this.getStateColor());
    }

    protected IETArrowHead createArrowHead(int n) {
        return ETArrowHeadFactory.create(n);
    }

    protected int getPenWidth() {
        return 1;
    }

    protected int getLineKind() {
        return 0;
    }

    protected int getStartArrowKind() {
        return 0;
    }

    protected int getEndArrowKind() {
        return 4;
    }

    protected Stroke getLineStroke(int n, float f) {
        return m_stokeCache.getStroke(n, f);
    }

    protected void drawPathDigraph(IDrawInfo iDrawInfo, IETArrowHead iETArrowHead, IETArrowHead iETArrowHead2) {
        this.getEdgeUI().drawPath(iDrawInfo.getTSEGraphics());
    }

    public boolean drawEdge(IDrawInfo iDrawInfo, int n, int n2, int n3) {
        TSEEdge tSEEdge = this.getEdge();
        if (tSEEdge == null) {
            return false;
        }
        TSEEdgeUI tSEEdgeUI = (TSEEdgeUI)tSEEdge.getUI();
        TSEColor tSEColor = this.getStateColor();
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        tSEGraphics.setColor(tSEColor);
        int n4 = this.getPenWidth();
        Stroke stroke = tSEGraphics.getStroke();
        tSEGraphics.setStroke(this.getLineStroke(n3, n4));
        IETArrowHead iETArrowHead = this.createArrowHead(n);
        IETArrowHead iETArrowHead2 = this.createArrowHead(n2);
        this.drawPathDigraph(iDrawInfo, iETArrowHead, iETArrowHead2);
        if (n3 != 0) {
            tSEGraphics.setStroke(this.getLineStroke(0, n4));
        }
        this.drawArrowHead(iDrawInfo, iETArrowHead, this.getFromLineSegment(), tSEColor);
        this.drawArrowHead(iDrawInfo, iETArrowHead2, this.getToLineSegment(), tSEColor);
        iDrawInfo.getTSEGraphics().setStroke(stroke);
        return true;
    }

    @Override
    public String getPresentationType() {
        return "EdgePresentation";
    }

    public IEdgePresentation getIEdgePresentation() {
        return this.getPresentation() instanceof IEdgePresentation ? (IEdgePresentation)this.getPresentation() : null;
    }

    protected IETPoint getETPoint(MouseEvent mouseEvent) {
        TSEWindowInputTool tSEWindowInputTool = (TSEWindowInputTool)this.getUI().getDrawingArea().getGraphWindow().getCurrentTool();
        return new ETPointEx(tSEWindowInputTool.getNonalignedWorldPoint(mouseEvent));
    }

    @Override
    public String getMetaTypeInitString() {
        return null;
    }

    public void addStandardLabelsToPullright(int n, IMenuManager iMenuManager) {
        IElement iElement;
        if (n == 1 || n == 2) {
            this.addStereotypeLabelPullright(this, iMenuManager);
        }
        if ((n == 0 || n == 2) && (iElement = this.getFirstModelElement()) != null && iElement instanceof INamedElement) {
            this.addNameLabelPullright(this, iMenuManager);
        }
    }

    protected boolean handleStandardLabelSensitivityAndCheck(String string, ContextMenuActionClass contextMenuActionClass) {
        boolean bl = false;
        ILabelManager iLabelManager = this.getLabelManager();
        boolean bl2 = this.isParentDiagramReadOnly();
        if (string.equals("MBK_SHOW_STEREOTYPE")) {
            boolean bl3 = iLabelManager.isDisplayed(6);
            contextMenuActionClass.setChecked(bl3);
            bl = !bl2;
        } else if (string.equals("MBK_SHOW_NAME_LABEL")) {
            boolean bl4 = iLabelManager.isDisplayed(12);
            contextMenuActionClass.setChecked(bl4);
            bl = !bl2;
        }
        return bl;
    }

    protected boolean handleStandardLabelSelection(ActionEvent actionEvent, String string) {
        boolean bl = false;
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        ILabelManager iLabelManager = this.getLabelManager();
        if (iDrawingAreaControl != null) {
            if (string.equals("MBK_SHOW_STEREOTYPE")) {
                if (iLabelManager != null) {
                    boolean bl2 = iLabelManager.isDisplayed(6);
                    iLabelManager.showLabel(6, !bl2);
                }
                iDrawingAreaControl.refresh(false);
                bl = true;
            } else if (string.equals("MBK_SHOW_NAME_LABEL")) {
                if (iLabelManager != null) {
                    IPresentationElement iPresentationElement;
                    boolean bl3 = iLabelManager.isDisplayed(12);
                    iLabelManager.showLabel(12, !bl3);
                    if (!bl3 && (iPresentationElement = iLabelManager.getLabel(12)) != null && iPresentationElement instanceof ILabelPresentation) {
                        iDrawingAreaControl.postEditLabel((ILabelPresentation)iPresentationElement);
                    }
                }
                iDrawingAreaControl.refresh(false);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public String getDrawEngineID() {
        return "EdgeDrawEngine";
    }

    public boolean handleStereotypeSensitivityAndCheck(IProductContextMenu iProductContextMenu, IProductContextMenuItem iProductContextMenuItem, int n) {
        boolean bl = false;
        try {
            ILabelManager iLabelManager = this.getLabelManager();
            switch (n) {
                case 24: {
                    boolean bl2 = iLabelManager.isDisplayed(6);
                    iProductContextMenuItem.setChecked(bl2);
                    iProductContextMenuItem.setSensitive(!this.parentDiagramIsReadOnly());
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public IEdgePresentation getEdgePresentationElement() {
        IPresentationElement iPresentationElement = this.getPresentationElement();
        if (iPresentationElement instanceof IEdgePresentation) {
            return (IEdgePresentation)iPresentationElement;
        }
        return null;
    }

    @Override
    public void verifyEdgeEnds() {
    }

    @Override
    public Color getLineColor() {
        return this.getColor().getColor();
    }

    @Override
    public int setLineColor(String string, int n, int n2, int n3) {
        return this.setLineColor(string, new Color(n, n2, n3));
    }

    @Override
    public int setLineColor(String string, Color color) {
        if (color != null) {
            TSEEdgeUI tSEEdgeUI;
            this.m_nBorderStringID = this.m_ResourceUser.setResourceStringID(this.m_nBorderStringID, string, color.getRGB());
            TSEEdgeUI tSEEdgeUI2 = tSEEdgeUI = this.m_nBorderStringID >= 0 && this.getUI() instanceof TSEEdgeUI ? (TSEEdgeUI)this.getUI() : null;
            if (tSEEdgeUI != null) {
                tSEEdgeUI.setLineColor(new TSEColor(this.getColor(this.m_nBorderStringID)));
            }
        }
        return this.m_nBorderStringID;
    }

    public Color getColor(int n) {
        return new Color(this.m_ResourceUser.getCOLORREFForStringID(n));
    }

    @Override
    public long performDeepSynch() {
        long l = 0L;
        try {
            l = super.performDeepSynch();
            this.verifyEdgeEnds();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    @Override
    public long postLoad() {
        return 0L;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleETEdgeDrawEngine();
        }
        return this.accessibleContext;
    }

    public class AccessibleETEdgeDrawEngine
    extends ETDrawEngine.AccessibleETDrawEngine {
        public String getAccessibleDescription() {
            if (ETEdgeDrawEngine.this.getIEdgePresentation() != null) {
                IDrawEngine iDrawEngine = ETEdgeDrawEngine.this.getIEdgePresentation().getEdgeToDrawEngine();
                IDrawEngine iDrawEngine2 = ETEdgeDrawEngine.this.getIEdgePresentation().getEdgeFromDrawEngine();
                if (iDrawEngine != null && iDrawEngine instanceof Accessible && iDrawEngine2 != null && iDrawEngine2 instanceof Accessible) {
                    AccessibleContext accessibleContext = ((Accessible)((Object)iDrawEngine)).getAccessibleContext();
                    AccessibleContext accessibleContext2 = ((Accessible)((Object)iDrawEngine2)).getAccessibleContext();
                    if (accessibleContext != null && accessibleContext2 != null) {
                        return this.getAccessibleName() + " from " + accessibleContext2.getAccessibleName() + " to " + accessibleContext.getAccessibleName();
                    }
                }
            }
            return super.getAccessibleDescription();
        }

        public AccessibleRole getAccessibleRole() {
            return UMLAccessibleRole.UML_EDGE;
        }

        public Color getForeground() {
            return ETEdgeDrawEngine.this.getLineColor();
        }

        public void setForeground(Color color) {
        }
    }
}

