/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces;

import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.graph.TSEdge;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.ETLifelineCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.IADLifelineCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.ActivationBar;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.ConnectorPiece;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.LifelineCompartmentPiece;

public class LifelinePiece {
    private ConnectorPiece m_Piece = null;
    private TSConnector m_AssociatedConnector = null;

    protected LifelinePiece() {
    }

    public LifelinePiece(ConnectorPiece connectorPiece) {
        this.setPiece(connectorPiece);
    }

    public LifelinePiece(TSConnector tSConnector) {
        ConnectorPiece connectorPiece = ConnectorPiece.getPieceAttachedToConnector(tSConnector);
        this.setPiece(connectorPiece);
        this.setAssociatedConnector(tSConnector);
    }

    public int getConnectorLocation() {
        return this.getConnectorLocation(this.getAssociatedConnector());
    }

    public int getConnectorLocation(TSConnector tSConnector) {
        int n = -1;
        if (tSConnector instanceof TSConnector) {
            TSConnector tSConnector2 = tSConnector;
            ConnectorPiece connectorPiece = this.getPiece();
            if (connectorPiece != null) {
                n = connectorPiece.getLocation(tSConnector2);
            }
        }
        return n;
    }

    public boolean isValid() {
        return this.getPiece() != null;
    }

    public int getLogicalTop() {
        ETLifelineCompartment eTLifelineCompartment;
        int n = 0;
        ConnectorPiece connectorPiece = this.getPiece();
        if (connectorPiece != null && (eTLifelineCompartment = connectorPiece.getParent()) != null) {
            IETRect iETRect = eTLifelineCompartment.getLogicalBoundingRect();
            n = iETRect.getTop() - connectorPiece.getTop();
        }
        return n;
    }

    public void setLogicalTop(int n) {
        ConnectorPiece connectorPiece = this.getPiece();
        if (connectorPiece != null) {
            connectorPiece.setLogicalTop(n);
        }
    }

    public int getLogicalBottom() {
        int n = 0;
        ConnectorPiece connectorPiece = this.getPiece();
        if (connectorPiece != null) {
            n = connectorPiece.getLogicalBottom();
        }
        return n;
    }

    public void setLogicalBottom(int n) {
        ConnectorPiece connectorPiece = this.getPiece();
        if (connectorPiece != null) {
            connectorPiece.setLogicalBottom(n);
        }
    }

    public TSConnector createConnector(int n) {
        TSConnector tSConnector = null;
        ConnectorPiece connectorPiece = this.getPiece();
        if (connectorPiece != null) {
            tSConnector = connectorPiece.createConnector(n);
        }
        return tSConnector;
    }

    public void attachConnector(int n, TSConnector tSConnector) {
        ConnectorPiece connectorPiece = this.getPiece();
        if (connectorPiece instanceof ActivationBar) {
            connectorPiece.attachConnector(tSConnector, n, true);
        }
    }

    public boolean isPartOfMessageToSelf() {
        boolean bl = false;
        ConnectorPiece connectorPiece = this.getPiece();
        if (connectorPiece instanceof ActivationBar) {
            ActivationBar activationBar = (ActivationBar)connectorPiece;
            bl = activationBar.isMessageToSelf();
        }
        return bl;
    }

    public void setIsPartOfMessageToSelf(boolean bl) {
        ConnectorPiece connectorPiece = this.getPiece();
        if (connectorPiece instanceof ActivationBar) {
            ActivationBar activationBar = (ActivationBar)connectorPiece;
            activationBar.setMessageToSelf(bl);
        }
    }

    public LifelinePiece getAssociatedPiece() {
        ConnectorPiece connectorPiece;
        LifelinePiece lifelinePiece = new LifelinePiece();
        ConnectorPiece connectorPiece2 = this.getPiece();
        if (connectorPiece2 != null && (connectorPiece = connectorPiece2.getAssociatedPiece(false)) != null) {
            lifelinePiece.setPiece(connectorPiece);
        }
        return lifelinePiece;
    }

    public LifelinePiece getParentPiece() {
        LifelineCompartmentPiece lifelineCompartmentPiece;
        LifelinePiece lifelinePiece = null;
        ConnectorPiece connectorPiece = this.getPiece();
        if (connectorPiece != null && (lifelineCompartmentPiece = connectorPiece.getParentPiece()) instanceof ConnectorPiece) {
            lifelinePiece = new LifelinePiece((ConnectorPiece)lifelineCompartmentPiece);
        }
        return lifelinePiece;
    }

    public IADLifelineCompartment getParentCompartment() {
        ETLifelineCompartment eTLifelineCompartment = null;
        ConnectorPiece connectorPiece = this.getPiece();
        if (connectorPiece != null) {
            eTLifelineCompartment = connectorPiece.getParent();
        }
        return eTLifelineCompartment;
    }

    public TSEdge getAttachedEdge(int n) {
        TSEdge tSEdge = null;
        ConnectorPiece connectorPiece = this.getPiece();
        if (connectorPiece != null) {
            tSEdge = connectorPiece.getAttachedEdge(n);
        }
        return tSEdge;
    }

    protected ConnectorPiece getPiece() {
        return this.m_Piece;
    }

    protected void setPiece(ConnectorPiece connectorPiece) {
        this.m_Piece = connectorPiece;
    }

    public TSConnector getAssociatedConnector() {
        return this.m_AssociatedConnector;
    }

    public void setAssociatedConnector(TSConnector tSConnector) {
        this.m_AssociatedConnector = tSConnector;
    }

    public TSConnector copyTo(ETLifelineCompartment eTLifelineCompartment) {
        if (null == eTLifelineCompartment) {
            throw new IllegalArgumentException();
        }
        if (null == this.m_Piece) {
            throw new IllegalStateException();
        }
        TSConnector tSConnector = null;
        ConnectorPiece connectorPiece = null;
        int n = this.m_Piece.getLifelinePiecesKind();
        connectorPiece = (ConnectorPiece)eTLifelineCompartment.createElement(this.m_Piece.getLogicalTop(), n);
        if (connectorPiece != null) {
            this.m_Piece.removeSelfFromStack();
            tSConnector = connectorPiece.copy(this.m_Piece);
            this.m_Piece = null;
        }
        return tSConnector;
    }
}

