/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces;

import java.awt.Dimension;
import java.awt.Point;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.ETLifelineCompartment;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;

public abstract class LifelineCompartmentPiece {
    public static final int PIECE_WIDTH = 10;
    public static final int PIECE_HEIGHT = 40;
    public static final int ACTIVATION_BAR_BUFFER = 10;
    public static final int MIN_SIBLING_SPACE = 10;
    public static final int ACTIVATION_CORNER_COUNT = 4;
    public static final int CHILD_OFFSET = 5;
    private ETLifelineCompartment m_Parent = null;
    private LifelineCompartmentPiece m_ParentPiece = null;
    private IETPoint m_TopLeft = null;
    private int m_Height = -1;

    public LifelineCompartmentPiece(ETLifelineCompartment eTLifelineCompartment, LifelineCompartmentPiece lifelineCompartmentPiece, IETPoint iETPoint, int n) {
        this.setParent(eTLifelineCompartment);
        this.setParentPiece(lifelineCompartmentPiece);
        this.setTopLeft(iETPoint);
        this.m_Height = n;
    }

    public ETLifelineCompartment getParent() {
        return this.m_Parent;
    }

    public int getChildOffset() {
        return 5;
    }

    public void setParent(ETLifelineCompartment eTLifelineCompartment) {
        this.m_Parent = eTLifelineCompartment;
    }

    public LifelineCompartmentPiece getParentPiece() {
        return this.m_ParentPiece;
    }

    public void setParentPiece(LifelineCompartmentPiece lifelineCompartmentPiece) {
        if (this.m_ParentPiece != null && lifelineCompartmentPiece != null) {
            int n = this.m_TopLeft.getY() - (lifelineCompartmentPiece.getTop() - this.m_ParentPiece.getTop());
            this.m_TopLeft.setY(Math.max(10, n));
        }
        this.m_ParentPiece = lifelineCompartmentPiece;
        if (this.m_ParentPiece != null && this.m_ParentPiece.getLeft() != 0) {
            this.setLeft(this.m_ParentPiece.getLeft() + this.m_ParentPiece.getChildOffset());
        }
    }

    public IETPoint getTopLeft() {
        return this.m_TopLeft;
    }

    public void setTopLeft(IETPoint iETPoint) {
        this.m_TopLeft = iETPoint;
    }

    public int getHeight() {
        return this.m_Height;
    }

    public void setHeight(int n) {
        if (n < 0) {
            this.m_Height = n;
        }
        this.m_Height = n;
    }

    public int getBottom() {
        return this.getTop() + this.getHeight();
    }

    public void setBottom(int n) {
        this.setHeight(n - this.getTop());
    }

    public void setLogicalBottom(int n) {
        this.setHeight(this.getLogicalTop() - n);
    }

    public int getLogicalBottom() {
        int n = this.getCompartmentLogicalBoundingRect().getTop();
        return n - this.getBottom();
    }

    public void setLeft(int n) {
        if (this.m_TopLeft == null) {
            this.m_TopLeft = new ETPoint(0, 0);
        }
        this.m_TopLeft.setX(n);
        this.getParent().updateSides(n, n + 10);
    }

    public int getLeft() {
        return this.m_TopLeft.getX();
    }

    public int getLeftRelativeTo(IETRect iETRect) {
        int n = this.getLeft();
        if (iETRect != null) {
            n += iETRect.getTop();
        }
        return n;
    }

    public void moveBy(int n) {
        this.moveBy(n, true);
    }

    public void moveBy(int n, boolean bl) {
        int n2 = this.getY() + n;
        if (bl) {
            this.setY(n2);
        } else {
            this.m_TopLeft.setY(n2);
        }
    }

    public void setTop(int n) {
        this.setY(n - this.getParentTop());
    }

    public int getY() {
        return this.m_TopLeft.getY();
    }

    public void setY(long l) {
        long l2 = l;
        long l3 = l2 - 10L;
        if (l3 < 0L) {
            LifelineCompartmentPiece lifelineCompartmentPiece = this.getParentPiece();
            if (lifelineCompartmentPiece != null) {
                long l4 = (long)lifelineCompartmentPiece.getTop() + l3;
                lifelineCompartmentPiece.setTop((int)l4);
            }
            l2 = lifelineCompartmentPiece == this.getParentPiece() ? 10L : (long)this.getY();
        }
        this.m_TopLeft.setY((int)l2);
    }

    public int getTop() {
        return this.getParentTop() + this.getY();
    }

    public int getParentTop() {
        int n = 0;
        LifelineCompartmentPiece lifelineCompartmentPiece = this.getParentPiece();
        if (lifelineCompartmentPiece != null) {
            n = lifelineCompartmentPiece.getTop();
        }
        return n;
    }

    public Dimension getDrawSize() {
        return new Dimension(10, this.getHeight());
    }

    public IETRect getDrawRect(double d) {
        Dimension dimension = this.getDrawSize();
        IETRect iETRect = this.getEngineLogicalBoundingRect();
        double d2 = iETRect.getCenterX();
        return new ETRect(d2 + (double)this.getLeft(), (double)this.getDETop(), dimension.getWidth(), dimension.getHeight());
    }

    public IETRect getAbsoluteDrawRect(double d) {
        IETRect iETRect = this.getDrawRect(d);
        if (iETRect != null) {
            IETRect iETRect2 = this.getEngineLogicalBoundingRect();
            iETRect.setTop(iETRect2.getTop() - iETRect.getTop());
        }
        return iETRect;
    }

    protected abstract String getID();

    public abstract int getLifelinePiecesKind();

    public IProductArchiveElement writeToArchive(IProductArchiveElement iProductArchiveElement) {
        IProductArchiveElement iProductArchiveElement2 = null;
        if (iProductArchiveElement != null && (iProductArchiveElement2 = iProductArchiveElement.createElement(this.getID())) != null) {
            iProductArchiveElement2.addAttributeLong("left", this.getLeft());
            iProductArchiveElement2.addAttributeLong("dy", this.getTop());
            iProductArchiveElement2.addAttributeLong("height", this.getHeight());
        }
        return iProductArchiveElement2;
    }

    public void readFromArchive(IProductArchiveElement iProductArchiveElement) {
        if (iProductArchiveElement != null) {
            long l = iProductArchiveElement.getAttributeLong("left");
            long l2 = iProductArchiveElement.getAttributeLong("dy");
            this.setHeight((int)iProductArchiveElement.getAttributeLong("height"));
            if (l == 0L && l2 == l) {
                l2 = iProductArchiveElement.getAttributeLong("y");
            }
            this.setLeft((int)l);
            this.setTop((int)l2);
        }
    }

    public IDiagram getDiagram() {
        IDiagram iDiagram = null;
        IDrawEngine iDrawEngine = this.getDrawEngine();
        if (iDrawEngine != null) {
            iDiagram = TypeConversions.getDiagram(iDrawEngine);
        }
        return iDiagram;
    }

    protected IDrawEngine getDrawEngine() {
        IDrawEngine iDrawEngine = null;
        ETLifelineCompartment eTLifelineCompartment = this.getParent();
        if (eTLifelineCompartment != null) {
            iDrawEngine = eTLifelineCompartment.getEngine();
        }
        return iDrawEngine;
    }

    protected IETRect getEngineLogicalBoundingRect(boolean bl) {
        return this.getParent().getEngineLogicalBoundingRect(bl);
    }

    protected IETRect getEngineLogicalBoundingRect() {
        return this.getParent().getEngineLogicalBoundingRect(false);
    }

    protected IETRect getCompartmentLogicalBoundingRect() {
        return this.getParent().getLogicalBoundingRect();
    }

    public int getDETop() {
        int n = this.getParent().getDrawTop();
        int n2 = this.getTop();
        return n + n2;
    }

    public int getLogicalTop() {
        int n = this.getEngineLogicalBoundingRect().getTop();
        return n - this.getDETop();
    }

    public int getRestrictedY() {
        return this.getLogicalTop();
    }

    public void setLogicalTop(int n) {
        int n2 = this.getCompartmentLogicalBoundingRect().getTop();
        if (n > n2) {
            n = n2;
        }
        this.setTop(n2 - n);
    }

    public IETRect getLogicalBoundingRect() {
        IETRect iETRect = this.getCompartmentLogicalBoundingRect();
        Point point = new Point(iETRect.getLeft() + this.getTop(), iETRect.getTop() - this.getY());
        return new ETRect(point, this.getDrawSize());
    }
}

