/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.graphics.TSEGraphics;
import java.awt.BasicStroke;
import java.awt.Stroke;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.ETLifelineCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.ActivationBar;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.ConnectorPiece;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.ParentPiece;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;

public class Lifeline
extends ParentPiece {
    public static final int DESTROY_SIZE = 10;
    public static final float[] LIFELINE_DASH = new float[]{20.0f, 5.0f};
    public static final BasicStroke LIFELINE_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, LIFELINE_DASH, 0.0f);
    public static final TSEColor LIFELINE_COLOR = new TSEColor(0, 128, 0);
    private boolean m_IsDestroyed = false;

    public Lifeline(ETLifelineCompartment eTLifelineCompartment) {
        super(eTLifelineCompartment, null, new ETPoint(0, 0), 470);
    }

    public long getMinimumHeight() {
        ParentPiece parentPiece;
        long l = 40L;
        ETList<ParentPiece> eTList = this.getPieces();
        if (eTList != null && eTList.size() > 0 && (parentPiece = (ParentPiece)eTList.get(eTList.size() - 1)) != null) {
            l = parentPiece.getBottom() + 10;
        }
        return l;
    }

    public int getCompartmentMinimumHeight() {
        int n = (int)this.getMinimumHeight();
        return n;
    }

    public void setY(int n) {
        super.setY(0L);
    }

    public void setHeight(int n) {
        boolean bl = n != this.getHeight() && n != -this.getCompartmentLogicalBoundingRect().getIntHeight();
        super.setHeight(n);
        if (bl) {
            this.resizeNode(false);
        }
    }

    public ParentPiece createPiece(int n, int n2) {
        ParentPiece parentPiece = null;
        int n3 = n2;
        if (n == 1) {
            n3 = (int)Math.max((long)n3, this.getMinimumHeight());
            this.setDestroyedAt(n3);
            parentPiece = this;
        } else {
            ParentPiece parentPiece2 = null;
            parentPiece2 = n == 5 ? this.findActivationBarNear(n3) : this.findPieceAt(n2);
            if (parentPiece2 == null) {
                parentPiece2 = this;
            }
            int n4 = n3 - parentPiece2.getTop();
            parentPiece = parentPiece2.createNewPiece(n, n4, 40);
        }
        return parentPiece;
    }

    public ParentPiece createNewPiece(int n, int n2, int n3) {
        ParentPiece parentPiece = null;
        ETPoint eTPoint = new ETPoint(this.getLeft() + this.getChildOffset(), n2);
        switch (n) {
            case 2: 
            case 5: {
                parentPiece = new ActivationBar(this.getParent(), this, eTPoint, n3);
                if (parentPiece == null) break;
                this.insertPiece(parentPiece);
                break;
            }
            case 4: {
                parentPiece = this.createActivationPiece(n, n2, 0);
                break;
            }
            case 3: {
                parentPiece = this.createActivationPiece(n, n2, n3);
                break;
            }
        }
        return parentPiece;
    }

    protected ParentPiece createActivationPiece(int n, int n2, int n3) {
        ParentPiece parentPiece = null;
        ParentPiece parentPiece2 = this.createNewPiece(2, n2 - 10, n3 + 20);
        if (parentPiece2 != null) {
            parentPiece = parentPiece2.createNewPiece(n, 10, n3);
        }
        return parentPiece;
    }

    public void draw(IDrawInfo iDrawInfo, double d) {
        IETRect iETRect = this.getEngineLogicalBoundingRect();
        IETRect iETRect2 = this.getCompartmentLogicalBoundingRect();
        double d2 = this.getLeftRelativeTo(iETRect);
        double d3 = iETRect.getCenterX();
        double d4 = iETRect2.getTop();
        double d5 = Math.round(iETRect.getBottom());
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        if (this.isDestroyed()) {
            double d6 = 5.0;
            double d7 = d3 - d6;
            double d8 = d5 + 10.0;
            double d9 = d3 + d6;
            TSConstPoint tSConstPoint = new TSConstPoint(d7, d8);
            TSConstPoint tSConstPoint2 = new TSConstPoint(d9, d5);
            tSEGraphics.setColor(TSEColor.red);
            tSEGraphics.drawLine(tSConstPoint, tSConstPoint2);
            TSConstPoint tSConstPoint3 = new TSConstPoint(d9, d8);
            TSConstPoint tSConstPoint4 = new TSConstPoint(d7, d5);
            tSEGraphics.drawLine(tSConstPoint3, tSConstPoint4);
            d5 += d6;
        }
        TSConstPoint tSConstPoint = new TSConstPoint(d3, d4);
        TSConstPoint tSConstPoint5 = new TSConstPoint(d3, d5);
        Stroke stroke = tSEGraphics.getStroke();
        tSEGraphics.setStroke((Stroke)LIFELINE_STROKE);
        tSEGraphics.setColor(LIFELINE_COLOR);
        tSEGraphics.drawLine(tSConstPoint, tSConstPoint5);
        tSEGraphics.setStroke(stroke);
        super.draw(iDrawInfo, d);
    }

    public void readFromArchive(IProductArchiveElement iProductArchiveElement) {
        if (iProductArchiveElement != null) {
            super.readFromArchive(iProductArchiveElement);
            this.setDestroyed(iProductArchiveElement.getAttributeBool("isDestroyed"));
        }
    }

    public IProductArchiveElement writeToArchive(IProductArchiveElement iProductArchiveElement) {
        IProductArchiveElement iProductArchiveElement2 = null;
        if (iProductArchiveElement != null && (iProductArchiveElement2 = super.writeToArchive(iProductArchiveElement)) != null) {
            iProductArchiveElement2.addAttributeBool("isDestroyed", this.isDestroyed());
        }
        return iProductArchiveElement2;
    }

    public void attachConnectors() {
        for (ParentPiece parentPiece : this.m_ListPieces) {
            if (!(parentPiece instanceof ConnectorPiece)) continue;
            ConnectorPiece connectorPiece = (ConnectorPiece)parentPiece;
            connectorPiece.attachConnectors();
        }
    }

    public int getLifelinePiecesKind() {
        return 0;
    }

    public ParentPiece findActivationBarNear(long l) {
        ParentPiece parentPiece = null;
        ParentPiece parentPiece2 = this.getPieceUnderY(l);
        boolean bl = true;
        block4: while (parentPiece2 != null && bl) {
            switch (parentPiece2.getLifelinePiecesKind()) {
                default: {
                    bl = false;
                }
                case 2: 
                case 5: {
                    if (!(parentPiece2 instanceof ActivationBar)) continue block4;
                    ActivationBar activationBar = (ActivationBar)parentPiece2;
                    if (activationBar.containsMessageOnBottom()) {
                        parentPiece2 = (ParentPiece)parentPiece2.getParentPiece();
                        continue block4;
                    }
                    parentPiece = parentPiece2;
                    bl = false;
                    continue block4;
                }
                case 3: 
                case 4: 
            }
            parentPiece2 = (ParentPiece)parentPiece2.getParentPiece();
        }
        return parentPiece;
    }

    public void resizeTopBy(int n) {
        if (n != 0) {
            ETList<ParentPiece> eTList = this.getPieces();
            for (ParentPiece parentPiece : eTList) {
                if (parentPiece == null) continue;
                parentPiece.setY(parentPiece.getY() - n);
            }
        }
    }

    protected ParentPiece getPieceUnderY(long l) {
        ParentPiece parentPiece = this.findPieceAt((int)l);
        if (parentPiece != null) {
            switch (parentPiece.getLifelinePiecesKind()) {
                case 2: 
                case 5: {
                    break;
                }
                default: {
                    parentPiece = parentPiece.findNearestChildPiece((int)l);
                }
            }
        }
        return parentPiece;
    }

    public String getID() {
        return "Lifeline";
    }

    public boolean isDestroyed() {
        return this.m_IsDestroyed;
    }

    public void setDestroyed(boolean bl) {
        this.m_IsDestroyed = bl;
    }

    protected void setDestroyedAt(int n) {
        this.setDestroyedAt(n, true);
    }

    public void updateConnectorsViaTopCenter() {
        ETList<ParentPiece> eTList = this.getPieces();
        for (ParentPiece parentPiece : eTList) {
            if (!(parentPiece instanceof ConnectorPiece)) continue;
            ConnectorPiece connectorPiece = (ConnectorPiece)parentPiece;
            connectorPiece.updateConnectorsViaTopCenter();
        }
    }

    public void updateConnectorsViaBottomCenter() {
        ETList<ParentPiece> eTList = this.getPieces();
        for (ParentPiece parentPiece : eTList) {
            if (!(parentPiece instanceof ConnectorPiece)) continue;
            ConnectorPiece connectorPiece = (ConnectorPiece)parentPiece;
            connectorPiece.updateConnectorsViaBottomCenter();
        }
    }

    protected void setDestroyedAt(int n, boolean bl) {
        this.setHeight(n + 5);
        this.setDestroyed(true);
        if (bl) {
            this.resizeNode(true);
        }
    }

    public int getChildOffset() {
        return -4;
    }
}

