/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.compartments;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSEWindowTool;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.netbeans.modules.uml.common.ETException;
import org.netbeans.modules.uml.core.support.umlsupport.ETDeviceRect;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.ETSize;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.InvalidPointerException;
import org.netbeans.modules.uml.ui.products.ad.ADDrawEngines.IADContainerDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.compartments.IADZonesCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.IETZoneDividers;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETTransform;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.GDISupport;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ISetCursorEvent;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.PointConversions;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETHorzDragCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETVertDragCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools.DragManager;
import org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools.IDragManager;

public class ETZoneDividers
implements IETZoneDividers {
    protected static final int NEW_ZONE_SIZE = 40;
    protected int m_orientation;
    protected ETList<DividerInfo> m_dividers = new ETArrayList<DividerInfo>();
    protected int m_nLineStyle = 1;
    protected IADZonesCompartment m_parentCompartment;
    protected int m_ulCurrentDivider = 0;
    protected IETRect m_rectPreResize = null;
    public static final String ZD_DIVIDERS = "Dividers";
    public static final String ZD_DIVIDER = "Divider";
    public static final String ZD_OFFSET = "offset";

    public ETZoneDividers(IADZonesCompartment iADZonesCompartment, int n, int n2) {
        this.m_parentCompartment = iADZonesCompartment;
        this.setLineStyle(n);
        this.setOrientation(n2);
    }

    public ETZoneDividers(IADZonesCompartment iADZonesCompartment, int n) {
        this(iADZonesCompartment, n, -1);
    }

    public ETZoneDividers(IADZonesCompartment iADZonesCompartment) {
        this(iADZonesCompartment, 0);
    }

    public void setLineStyle(int n) {
        this.m_nLineStyle = n;
    }

    public void setOrientation(int n) {
        this.m_orientation = n;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public void insertDivider(int n) {
        if (n != -1) {
            this.shiftDividers(40, n);
        }
        IETRect iETRect = this.getTransform().getWinAbsoluteOwnerRect();
        int n2 = 1 == this.m_orientation ? iETRect.getIntWidth() : iETRect.getIntHeight();
        this.m_dividers.add(new DividerInfo(n2));
    }

    public void addDividers(int n) {
        if (n > 0) {
            IETRect iETRect = this.getTransform().getWinAbsoluteOwnerRect();
            int n2 = 1 == this.m_orientation ? iETRect.getIntWidth() : iETRect.getIntHeight();
            int n3 = n2 / (n + 1);
            int n4 = 0;
            int n5 = n3;
            while (n4 < n) {
                this.m_dividers.add(new DividerInfo(n5));
                ++n4;
                n5 += n3;
            }
        }
    }

    public void shiftDividers(int n) {
        this.shiftDividers(n, 0);
    }

    public void shiftDividers(int n, int n2) {
        for (int i = n2; i < this.m_dividers.size(); ++i) {
            DividerInfo dividerInfo = (DividerInfo)this.m_dividers.get(i);
            dividerInfo.setOffset(dividerInfo.getOffset() + n);
        }
    }

    public void deleteDivider(int n) {
        int n2 = this.m_dividers.getCount();
        if (n2 > 0) {
            while (n >= n2) {
                --n;
            }
            this.m_dividers.remove(n);
        }
    }

    public void resetDividers() {
        this.m_dividers.clear();
        if (this.m_parentCompartment != null) {
            int n;
            int n2 = 0;
            int n3 = this.m_parentCompartment.getNumCompartments() - 1;
            boolean bl = n3 > 0;
            for (int i = 0; i < n3; ++i) {
                Object object;
                ICompartment iCompartment = this.m_parentCompartment.getCompartment(i);
                assert (iCompartment != null);
                if (iCompartment != null) {
                    object = TypeConversions.getLogicalBoundingRect(iCompartment);
                    switch (this.m_orientation) {
                        case 0: {
                            n = (int)object.getHeight();
                            if (n > 0) {
                                bl = false;
                            }
                            n2 += Math.max(40, n);
                            break;
                        }
                        case 1: {
                            n = (int)object.getWidth();
                            if (n > 0) {
                                bl = false;
                            }
                            n2 += Math.max(40, n);
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                        case -1: 
                    }
                }
                object = new DividerInfo(n2);
                this.m_dividers.add(object);
            }
            if (bl) {
                IETRect iETRect = this.getTransform().getWinAbsoluteOwnerRect();
                int n4 = (int)(1 == this.m_orientation ? iETRect.getWidth() : iETRect.getHeight());
                int n5 = n4 / (n3 + 1);
                n = 0;
                int n6 = n5;
                while (n < n3) {
                    this.m_dividers.item((int)n).m_lOffset = n6;
                    ++n;
                    n6 += n5;
                }
            }
        }
    }

    public int getDividerOffset(int n) {
        DividerInfo dividerInfo = (DividerInfo)this.m_dividers.get(n);
        return dividerInfo != null ? dividerInfo.getOffset() : 0;
    }

    protected IETRect getDivider(int n) {
        DividerInfo dividerInfo = (DividerInfo)this.m_dividers.get(n);
        return dividerInfo != null ? dividerInfo.getRectDivider() : null;
    }

    protected void setDividerRect(int n, IETRect iETRect) {
        DividerInfo dividerInfo = (DividerInfo)this.m_dividers.get(n);
        if (dividerInfo != null) {
            dividerInfo.setRectDivider((IETRect)iETRect.clone());
        }
    }

    public void draw(IDrawInfo iDrawInfo, IETRect iETRect, Color color, int n) {
        double d = iDrawInfo.getOnDrawZoom();
        int n2 = Math.max(1, (int)((double)n * d));
        ETDeviceRect eTDeviceRect = ETDeviceRect.ensureDeviceRect((IETRect)iETRect.clone());
        IETPoint iETPoint = this.getDrawOffset(iETRect);
        switch (this.m_orientation) {
            case 0: {
                Point point = new Point(iETRect.getLeft(), 0);
                Point point2 = new Point(iETRect.getRight(), 0);
                Graphics2D graphics2D = iDrawInfo.getTSEGraphics().getGraphics();
                for (int i = 0; i < this.m_dividers.size(); ++i) {
                    int n3;
                    point.y = point2.y = (n3 = (int)((double)this.getDividerOffset(i) * d + (double)iETPoint.getY()));
                    GDISupport.drawLine(graphics2D, point, point2, color, 1, this.m_nLineStyle);
                    eTDeviceRect.setTop(n3 - n2 / 2);
                    eTDeviceRect.setBottom(n3 + n2 / 2);
                    this.setDividerRect(i, eTDeviceRect);
                }
                break;
            }
            case 1: {
                Point point = new Point(0, iETRect.getTop());
                Point point3 = new Point(0, iETRect.getBottom());
                Graphics2D graphics2D = iDrawInfo.getTSEGraphics().getGraphics();
                for (int i = 0; i < this.m_dividers.size(); ++i) {
                    int n4;
                    point.x = point3.x = (n4 = (int)((double)this.getDividerOffset(i) * d + (double)iETPoint.getX()));
                    GDISupport.drawLine(graphics2D, point, point3, color, 1, this.m_nLineStyle);
                    eTDeviceRect.setLeft(n4 - n2 / 2);
                    eTDeviceRect.setRight(n4 + n2 / 2);
                    this.setDividerRect(i, eTDeviceRect);
                }
                break;
            }
        }
    }

    public boolean isMouseOnDivider(MouseEvent mouseEvent) {
        TSConstPoint tSConstPoint;
        TSEWindowInputTool tSEWindowInputTool;
        boolean bl = false;
        if (this.m_dividers.size() > 0 && this.m_parentCompartment != null && (tSEWindowInputTool = (TSEWindowInputTool)this.getTransform().getGraphWindow().getCurrentState()) instanceof TSEWindowInputTool && (tSConstPoint = tSEWindowInputTool.getNonalignedWorldPoint(mouseEvent)) != null) {
            bl = this.getIndexFromLocation(new Point((int)tSConstPoint.getX(), (int)tSConstPoint.getY())) < this.m_dividers.size();
        }
        return bl;
    }

    public boolean handleSetCursor(IETPoint iETPoint, ISetCursorEvent iSetCursorEvent) {
        Cursor cursor = null;
        if (this.m_dividers.size() > 0) {
            this.m_ulCurrentDivider = this.getIndexFromLocation(iSetCursorEvent.getWinClientLocation());
            if (this.m_ulCurrentDivider < this.m_dividers.size()) {
                switch (this.m_orientation) {
                    case 0: {
                        cursor = ETHorzDragCursor.getCursor();
                        break;
                    }
                    case 1: {
                        cursor = ETVertDragCursor.getCursor();
                        break;
                    }
                }
                if (cursor != null) {
                    iSetCursorEvent.setCursor(cursor);
                }
            }
        }
        return cursor != null;
    }

    public boolean handleLeftMouseBeginDrag(IETPoint iETPoint) {
        boolean bl = false;
        if (this.m_parentCompartment != null && this.m_dividers.size() > 0 && this.m_ulCurrentDivider < this.m_dividers.size() && this.getIndexFromLocation(iETPoint.asPoint()) < this.m_dividers.size()) {
            bl = true;
            IDragManager iDragManager = this.createDragManagerTool();
            if (iDragManager != null) {
                ETList<ICompartment> eTList;
                iDragManager.setOrientation(this.m_orientation);
                ICompartment iCompartment = this.m_parentCompartment;
                iDragManager.setStretchCompartment(iCompartment);
                IETRect iETRect = this.getTransform().getTSAbsoluteRect();
                int n = -1;
                int n2 = -1;
                switch (this.m_orientation) {
                    case 0: {
                        int n3 = this.m_ulCurrentDivider > 0 ? iETRect.getTop() - this.getDividerOffset(this.m_ulCurrentDivider - 1) : iETRect.getTop();
                        iDragManager.setTop(n3);
                        int n4 = this.m_ulCurrentDivider < this.m_dividers.size() - 1 ? iETRect.getTop() - this.getDividerOffset(this.m_ulCurrentDivider + 1) : iETRect.getBottom();
                        iDragManager.setBottom(n4);
                        n = this.m_ulCurrentDivider;
                        n2 = this.m_ulCurrentDivider + 1;
                        break;
                    }
                    case 1: {
                        int n3 = this.m_ulCurrentDivider > 0 ? iETRect.getLeft() + this.getDividerOffset(this.m_ulCurrentDivider - 1) : iETRect.getLeft();
                        iDragManager.setBottom(n3);
                        int n4 = this.m_ulCurrentDivider < this.m_dividers.size() - 1 ? iETRect.getLeft() + this.getDividerOffset(this.m_ulCurrentDivider + 1) : iETRect.getRight();
                        iDragManager.setTop(n4);
                        n = this.m_ulCurrentDivider + 1;
                        n2 = this.m_ulCurrentDivider;
                        break;
                    }
                }
                IADZonesCompartment iADZonesCompartment = iCompartment instanceof IADZonesCompartment ? iCompartment : null;
                ETList<ICompartment> eTList2 = eTList = iADZonesCompartment != null ? iADZonesCompartment.getCompartments() : null;
                if (eTList != null) {
                    IADContainerDrawEngine iADContainerDrawEngine;
                    iCompartment = (ICompartment)eTList.get(n);
                    if (iCompartment != null) {
                        IADContainerDrawEngine iADContainerDrawEngine2 = iADContainerDrawEngine = iCompartment.getEngine() instanceof IADContainerDrawEngine ? (IADContainerDrawEngine)this.m_parentCompartment.getEngine() : null;
                        if (iADContainerDrawEngine != null) {
                            iDragManager.addElementsAbove(iCompartment.getContained());
                        }
                    }
                    if ((iCompartment = (ICompartment)eTList.get(n2)) != null) {
                        IADContainerDrawEngine iADContainerDrawEngine3 = iADContainerDrawEngine = iCompartment.getEngine() instanceof IADContainerDrawEngine ? (IADContainerDrawEngine)this.m_parentCompartment.getEngine() : null;
                        if (iADContainerDrawEngine != null) {
                            iDragManager.addElementsBelow(iCompartment.getContained());
                        }
                    }
                }
            }
        }
        return bl;
    }

    public int getDividerCnt() {
        return this.m_dividers.size();
    }

    public int getZoneIndex(int n) {
        int n2 = this.getDividerCnt();
        for (int i = 0; i < n2; ++i) {
            if (n > this.getDividerOffset(i)) continue;
            return i;
        }
        return n2;
    }

    public IETSize calculateOptimumSize(IDrawInfo iDrawInfo) {
        int n = 40;
        int n2 = 40;
        switch (this.m_orientation) {
            case 0: {
                n2 = Math.max(n2, this.getMinimumSize());
                break;
            }
            case 1: {
                n = Math.max(n, this.getMinimumSize());
                break;
            }
        }
        return new ETSize(n, n2);
    }

    public int getMinimumSize() {
        int n = this.m_dividers.size();
        return (n > 0 ? this.getDividerOffset(n - 1) : 0) + 40;
    }

    public void updateCurrentDivider(IETPoint iETPoint) {
        int n = this.calculateOffset(iETPoint);
        DividerInfo dividerInfo = (DividerInfo)this.m_dividers.get(this.m_ulCurrentDivider);
        if (dividerInfo != null) {
            dividerInfo.setOffset(n);
        }
    }

    protected int calculateOffset(IETPoint iETPoint) {
        IETPoint iETPoint2 = this.getTransform().getTSAbsoluteToWinAbsoluteOwner(iETPoint);
        int n = 0 == this.m_orientation ? iETPoint2.getY() : iETPoint2.getX();
        return n;
    }

    public void writeToArchive(IProductArchiveElement iProductArchiveElement) throws ETException {
        IProductArchiveElement iProductArchiveElement2;
        if (iProductArchiveElement != null && this.getDividerCnt() > 0 && (iProductArchiveElement2 = iProductArchiveElement.createElement(ZD_DIVIDERS)) != null) {
            for (int i = 0; i < this.getDividerCnt(); ++i) {
                IProductArchiveElement iProductArchiveElement3 = iProductArchiveElement2.createElement(ZD_DIVIDER);
                if (iProductArchiveElement3 == null) continue;
                iProductArchiveElement3.addAttributeLong(ZD_OFFSET, this.getDividerOffset(i));
            }
        }
    }

    public void readFromArchive(IProductArchiveElement iProductArchiveElement) throws ETException {
        IProductArchiveElement[] iProductArchiveElementArray;
        IProductArchiveElement iProductArchiveElement2;
        if (iProductArchiveElement != null && (iProductArchiveElement2 = iProductArchiveElement.getElement(ZD_DIVIDERS)) != null && (iProductArchiveElementArray = iProductArchiveElement2.getElements()) != null) {
            long l = iProductArchiveElementArray.length;
            int n = 0;
            while ((long)n < l) {
                IProductArchiveElement iProductArchiveElement3 = iProductArchiveElementArray[n];
                if (iProductArchiveElement3 != null) {
                    int n2 = (int)iProductArchiveElement3.getAttributeLong(ZD_OFFSET);
                    this.m_dividers.add(new DividerInfo(n2));
                }
                ++n;
            }
        }
    }

    public void startNodeResize() {
        this.m_rectPreResize = this.getTransform().getTSAbsoluteRect();
    }

    public void finishNodeResize() {
        if (this.m_rectPreResize != null && !this.m_rectPreResize.isZero()) {
            Point point = this.m_rectPreResize.getTopLeft();
            Point point2 = this.getTransform().getTSAbsoluteRect().getTopLeft();
            int n = 0;
            switch (this.m_orientation) {
                case 0: {
                    n = point2.y - point.y;
                    break;
                }
                case 1: {
                    n = point.x - point2.x;
                    break;
                }
            }
            this.shiftDividers(n);
            this.m_rectPreResize.setSides(0, 0, 0, 0);
        }
    }

    public IETPoint getDrawOffset(IETRect iETRect) {
        if (iETRect == null) {
            return null;
        }
        IETPoint iETPoint = PointConversions.newETPoint(iETRect.getTopLeft());
        return iETPoint;
    }

    protected ETTransform getTransform() throws InvalidPointerException {
        if (this.m_parentCompartment == null) {
            throw new InvalidPointerException();
        }
        return this.m_parentCompartment instanceof ETTransform ? (ETTransform)((Object)this.m_parentCompartment) : null;
    }

    protected int getIndexFromLocation(Point point) {
        DividerInfo dividerInfo;
        IETRect iETRect;
        Iterator iterator = this.m_dividers.iterator();
        int n = 0;
        while (iterator.hasNext() && !(iETRect = (dividerInfo = (DividerInfo)iterator.next()).getRectDivider()).contains(point)) {
            ++n;
        }
        return n;
    }

    public void setDividerOffset(int n, int n2) {
        DividerInfo dividerInfo;
        if (n < this.m_dividers.size() && n >= 0 && (dividerInfo = (DividerInfo)this.m_dividers.get(n)) != null) {
            dividerInfo.setOffset(n2);
        }
    }

    protected IDragManager createDragManagerTool() {
        DragManager dragManager = new DragManager(this.getTransform().getGraphWindow());
        if (dragManager != null) {
            this.getTransform().getGraphWindow().getCurrentTool().setTool((TSEWindowTool)dragManager);
        }
        return dragManager;
    }

    public int getIndexFromTSLogical(IETPoint iETPoint) {
        int n = this.calculateOffset(iETPoint);
        return this.getZoneIndex(n);
    }

    class DividerInfo {
        protected int m_lOffset;
        protected IETRect m_rectDivider;

        public DividerInfo(int n) {
            this.m_lOffset = n;
            this.m_rectDivider = new ETRect();
        }

        public void setOffset(int n) {
            this.m_lOffset = n;
        }

        public int getOffset() {
            return this.m_lOffset;
        }

        public IETRect getRectDivider() {
            return this.m_rectDivider;
        }

        public void setRectDivider(IETRect iETRect) {
            this.m_rectDivider = iETRect;
        }
    }
}

