/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.controls.projecttree;

import org.dom4j.Node;
import org.netbeans.modules.uml.core.configstringframework.ConfigStringTranslator;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.netbeans.modules.uml.ui.controls.projecttree.ProjectTreeNode;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeElement;

public class TreeElementNode
extends ProjectTreeNode
implements ITreeElement {
    private String m_ExpandedElementType = "";
    private boolean m_bTranslateName = false;

    public TreeElementNode() {
    }

    public TreeElementNode(IProjectTreeItem iProjectTreeItem) throws NullPointerException {
        super(iProjectTreeItem);
    }

    public void setElement(IElement iElement) {
        if (iElement != null) {
            this.m_ExpandedElementType = iElement.getExpandedElementType();
        }
        if (this.getData() != null) {
            this.getData().setModelElement(iElement);
        }
    }

    public IElement getElement() {
        IElement iElement = null;
        if (this.getData() != null) {
            iElement = this.getData().getModelElement();
        }
        return iElement;
    }

    public String getXMIID() {
        String string = null;
        if (this.getData() != null) {
            string = this.getData().getModelElementXMIID();
        }
        return string;
    }

    public String getElementType() {
        String string = null;
        if (this.getData() != null) {
            string = this.getData().getModelElementMetaType();
        }
        return string;
    }

    public String getExpandedElementType() {
        return this.m_ExpandedElementType;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof ITreeElement) {
            IElement iElement = this.getData().getModelElement();
            ITreeElement iTreeElement = (ITreeElement)object;
            if (iElement != null && iTreeElement.getElement() != null) {
                bl = iElement.isSame(iTreeElement.getElement());
            } else if (iElement == null && iTreeElement.getElement() == null && !(bl = super.equals(object))) {
                bl = this.getDisplayedName().equals(iTreeElement.getDisplayedName());
            }
        } else {
            bl = super.equals(object);
        }
        return bl;
    }

    public String getDisplayedName() {
        String string = super.getDisplayedName();
        if (string.length() <= 0) {
            string = this.getElementType();
        }
        return string;
    }

    public String getType() {
        String string = null;
        if (this.getData() != null) {
            string = this.getData().getModelElementMetaType();
        }
        return string;
    }

    public Node getXMLNode() {
        Node node = null;
        IElement iElement = this.getElement();
        if (iElement != null) {
            node = iElement.getNode();
        }
        return node;
    }

    public boolean getTranslateName() {
        return this.m_bTranslateName;
    }

    public void setTranslateName(boolean bl) {
        this.m_bTranslateName = bl;
    }

    public String getDisplayName() {
        String string = "";
        if (!this.m_bTranslateName) {
            string = this.getName();
        } else {
            ConfigStringTranslator configStringTranslator = new ConfigStringTranslator();
            if (configStringTranslator != null) {
                string = configStringTranslator.translateWord(this.m_Name);
            }
        }
        return string;
    }
}

