/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.controls.newdialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.common.Util;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConfigManager;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.ui.controls.newdialog.AddElementWizardPanel1;
import org.netbeans.modules.uml.ui.controls.newdialog.INewDialogElementDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.INewUMLFileTemplates;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialogResources;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialogUtilities;
import org.netbeans.modules.uml.ui.controls.newdialog.NewUMLDiagVisualPanel1;
import org.netbeans.modules.uml.ui.support.NewElementKind;
import org.netbeans.modules.uml.ui.support.commonresources.CommonResourceManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class AddElementVisualPanel1
extends JPanel
implements DocumentListener,
ListSelectionListener,
INewUMLFileTemplates {
    private AddElementWizardPanel1 panel;
    private INewDialogElementDetails mDetails = null;
    private static HashMap elementTypeNameMap = new HashMap();
    private static Document m_doc = null;
    private ResourceBundle bundle = NbBundle.getBundle(NewUMLDiagVisualPanel1.class);
    private JTextField elementNameTextField;
    private JList elementTypeList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JComboBox nameSpaceComboBox;

    public AddElementVisualPanel1(AddElementWizardPanel1 addElementWizardPanel1) {
        this.panel = addElementWizardPanel1;
        this.getElementListFromConfigFile();
        this.initComponents();
        this.elementTypeList.addListSelectionListener(this);
        this.elementNameTextField.getDocument().addDocumentListener(this);
    }

    public String getName() {
        return NbBundle.getBundle(AddElementVisualPanel1.class).getString("IDS_NEWELEMENT");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.elementTypeList = new JList();
        this.jLabel2 = new JLabel();
        this.elementNameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.nameSpaceComboBox = new JComboBox();
        this.jLabel1.setLabelFor(this.elementTypeList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(AddElementVisualPanel1.class).getString("IDS_ELEMENTTYPE"));
        this.elementTypeList.setSelectionMode(0);
        this.elementTypeList.setCellRenderer(new ElementListCellRenderer());
        this.jScrollPane1.setViewportView(this.elementTypeList);
        this.elementTypeList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AddElementVisualPanel1.class).getString("ACSD_NEW_ELEMENT_WIZARD_ELEMENTTYPE_LIST"));
        this.jLabel2.setLabelFor(this.elementNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(AddElementVisualPanel1.class).getString("IDS_ELEMENTNAME"));
        this.elementNameTextField.setText(NewDialogUtilities.getDefaultElementName());
        this.elementNameTextField.selectAll();
        this.elementNameTextField.requestFocus();
        this.jLabel3.setLabelFor(this.nameSpaceComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getBundle(AddElementVisualPanel1.class).getString("IDS_NAMESPACE"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 304, Short.MAX_VALUE).add((Component)this.elementNameTextField, -1, 304, Short.MAX_VALUE).add((Component)this.nameSpaceComboBox, 0, 304, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jScrollPane1, -1, 178, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.elementNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.nameSpaceComboBox, -2, -1, -2)).addContainerGap()));
        this.elementNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AddElementVisualPanel1.class).getString("ACSD_NEW_ELEMENT_WIZARD_ELEMENTNAME_TEXTFIELD"));
        this.nameSpaceComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AddElementVisualPanel1.class).getString("ACSD_NEW_ELEMENT_WIZARD_ELEMENTNAMESPACE_COMBOBOX"));
    }

    public void read(WizardDescriptor wizardDescriptor) {
        this.mDetails = (INewDialogElementDetails)wizardDescriptor.getProperty("elementDetails");
        this.populateList();
        this.populateCombobox();
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = (String)this.getSelectedListElement();
        String string2 = (String)elementTypeNameMap.get(string);
        List<String> list = Arrays.asList(NewElementKind.ELEMENT_NAMES);
        int n = list.indexOf(string2);
        if (n == -1) {
            this.mDetails.setElementKind(NewElementKind.ELEMENT_NUMBERS[0]);
        } else {
            this.mDetails.setElementKind(NewElementKind.ELEMENT_NUMBERS[n]);
        }
        this.mDetails.setName(this.getElementName());
        INamespace iNamespace = NewDialogUtilities.getNamespace((String)this.getSelectedNamespace());
        this.mDetails.setNamespace(iNamespace);
        wizardDescriptor.putProperty("elementDetails", (Object)this.mDetails);
    }

    private void getElementListFromConfigFile() {
        if (elementTypeNameMap == null || elementTypeNameMap.size() == 0) {
            if (elementTypeNameMap == null) {
                elementTypeNameMap = new HashMap();
            }
            Object var1_1 = null;
            IConfigManager iConfigManager = ProductRetriever.retrieveProduct().getConfigManager();
            String string = iConfigManager.getDefaultConfigLocation();
            m_doc = XMLManip.getDOMDocument(string = string + "NewDialogDefinitions.etc");
            Node node = m_doc.selectSingleNode("//PropertyDefinitions/PropertyDefinition");
            if (node != null) {
                String string2 = "";
                Element element = (Element)node;
                String string3 = element.attributeValue("name");
                List list = m_doc.selectNodes("//PropertyDefinition/aDefinition[@name='Element']/aDefinition");
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Element element2 = (Element)list.get(i);
                    string2 = element2.attributeValue("displayName");
                    elementTypeNameMap.put(this.bundle.getString(string2), element2.attributeValue("name"));
                }
            }
        }
    }

    private void populateList() {
        this.getElementListFromConfigFile();
        if (this.elementTypeList != null) {
            TreeSet treeSet = new TreeSet(elementTypeNameMap.keySet());
            if (treeSet != null) {
                this.elementTypeList.setListData(treeSet.toArray());
            }
            this.elementTypeList.setSelectedIndex(0);
        }
    }

    private void populateCombobox() {
        if (this.nameSpaceComboBox != null && this.mDetails != null) {
            NewDialogUtilities.loadNamespace(this.nameSpaceComboBox, this.mDetails.getNamespace());
        }
    }

    protected String getElementName() {
        return this.elementNameTextField.getText().trim();
    }

    protected Object getSelectedNamespace() {
        return this.nameSpaceComboBox.getSelectedItem();
    }

    protected Object getSelectedListElement() {
        return this.elementTypeList.getSelectedValue();
    }

    protected int getSelectedListIndex() {
        return this.elementTypeList.getSelectedIndex();
    }

    public boolean isValid(WizardDescriptor wizardDescriptor) {
        Object object;
        String string;
        int n;
        boolean bl = true;
        String string2 = "";
        String string3 = (String)this.getSelectedListElement();
        if (string3 == null || string3.length() == 0) {
            string2 = this.bundle.getString("IDS_PLEASESELECTAELEMENT");
            bl = false;
        }
        if (bl && (n = (string = ((String)(object = this.getElementName())).trim()).length()) == 0) {
            string2 = this.bundle.getString("IDS_PLEASEENTERELEMENTNAME");
            bl = false;
        }
        if (bl && (object = NewDialogUtilities.getNamespace((String)this.getSelectedNamespace())) != null) {
            string = (String)this.getSelectedListElement();
            String string4 = (String)elementTypeNameMap.get(string);
            if (Util.hasNameCollision((INamespace)object, this.getElementName(), string4, null)) {
                string2 = this.bundle.getString("IDS_NAMESPACECOLLISION");
                bl = false;
            }
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string2);
        return bl;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.panel != null) {
            this.panel.fireChangeEvent();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.panel != null) {
            this.panel.fireChangeEvent();
        }
    }

    class ElementListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        ElementListCellRenderer() {
        }

        public Icon getImageIcon(String string) {
            Icon icon = null;
            String string2 = NewDialogResources.getStringKey(string);
            String string3 = "//PropertyDefinition/aDefinition[@name='Element']/aDefinition[@displayName='" + string2 + "']";
            Node node = m_doc.selectSingleNode(string3);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String string4 = element.attributeValue("image");
                File file = new File(string4);
                icon = CommonResourceManager.instance().getIconForFile(string4);
            }
            return icon;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            this.setIcon(this.getImageIcon(string));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

