/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.addins.diagramcreator;

import java.util.HashMap;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.dynamics.IInteraction;
import org.netbeans.modules.uml.core.metamodel.dynamics.IInteractionOperand;
import org.netbeans.modules.uml.core.metamodel.dynamics.ILifeline;
import org.netbeans.modules.uml.core.metamodel.dynamics.IMessage;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.diagramengines.sequencediagram.IMessageEdgeDrawEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHelper {
    private IInteraction m_interaction;
    private ETList<IMessage> m_messages;
    private int m_iMessageCnt;
    private HashMap<IMessage, IMessage> m_mapMessageToResult = new HashMap();
    private HashMap<String, IMessageEdgeDrawEngine> m_mapMessageToDE = new HashMap();
    private final int NEEDS_UPDATE = -1;

    public MessageHelper(IInteraction iInteraction) {
        this.m_interaction = iInteraction;
        this.m_iMessageCnt = -1;
        this.getInteraction();
    }

    public IInteraction getInteraction() {
        if (null == this.m_interaction) {
            throw new IllegalStateException();
        }
        return this.m_interaction;
    }

    public ETList<IMessage> getMessages() {
        return this.getMessages(false);
    }

    public ETList<IMessage> getMessages(boolean bl) {
        if (bl || null == this.m_messages) {
            this.m_messages = this.getInteraction().getMessages();
            this.m_iMessageCnt = -1;
        }
        if (null == this.m_messages) {
            throw new IllegalStateException();
        }
        return this.m_messages;
    }

    public int getMessageCnt() {
        if (-1 == this.m_iMessageCnt) {
            this.m_iMessageCnt = this.getMessages().getCount();
        }
        return this.m_iMessageCnt;
    }

    public IMessage getResultMessage(IMessage iMessage) {
        return this.m_mapMessageToResult.get(iMessage);
    }

    public void validateInteraction() {
        this.prepareMapMessageToResult();
        for (int i = 0; i < this.getMessageCnt(); ++i) {
            int n;
            IMessage iMessage = (IMessage)this.getMessages().get(i);
            if (iMessage == null || 1 != (n = iMessage.getKind())) continue;
            i = this.ensureCorrespondingResultMessage(iMessage, i);
        }
    }

    public void rememberMessageDE(IMessage iMessage, IMessageEdgeDrawEngine iMessageEdgeDrawEngine) {
        String string = this.getXmiID(iMessage);
        this.m_mapMessageToDE.put(string, iMessageEdgeDrawEngine);
    }

    public IMessageEdgeDrawEngine getMessageEdgeDE(IMessage iMessage) {
        Object var2_2 = null;
        String string = this.getXmiID(iMessage);
        return this.m_mapMessageToDE.get(string);
    }

    protected void prepareMapMessageToResult() {
        int n = this.getMessageCnt();
        for (int i = 0; i < n; ++i) {
            IMessage iMessage;
            IMessage iMessage2 = (IMessage)this.getMessages().get(i);
            if (iMessage2 == null || (iMessage = iMessage2.getSendingMessage()) == null) continue;
            this.m_mapMessageToResult.put(iMessage, iMessage2);
        }
    }

    protected int ensureCorrespondingResultMessage(IMessage iMessage, int n) {
        if (null == iMessage) {
            throw new IllegalArgumentException();
        }
        int n2 = n++;
        ILifeline iLifeline = iMessage.getSendingLifeline();
        ILifeline iLifeline2 = iMessage.getReceivingLifeline();
        if (iLifeline != null && iLifeline2 != null) {
            while (n < this.getMessageCnt()) {
                IMessage iMessage2 = (IMessage)this.getMessages().get(n);
                if (iMessage2 != null) {
                    int n3 = iMessage2.getKind();
                    switch (n3) {
                        case 1: {
                            ILifeline iLifeline3 = iMessage2.getSendingLifeline();
                            if (iLifeline3 == null) break;
                            boolean bl = iLifeline2.isSame(iLifeline3);
                            if (bl) {
                                n = this.ensureCorrespondingResultMessage(iMessage2, n);
                                break;
                            }
                            return this.createResultMessage(iMessage, n2, n);
                        }
                        case 3: {
                            boolean bl;
                            ILifeline iLifeline3 = iMessage2.getSendingLifeline();
                            if (iLifeline3 != null && (bl = iLifeline2.isSame(iLifeline3)) && (iLifeline3 = iMessage2.getReceivingLifeline()) != null && (bl = iLifeline.isSame(iLifeline3))) {
                                return n;
                            }
                            return this.createResultMessage(iMessage, n2, n);
                        }
                        case 0: 
                        case 2: {
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                }
                ++n;
            }
            n = this.createResultMessage(iMessage, n2, n);
        }
        return n;
    }

    protected int createResultMessage(IMessage iMessage, int n, int n2) {
        if (null == iMessage) {
            throw new IllegalArgumentException();
        }
        if (this.getResultMessage(iMessage) != null) {
            return n2;
        }
        ILifeline iLifeline = iMessage.getSendingLifeline();
        ILifeline iLifeline2 = iMessage.getReceivingLifeline();
        IInteractionOperand iInteractionOperand = iMessage.getInteractionOperand();
        if (iLifeline != null && iLifeline2 != null) {
            IMessage iMessage2;
            boolean bl = iLifeline.isSame(iLifeline2);
            if (bl) {
                n2 = n + 1;
            }
            IMessage iMessage3 = null;
            if (n2 < this.getMessageCnt()) {
                iMessage3 = (IMessage)this.getMessages().get(n2);
            }
            if ((iMessage2 = iLifeline2.insertMessage(iMessage3, iInteractionOperand, iLifeline, iInteractionOperand, null, 3)) != null) {
                iMessage2.setSendingMessage(iMessage);
                this.m_mapMessageToResult.put(iMessage, iMessage2);
            }
            this.getMessages(true);
        }
        return n2;
    }

    protected String getXmiID(IElement iElement) {
        return iElement.getXMIID();
    }

    private void dumpMessages() {
        ETList<IMessage> eTList;
        if (this.m_interaction != null && (eTList = this.m_interaction.getMessages()) != null) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = eTList.getCount();
            for (int i = 0; i < n4; ++i) {
                IMessage iMessage = eTList.item(i);
                if (iMessage == null) continue;
                ILifeline iLifeline = iMessage.getSendingLifeline();
                ILifeline iLifeline2 = iMessage.getReceivingLifeline();
                if (iLifeline == null || iLifeline2 == null) continue;
                int n5 = iMessage.getKind();
                if (3 == n5) {
                    --n;
                    ++n3;
                }
                assert (n >= 0);
                String string = iMessage.getXMIID();
                String string2 = iLifeline.getXMIID();
                String string3 = iLifeline2.getXMIID();
                for (int j = 0; j < n; ++j) {
                    ETSystem.out.print("   ");
                }
                ETSystem.out.print("(" + n5 + " " + string + ") ");
                switch (n5) {
                    case 0: {
                        ETSystem.out.println(string2 + " -! " + string3);
                        break;
                    }
                    case 1: {
                        ETSystem.out.println(string2 + " -> " + string3);
                        break;
                    }
                    case 2: {
                        ETSystem.out.println(string2 + " >> " + string3);
                        break;
                    }
                    case 3: {
                        ETSystem.out.println(string3 + " <- " + string2);
                        String string4 = "";
                        IMessage iMessage2 = iMessage.getSendingMessage();
                        if (iMessage2 != null) {
                            string4 = iMessage2.getXMIID();
                        }
                        ETSystem.out.println("(" + string4 + ")");
                    }
                }
                if (1 != n5) continue;
                ++n;
                ++n2;
            }
            assert (n3 == n2);
        }
    }
}

