/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.resources.images;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class ImageUtil {
    public static final String EXT_PNG = ".png";
    public static final String EXT_GIF = ".gif";
    public static final String IMAGE_FOLDER_FOR_OS = "org" + File.separatorChar + "netbeans" + File.separatorChar + "modules" + File.separatorChar + "uml" + File.separatorChar + "resources" + File.separatorChar + "images" + File.separatorChar;
    public static final String IMAGE_FOLDER = "org/netbeans/modules/uml/resources/images/";
    public static final String IMAGE_PACKAGE = "org.netbeans.modules.uml.resources.images";
    public static final String DIAGRAM_ICON_DEFAULT = "diagrams-root-node.png";
    public static final String DIAGRAM_ICON_ACTIVITY = "activity-diagram.png";
    public static final String DIAGRAM_ICON_CLASS = "class-diagram.png";
    public static final String DIAGRAM_ICON_COLLABORATION = "collaboration-diagram.png";
    public static final String DIAGRAM_ICON_COMPONENT = "component-diagram.png";
    public static final String DIAGRAM_ICON_DEPLOYMENT = "deployment-diagram.png";
    public static final String DIAGRAM_ICON_SEQUENCE = "sequence-diagram.png";
    public static final String DIAGRAM_ICON_STATE = "state-diagram.png";
    public static final String DIAGRAM_ICON_USECASE = "use-case-diagram.png";
    private static ImageUtil self = null;

    private ImageUtil() {
    }

    public static ImageUtil instance() {
        if (self == null) {
            self = new ImageUtil();
        }
        return self;
    }

    public FileInputStream getImageFileInputStream(String string) {
        try {
            URL uRL = this.getClass().getResource(string);
            if (uRL == null) {
                throw new ImageFileNotFoundException("Image file \"" + string + "\" could not be found in the images folder: " + IMAGE_FOLDER);
            }
            return new FileInputStream(uRL.getPath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
            return null;
        }
    }

    public File getImageFile(String string) {
        return InstalledFileLocator.getDefault().locate(string, "org.netbeans.modules.uml", false);
    }

    public Icon getIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            throw new ImageFileNotFoundException("Image file \"" + string + "\" could not be found in the images folder: " + IMAGE_FOLDER);
        }
        return new ImageIcon(uRL);
    }

    public Icon getIcon(String string, boolean bl) {
        if (bl) {
            return this.getIcon(string);
        }
        Icon icon = this.getIcon(string + EXT_PNG);
        if (icon == null) {
            icon = this.getIcon(string + EXT_GIF);
        }
        return icon;
    }

    public String getDiagramTypeImageName(int n) {
        switch (n) {
            case 2: {
                return DIAGRAM_ICON_ACTIVITY;
            }
            case 4: {
                return DIAGRAM_ICON_CLASS;
            }
            case 8: {
                return DIAGRAM_ICON_COLLABORATION;
            }
            case 16: {
                return DIAGRAM_ICON_COMPONENT;
            }
            case 32: {
                return DIAGRAM_ICON_DEPLOYMENT;
            }
            case 64: {
                return DIAGRAM_ICON_SEQUENCE;
            }
            case 128: {
                return DIAGRAM_ICON_STATE;
            }
            case 256: {
                return DIAGRAM_ICON_USECASE;
            }
        }
        return DIAGRAM_ICON_DEFAULT;
    }

    public Icon getDiagramTypeIcon(int n) {
        return this.getIcon(this.getDiagramTypeImageName(n));
    }

    class ImageFileNotFoundException
    extends RuntimeException {
        public ImageFileNotFoundException() {
        }

        public ImageFileNotFoundException(String string) {
            super(string);
        }
    }
}

