/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.support.umlsupport;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.IDResolver;
import org.dom4j.InvalidXPathException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultDocument;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.metamodel.structure.Project;
import org.netbeans.modules.uml.core.support.UMLLogger;
import org.netbeans.modules.uml.core.support.umlsupport.RandomGUID;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.UMLSupportResource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.DOMException;

public class XMLManip {
    private static final String loggerName = "uml.core.support.umlsupport.XMLManip";
    private static HashMap<String, Namespace> m_Namespaces = new HashMap();
    private static Document m_XMIFragment;
    private static DocumentBuilderFactory dbf;
    private static DocumentBuilder db;
    private static XMLManip xmlManip;
    private static HashMap<String, WeakReference> m_LoadedDocs;
    private static HashMap<String, Long> m_LoadedDocsTimestamps;
    private static HashMap<String, XPath> cachedXPaths;

    public static XMLManip instance() {
        if (xmlManip == null) {
            xmlManip = new XMLManip();
        }
        return xmlManip;
    }

    private XMLManip() {
        try {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            UMLLogger.logException(loggerName, (Throwable)parserConfigurationException, Level.WARNING);
        }
    }

    public static Element findElementByID(Branch branch, String string) {
        if (branch == null || string == null) {
            return null;
        }
        Element element = branch.elementByID(string);
        return element;
    }

    public static Document getDOMDocument(String string) {
        return XMLManip.getDOMDocument(string, new IDResolver("xmi.id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDOMDocument(String string, IDResolver iDResolver) {
        Document document = null;
        if (string != null && string.length() > 0) {
            File file = new File(string);
            if (!file.exists()) {
                return document;
            }
            InputStreamReader inputStreamReader = null;
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null && fileObject.getSize() > 0L) {
                try {
                    SAXReader sAXReader = new SAXReader(DOMDocumentFactory.getInstance(), false);
                    sAXReader.setIDResolver(iDResolver);
                    inputStreamReader = new InputStreamReader(fileObject.getInputStream());
                    document = sAXReader.read((Reader)inputStreamReader);
                }
                catch (Exception exception) {
                    UMLLogger.logException(loggerName, (Throwable)exception, Level.WARNING);
                }
                finally {
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException) {
                            UMLLogger.logMessage(loggerName, iOException.getMessage(), Level.WARNING);
                        }
                    }
                }
            }
        }
        return document;
    }

    public static Document getDOMDocumentUseWeakCache(String string) {
        Document document = null;
        if (string != null && string.length() > 0) {
            WeakReference weakReference = m_LoadedDocs.get(string);
            if (weakReference != null) {
                document = (Document)weakReference.get();
            }
            long l = -1L;
            Long l2 = m_LoadedDocsTimestamps.get(string);
            if (l2 != null) {
                l = l2;
            }
            long l3 = new File(string).lastModified();
            if (document == null || l3 > l) {
                document = XMLManip.getDOMDocument(string);
                m_LoadedDocs.put(string, new WeakReference<Document>(document));
                m_LoadedDocsTimestamps.put(string, new Long(l3));
            }
        }
        return document;
    }

    public static Document getDOMDocument() {
        return XMLManip.getDOMDocument(new IDResolver("xmi.id"));
    }

    public static Document getDOMDocument(IDResolver iDResolver) {
        Document document = null;
        try {
            document = DOMDocumentFactory.getInstance().createDocument();
            document.setIDResolver(iDResolver);
            if (document != null) {
                Element element = DOMDocumentFactory.getInstance().createElement("");
                document.setRootElement(element);
                Namespace namespace = DOMDocumentFactory.getInstance().createNamespace("UML", "omg.org/UML/1.4");
                Namespace namespace2 = DOMDocumentFactory.getInstance().createNamespace("EMBT", "www.sun.com");
                element.add(namespace);
                element.add(namespace2);
            }
        }
        catch (Exception exception) {
            UMLLogger.logException(loggerName, (Throwable)exception, Level.WARNING);
        }
        return document;
    }

    public static Document getDOMDocumentFromString(String string) {
        Document document = null;
        try {
            if (string != null && string.length() > 0) {
                SAXReader sAXReader = new SAXReader(DOMDocumentFactory.getInstance(), false);
                document = sAXReader.read(string);
            }
        }
        catch (Exception exception) {
            UMLLogger.logException(loggerName, (Throwable)exception, Level.WARNING);
        }
        return document;
    }

    public static String getAttributeValue(Attribute attribute) {
        String string = attribute.getText();
        return string;
    }

    public static String getAttributeValue(Node node, String string) {
        String string2 = null;
        try {
            if (node != null && node.getNodeType() == 1) {
                Element element = (Element)node;
                string2 = element.attributeValue(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2 != null ? string2 : "";
    }

    public static boolean getAttributeBooleanValue(Node node, String string) {
        return XMLManip.getAttributeBooleanValue(node, string, false);
    }

    public static boolean getAttributeBooleanValue(Node node, String string, boolean bl) {
        String string2;
        boolean bl2 = bl;
        if (node != null && (string2 = XMLManip.getAttributeValue(node, string)) != null && string2.length() > 0) {
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    public static int getAttributeIntValue(Node node, String string) throws NumberFormatException {
        String string2;
        int n = 0;
        if (node != null && (string2 = XMLManip.getAttributeValue(node, string)).length() > 0) {
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public static double getAttributeDoubleValue(Node node, String string) throws NumberFormatException {
        String string2;
        double d = 0.0;
        if (node != null && (string2 = XMLManip.getAttributeValue(node, string)).length() > 0) {
            d = Double.parseDouble(string2);
        }
        return d;
    }

    public static void setAttributeValue(Element element, String string, String string2) {
        if (element != null) {
            if (string2 != null) {
                XMLManip.checkForIllegals(string2);
                element.addAttribute(string, string2);
            } else {
                Attribute attribute = element.attribute(string);
                if (attribute != null) {
                    element.remove(attribute);
                }
            }
        }
    }

    public static void setAttributeValue(Node node, String string, String string2) {
        if (node instanceof Element) {
            Element element = (Element)node;
            XMLManip.setAttributeValue(element, string, string2);
        }
    }

    public static String checkForIllegals(String string) {
        String string2 = string;
        if (string.length() > 0) {
            int n = string.indexOf(38);
            if (n >= 0) {
                string2 = XMLManip.processIllegalCharacter(string2, '&');
            }
            if ((n = string.indexOf(60)) >= 0) {
                string2 = XMLManip.processIllegalCharacter(string2, '<');
            }
            if ((n = string.indexOf(62)) >= 0) {
                string2 = XMLManip.processIllegalCharacter(string2, '>');
            }
        }
        return string2;
    }

    private static String processIllegalCharacter(String string, char c) {
        String string2 = string;
        if (c == '&') {
            string2 = StringUtilities.splice(string, "&", "&amp;");
        }
        if (c == '<') {
            string2 = StringUtilities.splice(string, "<", "&lt;");
        }
        if (c == '>') {
            string2 = StringUtilities.splice(string, ">", "&gt;");
        }
        return string2;
    }

    public static String retrieveDCEID() {
        String string = "";
        RandomGUID randomGUID = new RandomGUID();
        string = "DCE." + randomGUID.toString();
        return string;
    }

    public static void insertNode(Element element, Node node, int n) {
        node.detach();
        List list = element.elements();
        if (n >= list.size() || n < 0) {
            element.add(node);
            return;
        }
        list.add(n, node);
        if (element.getDocument() instanceof DefaultDocument) {
            Element element2;
            Attribute attribute;
            DefaultDocument defaultDocument = (DefaultDocument)element.getDocument();
            if (node instanceof DefaultDocument) {
                DefaultDocument defaultDocument2 = (DefaultDocument)node;
                defaultDocument.setIDTable(defaultDocument2);
            } else if (node instanceof Element && (attribute = (element2 = (Element)node).attribute("xmi.id")) != null) {
                defaultDocument.addIDtoTable(attribute.getValue(), (Node)element2);
            }
        }
    }

    public static void insertNode(Element element, Node node, Node node2) {
        node.detach();
        List list = element.elements();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Node node3 = (Node)list.get(i);
            if (!node3.equals(node2)) continue;
            list.add(i, node);
            return;
        }
        element.add(node);
    }

    public static Node getAttribute(Node node, String string) {
        Attribute attribute = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            attribute = element.attribute(string);
        }
        return attribute;
    }

    public static Node selectSingleNode(Node node, String string) {
        Node node2 = null;
        if (node != null && string != null) {
            node2 = node.selectSingleNode(string);
        }
        return node2;
    }

    public static List selectNodeList(Node node, String string) {
        List list = null;
        if (node != null) {
            try {
                list = node.selectNodes(string);
            }
            catch (InvalidXPathException invalidXPathException) {
                UMLLogger.logException(loggerName, (Throwable)invalidXPathException, Level.WARNING);
            }
        }
        return list;
    }

    public static List selectNodeListNS(Node node, String string) {
        List list = null;
        if (node != null) {
            Document document = null;
            document = node.getNodeType() == 9 ? (Document)node : node.getDocument();
            list = document.selectNodes(string);
        }
        return list;
    }

    public static Document loadXML(String string) {
        return XMLManip.loadXML(string, false, new IDResolver("xmi.id"));
    }

    public static Document loadXML(String string, boolean bl) {
        return XMLManip.loadXML(string, bl, new IDResolver("xmi.id"));
    }

    public static Document loadXML(String string, IDResolver iDResolver) {
        return XMLManip.loadXML(string, false, iDResolver);
    }

    public static Document loadXML(String string, boolean bl, IDResolver iDResolver) {
        try {
            SAXReader sAXReader = new SAXReader(DOMDocumentFactory.getInstance(), bl, iDResolver);
            return sAXReader.read((Reader)new StringReader(string));
        }
        catch (Exception exception) {
            UMLLogger.logException(loggerName, (Throwable)exception, Level.WARNING);
            return null;
        }
    }

    public static String getString(String string) {
        return null;
    }

    public static String getString(String string, Object[] objectArray) {
        String string2 = XMLManip.getString(string);
        return objectArray != null ? MessageFormat.format(string2, objectArray) : string2;
    }

    public static String retrieveNodeTextValue(Node node, String string) {
        try {
            Node node2 = node.selectSingleNode(string);
            if (node2 != null) {
                return node2.getText();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static Node removeChild(Node node, String string) {
        Node node2 = null;
        try {
            Node node3 = node.selectSingleNode(string);
            if (node3 != null) {
                node2 = XMLManip.removeNode(node, node3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return node2;
    }

    private static Node removeNode(Node node, Node node2) {
        Node node3 = null;
        if (node2 != null && node != null) {
            node3 = node2.detach();
        }
        return node3;
    }

    public static String retrieveSimpleName(Node node) {
        String string;
        String string2 = "";
        if (node != null && (string = node.getName()) != null && string.length() > 0) {
            int n = string.indexOf(":");
            string2 = n >= 0 ? string.substring(n + 1) : string;
        }
        return string2;
    }

    public static void setNodeTextValue(Node node, String string, String string2, boolean bl) {
        Node node2 = XMLManip.ensureNodeExists(node, string, string);
        if (node2 != null) {
            node2.setText(XMLManip.removeIllegalXMLChars(string2));
        }
    }

    private static String removeIllegalXMLChars(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' && c != '\t' && c != '\n' && c != '\r') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static Node ensureNodeExists(Node node, String string, String string2) {
        Node node2 = null;
        try {
            Document document;
            node2 = node.selectSingleNode(string2);
            if (node2 == null && (document = node.getDocument()) != null) {
                node2 = document.getRootElement().addElement(string);
                XMLManip.appendNewLineElement(node, document);
                node2.detach();
                ((Element)node).add(node2);
            }
        }
        catch (Exception exception) {
            UMLLogger.logException(loggerName, (Throwable)exception, Level.WARNING);
        }
        return node2;
    }

    public static void appendNewLineElement(Node node, Document document) {
        if (node instanceof Element) {
            ((Element)node).addText("\n");
        }
    }

    public static Element createElement(Element element, String string, String string2) {
        Element element2 = null;
        if (string.length() <= 0) {
            throw new NullPointerException(UMLSupportResource.getString("INVALID_CREATE_ELEMENT_PARAM"));
        }
        int n = string.indexOf(58);
        if ((string2 == null || string2.length() == 0) && n > 0) {
            QName qName = XMLManip.getQName(element, string);
            element2 = DOMDocumentFactory.getInstance().createElement(qName);
        } else if (string2.length() > 0 && n > 0) {
            String string3 = string.substring(0, n);
            Namespace namespace = DOMDocumentFactory.getInstance().createNamespace(string3, string2);
            QName qName = DOMDocumentFactory.getInstance().createQName(string.substring(n + 1), namespace);
            element2 = DOMDocumentFactory.getInstance().createElement(qName);
        } else {
            element2 = DOMDocumentFactory.getInstance().createElement(string);
        }
        if (element != null && element2 != null) {
            element.add(element2);
        }
        return element2;
    }

    public static Element createElement(Document document, String string, String string2) {
        Element element = null;
        if (string.length() <= 0) {
            throw new NullPointerException(UMLSupportResource.getString("INVALID_CREATE_ELEMENT_PARAM"));
        }
        int n = string.indexOf(58);
        if ((string2 == null || string2.length() == 0) && n > 0) {
            QName qName = XMLManip.getQName(document.getRootElement(), string);
            element = DOMDocumentFactory.getInstance().createElement(qName);
        } else if (string2.length() > 0 && n > 0) {
            StringBuffer stringBuffer = new StringBuffer("http://");
            stringBuffer.append(string2);
            String string3 = string.substring(0, n);
            Namespace namespace = DOMDocumentFactory.getInstance().createNamespace(string3, stringBuffer.toString());
            QName qName = DOMDocumentFactory.getInstance().createQName(string.substring(n + 1), namespace);
            element = DOMDocumentFactory.getInstance().createElement(qName);
        } else {
            element = DOMDocumentFactory.getInstance().createElement(string);
        }
        return element;
    }

    public static QName getQName(Element element, String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return new QName(string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Namespace namespace = XMLManip.getNamespace(element, string2);
        return namespace == null ? new QName(string) : new QName(string3, namespace, string);
    }

    public static Namespace getNamespace(Element element, String string) {
        Namespace namespace = null;
        if (string == null) {
            return null;
        }
        if (m_Namespaces.containsKey(string)) {
            return m_Namespaces.get(string);
        }
        if (element != null) {
            return element.getNamespaceForPrefix(string);
        }
        if (m_XMIFragment == null) {
            Project project = new Project();
            project.establishXMIHeaderInfo();
            m_XMIFragment = project.getDocument();
        }
        if (m_XMIFragment != null) {
            namespace = XMLManip.walkTree(m_XMIFragment.getRootElement(), string);
            m_Namespaces.put(string, namespace);
        }
        return namespace;
    }

    private static Namespace walkTree(Element element, String string) {
        if (string.equals(element.getNamespacePrefix())) {
            return element.getNamespace();
        }
        Namespace namespace = element.getNamespaceForPrefix(string);
        if (namespace != null) {
            return namespace;
        }
        for (int i = element.nodeCount() - 1; i >= 0; --i) {
            Node node = element.node(i);
            if (!(node instanceof Element)) continue;
            XMLManip.walkTree((Element)node, string);
        }
        return null;
    }

    public static Element createElement(Element element, String string) throws DOMException {
        Element element2 = null;
        if (element == null || string.length() <= 0) {
            throw new NullPointerException(UMLSupportResource.getString("INVALID_CREATE_ELEMENT_PARAM"));
        }
        String string2 = "";
        element2 = XMLManip.createElement(element.getDocument(), string, string2);
        if (element2 != null) {
            element2.detach();
            element.add(element2);
        }
        return element2;
    }

    public static Element createElement(Document document, String string) {
        if (document == null || string.length() <= 0) {
            throw new NullPointerException(UMLSupportResource.getString("INVALID_CREATE_ELEMENT_PARAM"));
        }
        Element element = XMLManip.createElement(document, string, "");
        if (element != null) {
            if (document.getRootElement() == null) {
                document.add(element);
            } else {
                document.getRootElement().add(element);
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveNodePretty(Node node, String string) {
        FileObject fileObject;
        if (string != null && string.trim().length() > 0 && (fileObject = FileUtil.toFileObject((File)new File(string))) != null) {
            OutputStreamWriter outputStreamWriter = null;
            XMLWriter xMLWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream());
                xMLWriter = new XMLWriter((Writer)outputStreamWriter, OutputFormat.createPrettyPrint());
                xMLWriter.write(node);
                xMLWriter.flush();
            }
            catch (Exception exception) {
                UMLLogger.logException(loggerName, (Throwable)exception, Level.WARNING);
            }
            finally {
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    if (xMLWriter != null) {
                        xMLWriter.close();
                    }
                }
                catch (IOException iOException) {
                    UMLLogger.logMessage(loggerName, iOException.getMessage(), Level.WARNING);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveNode(Node node, String string) {
        FileObject fileObject;
        if (string != null && string.trim().length() > 0 && (fileObject = FileUtil.toFileObject((File)new File(string))) != null) {
            OutputStreamWriter outputStreamWriter = null;
            XMLWriter xMLWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream());
                OutputFormat outputFormat = new OutputFormat();
                outputFormat.setNewlines(true);
                xMLWriter = new XMLWriter((Writer)outputStreamWriter, outputFormat);
                xMLWriter.write(node);
                xMLWriter.flush();
            }
            catch (Exception exception) {
                UMLLogger.logException(loggerName, (Throwable)exception, Level.WARNING);
            }
            finally {
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    if (xMLWriter != null) {
                        xMLWriter.close();
                    }
                }
                catch (IOException iOException) {
                    UMLLogger.logMessage(loggerName, iOException.getMessage(), Level.WARNING);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(Document document, String string) {
        boolean bl = false;
        if (string != null && string.trim().length() > 0) {
            OutputStreamWriter outputStreamWriter = null;
            BufferedWriter bufferedWriter = null;
            try {
                FileObject fileObject = FileUtil.createData((File)new File(string));
                outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream());
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                bufferedWriter.write(document.asXML(), 0, document.asXML().length());
                bufferedWriter.flush();
                bl = true;
            }
            catch (Exception exception) {
                UMLLogger.logException(loggerName, (Throwable)exception, Level.WARNING);
            }
            finally {
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    UMLLogger.logMessage(loggerName, iOException.getMessage(), Level.WARNING);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean savePretty(Document document, String string) {
        boolean bl = false;
        if (string != null && string.trim().length() > 0) {
            OutputStreamWriter outputStreamWriter = null;
            XMLWriter xMLWriter = null;
            try {
                FileObject fileObject = FileUtil.createData((File)new File(string));
                outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream());
                xMLWriter = new XMLWriter((Writer)outputStreamWriter, OutputFormat.createPrettyPrint());
                xMLWriter.write(document);
                xMLWriter.flush();
                bl = true;
            }
            catch (Exception exception) {
                UMLLogger.logException(loggerName, (Throwable)exception, Level.WARNING);
            }
            finally {
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    if (xMLWriter != null) {
                        xMLWriter.close();
                    }
                }
                catch (IOException iOException) {
                    UMLLogger.logMessage(loggerName, iOException.getMessage(), Level.WARNING);
                }
            }
        }
        return bl;
    }

    public static void DebugXML(Element element, boolean bl) {
        if (bl) {
            ETSystem.out.println(element.asXML());
        }
    }

    public static void removeAllChildNodes(Element element) {
        List list;
        if (element != null && (list = element.selectNodes(".//*")) != null) {
            int n = list.size();
            for (int i = n - 1; i >= 0; --i) {
                Node node = (Node)list.get(i);
                element.remove(node);
            }
        }
    }

    public static Node getFirstChild(Node node) {
        Element element;
        if (node instanceof Element && (element = (Element)node).nodeCount() > 0) {
            return element.node(0);
        }
        return null;
    }

    public static List selectAncestorNodesByAttribute(Node node, String string, String string2) {
        Vector<Element> vector = new Vector<Element>();
        if (node != null && string != null && !string.equals("") && string2 != null) {
            for (Element element = node.getParent(); element != null; element = element.getParent()) {
                Element element2;
                String string3;
                if (!(element instanceof Element) || (string3 = (element2 = element).attributeValue(string)) == null || !string2.equals(string3)) continue;
                vector.add(element2);
            }
        }
        return vector;
    }

    public static XPath getCreateCachedXPath(String string) {
        DocumentFactory documentFactory;
        XPath xPath;
        if (cachedXPaths == null) {
            cachedXPaths = new HashMap();
        }
        if ((xPath = cachedXPaths.get(string)) == null && (xPath = (documentFactory = DOMDocumentFactory.getInstance()).createXPath(string)) != null) {
            cachedXPaths.put(string, xPath);
        }
        return xPath;
    }

    public static void clearCachedXPaths() {
        cachedXPaths = null;
    }

    static {
        dbf = null;
        db = null;
        xmlManip = new XMLManip();
        m_LoadedDocs = new HashMap();
        m_LoadedDocsTimestamps = new HashMap();
    }
}

