/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.support.umlsupport;

import java.io.PrintWriter;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.coreapplication.IPreferenceManager2;
import org.netbeans.modules.uml.ui.support.ProductHelper;

public class Log {
    private static PrintWriter output = null;
    private static boolean initialized = false;
    private static final String LOG_PATH = "LoggingInformation";
    private static final String PREF_YES = "PSK_YES";
    public static final int MDR_EVENT_MASK_UNKNOWN = 0;
    public static final int MDR_EVENT_MASK_GENERAL = 7;
    public static final int MDR_EVENT_MASK_SPECIFIC = 248;
    public static final int MDR_EVENT_MASK_PLANNED = 1;
    public static final int MDR_EVENT_MASK_CANCELED = 2;
    public static final int MDR_EVENT_MASK_CHANGE = 4;
    public static final int MDR_EVENT_MASK_ATTRIBUTE = 8;
    public static final int MDR_EVENT_MASK_ASSOCIATE = 16;
    public static final int MDR_EVENT_MASK_EXTENT = 32;
    public static final int MDR_EVENT_MASK_INSTANCE = 64;
    public static final int MDR_EVENT_MASK_TRANSACTION = 128;
    public static final int MDR_EVENT_FLAG_RESET = 0;
    public static int mdrPlannedEventLogFlag = 0;
    public static int mdrCanceledEventLogFlag = 0;
    public static int mdrChangeEventLogFlag = 0;

    public static void reset() {
        mdrPlannedEventLogFlag = 0;
        mdrCanceledEventLogFlag = 0;
        mdrChangeEventLogFlag = 0;
    }

    public static void init() {
        Log.setPropertyFlags();
    }

    private static boolean initialized() {
        if (initialized) {
            return true;
        }
        Log.init();
        return initialized;
    }

    public static void write(String string) {
        Log.write(string, true);
    }

    public static void write(String string, boolean bl) {
        try {
            if (!initialized) {
                Log.init();
            }
            if (output != null) {
                if (bl) {
                    output.println(string);
                } else {
                    output.print(string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void out(String string) {
        if (!initialized) {
            Log.init();
        }
    }

    public static void banner(String string) {
    }

    public static void dumpStack(String string) {
        Log.stackTrace(new Throwable(string).fillInStackTrace());
    }

    public static void entry(String string) {
        if (!initialized) {
            Log.init();
        }
    }

    public static void exit(String string) {
    }

    public static void err(String string) {
        if (!initialized) {
            Log.init();
        }
    }

    public static void stackTrace(Throwable throwable) {
        if (!initialized) {
            Log.init();
        }
    }

    public static void impossible(String string) {
        Log.dumpStack(string);
    }

    public static void writeDescribeLogs(String string) {
        try {
            if (!initialized) {
                Log.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void mdrEventTrace(int n, String string, boolean bl) {
        if (!initialized) {
            Log.init();
        }
        if (Log.isMDREventEnabled(n)) {
            Log.write(System.currentTimeMillis() + " [MDR Event] " + string, bl);
        }
    }

    private static void setPropertyFlags() {
        IPreferenceManager2 iPreferenceManager2 = ProductHelper.getPreferenceManager();
        if (iPreferenceManager2 == null) {
            return;
        }
        String string = "LoggingInformation|LogMDREvents|LogMDRPlannedChangeEvents";
        String string2 = iPreferenceManager2.getPreferenceValue(string, "LogMDRAssociationEvents");
        String string3 = iPreferenceManager2.getPreferenceValue(string, "LogMDRAttributeEvents");
        String string4 = iPreferenceManager2.getPreferenceValue(string, "LogMDRExtentEvents");
        String string5 = iPreferenceManager2.getPreferenceValue(string, "LogMDRInstanceEvents");
        String string6 = iPreferenceManager2.getPreferenceValue(string, "LogMDRTransactionEvents");
        string = "LoggingInformation|LogMDREvents|LogMDRCanceledChangeEvents";
        String string7 = iPreferenceManager2.getPreferenceValue(string, "LogMDRAssociationEvents");
        String string8 = iPreferenceManager2.getPreferenceValue(string, "LogMDRAttributeEvents");
        String string9 = iPreferenceManager2.getPreferenceValue(string, "LogMDRExtentEvents");
        String string10 = iPreferenceManager2.getPreferenceValue(string, "LogMDRInstanceEvents");
        String string11 = iPreferenceManager2.getPreferenceValue(string, "LogMDRTransactionEvents");
        string = "LoggingInformation|LogMDREvents|LogMDRChangeEvents";
        String string12 = iPreferenceManager2.getPreferenceValue(string, "LogMDRAssociationEvents");
        String string13 = iPreferenceManager2.getPreferenceValue(string, "LogMDRAttributeEvents");
        String string14 = iPreferenceManager2.getPreferenceValue(string, "LogMDRExtentEvents");
        String string15 = iPreferenceManager2.getPreferenceValue(string, "LogMDRInstanceEvents");
        String string16 = iPreferenceManager2.getPreferenceValue(string, "LogMDRTransactionEvents");
        if (PREF_YES.equals(string2)) {
            mdrPlannedEventLogFlag |= 0x10;
        }
        if (PREF_YES.equals(string3)) {
            mdrPlannedEventLogFlag |= 8;
        }
        if (PREF_YES.equals(string4)) {
            mdrPlannedEventLogFlag |= 0x20;
        }
        if (PREF_YES.equals(string5)) {
            mdrPlannedEventLogFlag |= 0x40;
        }
        if (PREF_YES.equals(string6)) {
            mdrPlannedEventLogFlag |= 0x80;
        }
        if (PREF_YES.equals(string7)) {
            mdrCanceledEventLogFlag |= 0x10;
        }
        if (PREF_YES.equals(string8)) {
            mdrCanceledEventLogFlag |= 8;
        }
        if (PREF_YES.equals(string9)) {
            mdrCanceledEventLogFlag |= 0x20;
        }
        if (PREF_YES.equals(string10)) {
            mdrCanceledEventLogFlag |= 0x40;
        }
        if (PREF_YES.equals(string11)) {
            mdrCanceledEventLogFlag |= 0x80;
        }
        if (PREF_YES.equals(string12)) {
            mdrChangeEventLogFlag |= 0x10;
        }
        if (PREF_YES.equals(string13)) {
            mdrChangeEventLogFlag |= 8;
        }
        if (PREF_YES.equals(string14)) {
            mdrChangeEventLogFlag |= 0x20;
        }
        if (PREF_YES.equals(string15)) {
            mdrChangeEventLogFlag |= 0x40;
        }
        if (PREF_YES.equals(string16)) {
            mdrChangeEventLogFlag |= 0x80;
        }
        ETSystem.out.println("Log file not specified");
        if (output != null) {
            output.close();
            output = null;
        }
    }

    private static boolean isMDREventEnabled(int n) {
        int n2 = n & 7;
        int n3 = n & 0xF8;
        return n2 == 1 ? (mdrPlannedEventLogFlag & n3) > 0 : (n2 == 2 ? (mdrCanceledEventLogFlag & n3) > 0 : n2 == 4 && (mdrChangeEventLogFlag & n3) > 0);
    }
}

