/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.support.umlsupport;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.modules.uml.core.support.umlsupport.ETDeviceRect;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;

public class ETRect
extends Rectangle
implements IETRect {
    public ETRect() {
    }

    public ETRect(int n, int n2) {
        super(n, n2);
    }

    public ETRect(double d, double d2, double d3, double d4) {
        this((int)d, (int)d2, (int)d3, (int)d4);
    }

    public ETRect(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public ETRect(Dimension dimension) {
        super(dimension);
    }

    public ETRect(Point point) {
        super(point);
    }

    public ETRect(Rectangle rectangle) {
        super(rectangle);
    }

    protected ETRect(IETRect iETRect) {
        if (iETRect != null) {
            this.x = iETRect.getLeft();
            this.y = iETRect instanceof ETRect ? iETRect.getTop() : iETRect.getBottom();
            this.width = iETRect.getIntWidth();
            this.height = iETRect.getIntHeight();
        } else {
            this.setRectEmpty();
        }
    }

    public ETRect(Point point, Dimension dimension) {
        super(point, dimension);
    }

    public ETRect(Point point, Point point2) {
        super(point);
        this.add(point2);
    }

    public boolean doesIntersect(IETRect iETRect) {
        return iETRect != null ? this.intersects(iETRect.getRectangle()) : this.isZero();
    }

    public int getBottom() {
        return this.getIntY() - this.getIntHeight();
    }

    public int getIntHeight() {
        return this.height;
    }

    public int getIntWidth() {
        return this.width;
    }

    public int getIntX() {
        return this.x;
    }

    public int getIntY() {
        return this.y;
    }

    public int getLeft() {
        return this.getIntX();
    }

    public int getRight() {
        return this.getIntX() + this.getIntWidth();
    }

    public int getTop() {
        return this.getIntY();
    }

    public boolean intersectWith(IETRect iETRect) {
        return this.doesIntersect(iETRect);
    }

    public boolean isContained(IETRect iETRect) {
        return iETRect != null ? iETRect.contains(this) : false;
    }

    public void normalizeRect() {
        this.normalizeRect(true);
    }

    public void normalizeRect(boolean bl) {
        this.x = Math.min(this.getLeft(), this.getRight());
        this.y = bl ? Math.min(this.getTop(), this.getBottom()) : Math.max(this.getTop(), this.getBottom());
        if (this.width < 0) {
            this.x += this.width;
            this.width = -this.width;
        }
        if (this.height < 0) {
            this.y += this.height;
            this.height = -this.height;
        }
    }

    public void setSides(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = Math.abs(n3 - n);
        this.height = Math.abs(n4 - n2);
    }

    public void setBottom(int n) {
        this.height = Math.abs(n - this.y);
    }

    protected void changeY(int n) {
        int n2 = Math.min(this.y, n);
        int n3 = Math.max(this.y, n);
        this.y = n2;
        this.height = n3 - n2;
    }

    public void setLeft(int n) {
        this.x = n;
    }

    protected void changeX(int n) {
        int n2 = Math.min(this.x, n);
        int n3 = Math.max(this.x, n);
        this.x = n2;
        this.width = n3 - n2;
    }

    public void setRight(int n) {
        this.width = Math.abs(this.getLeft() - n);
    }

    public void setTop(int n) {
        this.y = n;
    }

    public void unionWith(IETRect iETRect) {
        if (iETRect != null) {
            if (this.isZero()) {
                this.x = iETRect.getLeft();
                this.y = iETRect instanceof ETRect ? iETRect.getTop() : iETRect.getBottom();
                this.width = iETRect.getIntWidth();
                this.height = iETRect.getIntHeight();
            } else {
                ETRect eTRect = new ETRect(iETRect);
                eTRect.normalizeRect(false);
                this.normalizeRect(false);
                int n = Math.max(this.getRight(), eTRect.getRight());
                int n2 = Math.min(this.getBottom(), eTRect.getBottom());
                this.x = Math.min(this.getLeft(), eTRect.getLeft());
                this.y = Math.max(this.getTop(), eTRect.getTop());
                this.height = this.y - n2;
                this.width = n - this.x;
            }
        }
    }

    public boolean contains(Point point) {
        return this.contains((double)point.x, (double)point.y);
    }

    public boolean contains(IETPoint iETPoint) {
        return iETPoint != null ? this.contains(iETPoint.asPoint()) : false;
    }

    public boolean contains(IETRect iETRect) {
        return this.contains(iETRect.getTopLeft()) && this.contains(iETRect.getBottomRight());
    }

    public boolean contains(double d, double d2) {
        return d >= (double)this.getLeft() && d <= (double)this.getRight() && d2 <= (double)this.getTop() && d2 >= (double)this.getBottom();
    }

    public String toString() {
        return "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public void inflate(int n) {
        this.inflate(n, n);
    }

    public void inflate(int n, int n2) {
        this.x -= n;
        this.y = this.getTop() > this.getBottom() ? (this.y += n2) : (this.y -= n2);
        this.width += n * 2;
        this.height += n2 * 2;
    }

    public Rectangle getRectangle() {
        return this;
    }

    public Point getTopLeft() {
        return new Point(this.getLeft(), this.getTop());
    }

    public Point getBottomRight() {
        return new Point(this.getRight(), this.getBottom());
    }

    public Point getTopRight() {
        return new Point(this.getRight(), this.getTop());
    }

    public Point getBottomLeft() {
        return new Point(this.getLeft(), this.getBottom());
    }

    public Point getCenterPoint() {
        return new Point((int)((double)this.getLeft() + this.getWidth() / 2.0), (this.getTop() + this.getBottom()) / 2);
    }

    public double getCenterY() {
        return (this.getTop() + this.getBottom()) / 2;
    }

    public void deflateRect(int n, int n2, int n3, int n4) {
        this.setLeft(this.getLeft() + n);
        this.setTop(this.getTop() + n2);
        this.setRight(this.getRight() - n3);
        this.setBottom(this.getBottom() - n4);
    }

    public void deflateRect(int n, int n2) {
        int n3 = Math.min(this.getTop(), this.getBottom()) + this.getIntHeight();
        int n4 = Math.max(this.getTop(), this.getBottom()) + this.getIntHeight();
        int n5 = this.getLeft();
        int n6 = this.getRight();
        this.setLeft(n5 + n);
        this.setTop(n3 + n2);
        this.setRight(n6 - n);
        this.setBottom(n4 - n2);
    }

    public boolean isZero() {
        return this.getX() == 0.0 && this.getY() == 0.0 && this.getWidth() == 0.0 && this.getHeight() == 0.0;
    }

    public void setCorners(IETPoint iETPoint, IETPoint iETPoint2) {
        this.setLeft(iETPoint.getX());
        this.setTop(iETPoint.getY());
        this.setRight(iETPoint2.getX());
        this.setBottom(iETPoint2.getY());
    }

    public void offsetRect(int n, int n2) {
        ETPoint eTPoint = new ETPoint(this.getLeft(), this.getTop());
        eTPoint.offset(n, n2);
        ETPoint eTPoint2 = new ETPoint(this.getBottom(), this.getRight());
        eTPoint2.offset(n, n2);
        this.setCorners(eTPoint, eTPoint2);
    }

    public void offsetRect(Point point) {
        this.offsetRect(point.x, point.y);
    }

    public void setRectEmpty() {
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
    }

    public static ETRect ensureLogicalRect(IETRect iETRect) {
        if (iETRect instanceof ETRect) {
            return (ETRect)iETRect;
        }
        return iETRect != null ? new ETRect(iETRect) : null;
    }

    public ETDeviceRect getAsDeviceRect() {
        return new ETDeviceRect(this.x, this.y, this.width, this.height);
    }

    public Object clone() {
        return new ETRect(this);
    }
}

