/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.support;

import java.beans.PropertyChangeEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.uml.core.support.IndentingParser;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

class DebugSupport {
    public static final String OUTPUT_TAB_NAME = "UML Module Debug";
    public static final String DISCRIMINATOR_TODO = "TODO";
    public static PrintWriter out = InputOutput.NULL.getOut();
    public static ErrorManager errorManager;
    private static InputOutput inputOutput;
    private static Set allowed;

    public static boolean isEnabled() {
        return Boolean.getBoolean("org.netbeans.modules.uml.debug");
    }

    static void initializeOut() {
        if (errorManager != null) {
            return;
        }
        if (DebugSupport.isEnabled()) {
            if (Boolean.getBoolean("org.netbeans.modules.uml.debug.usesystemout")) {
                out = new PrintWriter(System.out, true);
                out.println("Module debug enabled on System.out");
            } else if (Boolean.getBoolean("org.netbeans.modules.uml.debug.usesystemerr")) {
                out = new PrintWriter(System.err, true);
                out.println("Module debug enabled on System.err");
            } else {
                inputOutput = IOProvider.getDefault().getIO(OUTPUT_TAB_NAME, true);
                out = inputOutput.getOut();
            }
        }
        errorManager = ErrorManager.getDefault().getInstance("org.netbeans.modules.uml");
    }

    public static InputOutput getInputOutput() {
        return inputOutput;
    }

    public static void debugNotify(Throwable throwable) {
        if (DebugSupport.isEnabled()) {
            errorManager.notify(errorManager.annotate(throwable, "[DEBUG-only exception]"));
        }
    }

    public static void debugNotify(Throwable throwable, String string) {
        if (DebugSupport.isEnabled()) {
            errorManager.notify(errorManager.annotate(throwable, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpObject(Object object) {
        out.println("--- BEGIN OBJECT DUMP ---");
        out.println("    Object: " + object);
        try {
            if (object == null) {
                return;
            }
            Class<?> clazz = object.getClass();
            Field[] fieldArray = clazz.getDeclaredFields();
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            for (int i = 0; i < fieldArray.length; ++i) {
                fieldArray[i].setAccessible(true);
                try {
                    treeMap.put(fieldArray[i].getName(), fieldArray[i].get(object));
                    continue;
                }
                catch (Exception exception) {
                    treeMap.put(fieldArray[i].getName(), exception);
                }
            }
            out.println("OBJECT FIELDS:");
            for (Map.Entry entry : treeMap.entrySet()) {
                out.println("  " + entry.getKey() + " = " + entry.getValue());
            }
        }
        catch (Throwable throwable) {
            out.println("Exception dumping object");
            throwable.printStackTrace(out);
        }
        finally {
            out.println("--- END OBJECT DUMP ---");
        }
    }

    public static boolean isAllowed(Object object) {
        if (!DebugSupport.isEnabled()) {
            return false;
        }
        if (object == null) {
            return true;
        }
        if (allowed.size() == 0) {
            return false;
        }
        if (object.getClass().isAssignableFrom(String.class)) {
            return allowed.contains(object);
        }
        Class clazz = object.getClass();
        if (clazz == Class.class) {
            clazz = (Class)object;
        }
        if (allowed.contains(DebugSupport.getShortName(clazz))) {
            return true;
        }
        return allowed.contains(DebugSupport.getShortPackageName(clazz));
    }

    public static void allow(Object object) {
        allowed.add(object);
    }

    public static void disallow(Object object) {
        allowed.remove(object);
    }

    private static String getShortName(Class clazz) {
        return clazz.getName().substring(clazz.getPackage().getName().length() + 1);
    }

    private static String getShortPackageName(Class clazz) {
        if (clazz.getPackage().getName().startsWith("org.netbeans.modules.uml")) {
            String string = clazz.getPackage().getName();
            if (string.length() < 21) {
                return ".";
            }
            return string.substring(21);
        }
        if (clazz.getPackage().getName().startsWith("org.netbeans.modules.uml")) {
            String string = clazz.getPackage().getName();
            if (string.length() < 23) {
                return ".";
            }
            return string.substring(23);
        }
        if (clazz.getPackage().getName().startsWith("org.netbeans.modules.uml")) {
            String string = clazz.getPackage().getName();
            if (string.length() < 28) {
                return ".";
            }
            return string.substring(28);
        }
        return clazz.getPackage().getName();
    }

    public static void log(Object object, String string) {
        if (DebugSupport.isAllowed(object)) {
            out.println(string);
        }
    }

    public static void log(Object object, Object object2) {
        if (DebugSupport.isAllowed(object)) {
            out.println(object2 == null ? "null" : object2.toString());
        }
    }

    public static void logPropertyChange(Object object, PropertyChangeEvent propertyChangeEvent) {
        DebugSupport.logPropertyChange(null, object, propertyChangeEvent);
    }

    public static void logPropertyChange(Object object, Object object2, PropertyChangeEvent propertyChangeEvent) {
        if (!DebugSupport.isAllowed(object)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            PrintWriter printWriter;
            ByteArrayOutputStream byteArrayOutputStream;
            stringBuffer.append("\nProperty change:");
            stringBuffer.append("\n\tTName:  " + Thread.currentThread().getName() + "\n\tTPrio:  " + Thread.currentThread().getPriority() + "\n\tTHash:  " + Thread.currentThread().hashCode());
            stringBuffer.append("\n\tProperty:  " + propertyChangeEvent.getPropertyName());
            if (propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getOldValue().getClass().isArray()) {
                stringBuffer.append("\n\tOld Value: " + DebugSupport.delimitedString((Object[])propertyChangeEvent.getOldValue(), ","));
            } else {
                stringBuffer.append("\n\tOld Value: " + propertyChangeEvent.getOldValue());
            }
            if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue().getClass().isArray()) {
                stringBuffer.append("\n\tNew Value: " + DebugSupport.delimitedString((Object[])propertyChangeEvent.getNewValue(), ","));
            } else {
                stringBuffer.append("\n\tNew Value: " + propertyChangeEvent.getNewValue());
            }
            if (propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getOldValue().getClass().isArray()) {
                stringBuffer.append("\n\tValue Type: ARRAY of " + propertyChangeEvent.getOldValue().getClass().getComponentType());
            } else if (propertyChangeEvent.getOldValue() != null) {
                stringBuffer.append("\n\tValue Type: " + propertyChangeEvent.getOldValue().getClass());
            }
            try {
                stringBuffer.append("\n\tReceiver:  " + object2);
            }
            catch (Exception exception) {
                stringBuffer.append("\n\tReceiver:  SEE EXCEPTION");
                stringBuffer.append("\n\tException:    " + exception.toString());
                byteArrayOutputStream = new ByteArrayOutputStream();
                printWriter = new PrintWriter(byteArrayOutputStream);
                exception.printStackTrace(printWriter);
                printWriter.flush();
                printWriter.close();
                stringBuffer.append(((Object)byteArrayOutputStream).toString());
            }
            try {
                stringBuffer.append("\n\tSource:    " + propertyChangeEvent.getSource());
            }
            catch (Exception exception) {
                stringBuffer.append("\n\ttSource:  SEE EXCEPTION");
                stringBuffer.append("\n\tException:    " + exception.toString());
                byteArrayOutputStream = new ByteArrayOutputStream();
                printWriter = new PrintWriter(byteArrayOutputStream);
                exception.printStackTrace(printWriter);
                printWriter.flush();
                printWriter.close();
                stringBuffer.append(((Object)byteArrayOutputStream).toString());
            }
        }
        catch (Exception exception) {
            DebugSupport.logDebugException("logPropertyChange caught exception", exception, true);
        }
        DebugSupport.log(object, stringBuffer.toString());
    }

    private static String delimitedString(Object[] objectArray, String string) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length - 1;
        if (n < 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(objectArray[i]);
            stringBuffer.append(string);
        }
        stringBuffer.append(objectArray[n]);
        return stringBuffer.toString();
    }

    public static void logXMLDetails(Source source) {
        DebugSupport.logXMLDetails(null, source);
    }

    public static void logXMLDetails(Object object, Source source) {
        if (!DebugSupport.isAllowed(object)) {
            return;
        }
        String string = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            transformer.transform(source, new StreamResult(byteArrayOutputStream));
            IndentingParser indentingParser = new IndentingParser();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            indentingParser.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), byteArrayOutputStream2);
            string = new String(byteArrayOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DebugSupport.log(object, string);
    }

    public static void logFileDetails(FileObject fileObject) {
        DebugSupport.logFileDetails(null, fileObject);
    }

    public static void logFileDetails(Object object, FileObject fileObject) {
        if (!DebugSupport.isAllowed(object)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nFile Object details:");
        stringBuffer.append("\n\tgetName:    " + fileObject.getName());
        stringBuffer.append("\n\tgetNameExt:    " + fileObject.getNameExt());
        stringBuffer.append("\n\tgetPackageName(/):    " + fileObject.getPackageName('/'));
        stringBuffer.append("\n\tgetPackageNameExt(/):    " + fileObject.getPackageNameExt('/', '.'));
        DebugSupport.log(object, stringBuffer.toString());
    }

    public static void logDebugException(String string, Throwable throwable, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nException:");
        stringBuffer.append("\n\tNote:    " + string);
        stringBuffer.append("\n\tException:    " + throwable.toString());
        out.println(stringBuffer.toString());
        if (bl) {
            throwable.printStackTrace(out);
        }
    }

    public static void todo(String string) {
        DebugSupport.log((Object)DISCRIMINATOR_TODO, "TODO: " + string + " --> " + new Exception().getStackTrace()[1]);
    }

    public static void notImplemented() {
        DebugSupport.log((Object)DISCRIMINATOR_TODO, "TODO: Not implemented --> " + new Exception().getStackTrace()[1]);
    }

    static {
        allowed = new HashSet();
        DebugSupport.initializeOut();
        String string = System.getProperty("org.netbeans.modules.uml.debug.file");
        try {
            if (string != null && string.trim().length() != 0) {
                Properties properties = new Properties();
                properties.load(new BufferedInputStream(new FileInputStream(string)));
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    DebugSupport.allow(object);
                    System.out.println("Enabling debug messages for \"" + object + "\"");
                }
            } else {
                DebugSupport.allow(DISCRIMINATOR_TODO);
            }
        }
        catch (IOException iOException) {
            System.out.println("Failed to load debug file \"" + string + "\"");
            iOException.printStackTrace(System.out);
        }
    }
}

