/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.roundtripframework;

import org.netbeans.modules.uml.core.eventframework.EventDispatchNameKeeper;
import org.netbeans.modules.uml.core.eventframework.EventDispatchRetriever;
import org.netbeans.modules.uml.core.eventframework.IEventDispatchController;
import org.netbeans.modules.uml.core.eventframework.IEventDispatcher;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.roundtripframework.ElementContextPayload;
import org.netbeans.modules.uml.core.roundtripframework.IProcessorManager;
import org.netbeans.modules.uml.core.roundtripframework.IRoundTripEventPayload;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;

public class RTDispatchHelper {
    protected IEventDispatcher m_Dispatcher;
    protected boolean m_Proceed;
    protected IRoundTripEventPayload m_Payload;
    protected boolean m_CellOrigValue;
    protected IEventDispatchController m_Controller;
    protected IProcessorManager m_ProcManager;

    public RTDispatchHelper() {
    }

    public RTDispatchHelper(IProcessorManager iProcessorManager, IEventDispatchController iEventDispatchController, int n) {
        this.m_ProcManager = iProcessorManager;
        this.m_Controller = iEventDispatchController;
        this.m_Dispatcher = new EventDispatchRetriever(this.m_Controller).getDispatcher(EventDispatchNameKeeper.dispatcherName(n));
    }

    public void establish(boolean bl, boolean bl2, IElement iElement, IResultCell iResultCell) {
        if (this.m_ProcManager.establishProcessors(bl, bl2, iElement) || bl2) {
            this.createRTContextPayload(iResultCell, iElement);
        } else {
            this.m_Dispatcher = null;
        }
    }

    public void createRTContextPayload(IResultCell iResultCell, IElement iElement) {
        if (iResultCell == null) {
            return;
        }
        this.m_Payload = this.createRTContextPayload2(iResultCell, iElement);
        this.m_Proceed = this.m_CellOrigValue = iResultCell.canContinue();
    }

    public IRoundTripEventPayload createRTContextPayload2(IResultCell iResultCell, IElement iElement) {
        if (iResultCell == null) {
            return null;
        }
        IProject iProject = null;
        if (iElement != null) {
            iProject = iElement.getProject();
        }
        return this.createRTContextPayload(iResultCell, iProject, iElement);
    }

    public IRoundTripEventPayload createRTContextPayload(IResultCell iResultCell, IProject iProject, IElement iElement) {
        if (iResultCell == null) {
            return null;
        }
        ElementContextPayload elementContextPayload = new ElementContextPayload();
        elementContextPayload.setData(iResultCell.getContextData());
        elementContextPayload.setProject(iProject);
        elementContextPayload.setOwner(iElement);
        return elementContextPayload;
    }

    public IRoundTripEventPayload getPayload() {
        return this.m_Payload;
    }

    public boolean getCellOrigValue() {
        return this.m_CellOrigValue;
    }

    public boolean getProceed() {
        return this.m_Proceed;
    }

    public IEventDispatcher getDispatcher() {
        return this.m_Dispatcher;
    }

    public IEventDispatchController getController() {
        return this.m_Controller;
    }
}

