/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.roundtripframework;

import java.util.HashMap;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.IApplication;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.eventframework.IEventPayload;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguage;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguageManager;
import org.netbeans.modules.uml.core.roundtripframework.IProcessorManager;
import org.netbeans.modules.uml.core.roundtripframework.IRequestProcessor;
import org.netbeans.modules.uml.core.roundtripframework.IRoundTripController;
import org.netbeans.modules.uml.core.roundtripframework.IRoundTripEventDispatcher;
import org.netbeans.modules.uml.core.roundtripframework.NameModifyPreRequest;
import org.netbeans.modules.uml.core.roundtripframework.RTStateTester;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorManager
implements IProcessorManager {
    private static final String ROUND_TRIP_CONTEXT = "RoundTrip";
    private HashMap<String, IRequestProcessor> m_ProcessorCache = new HashMap();
    IRoundTripController m_Controller = null;
    ILanguageManager m_LanguageManager = null;

    public ProcessorManager() {
    }

    public ProcessorManager(IRoundTripController iRoundTripController) {
        this.m_Controller = iRoundTripController;
    }

    @Override
    public IRequestProcessor createProcessor(String string) {
        IEventPayload iEventPayload;
        IRoundTripEventDispatcher iRoundTripEventDispatcher;
        IRequestProcessor iRequestProcessor = null;
        if (this.m_Controller != null && (iRoundTripEventDispatcher = this.m_Controller.getRoundTripDispatcher()) != null && iRoundTripEventDispatcher.firePreInitialized(string, iEventPayload = iRoundTripEventDispatcher.createPayload("PreInitialized"))) {
            try {
                iRequestProcessor = (IRequestProcessor)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (iRequestProcessor == null) {
                return null;
            }
            iRequestProcessor.initialize(this.m_Controller);
            this.m_ProcessorCache.put(string, iRequestProcessor);
            iEventPayload = iRoundTripEventDispatcher.createPayload("Initialized");
            iRoundTripEventDispatcher.fireInitialized(iRequestProcessor, iEventPayload);
        }
        return iRequestProcessor;
    }

    @Override
    public boolean establishCreateProcessors(INamedElement iNamedElement, boolean bl) {
        RTStateTester rTStateTester;
        boolean bl2 = false;
        if (iNamedElement != null && (rTStateTester = new RTStateTester()).isElementRoundTripable(iNamedElement)) {
            NameModifyPreRequest nameModifyPreRequest = new NameModifyPreRequest();
            if (nameModifyPreRequest.inCreateState(iNamedElement)) {
                IProject iProject;
                IApplication iApplication;
                ICoreProduct iCoreProduct;
                String string = iNamedElement.getTopLevelId();
                if (string != null && (iCoreProduct = ProductRetriever.retrieveProduct()) != null && (iApplication = iCoreProduct.getApplication()) != null && (iProject = iApplication.getProjectByID(string)) != null) {
                    bl2 = this.establishProcessorsForProject(iProject, bl).getParamTwo();
                }
            } else {
                bl2 = this.establishProcessors(iNamedElement, bl);
            }
        }
        return bl2;
    }

    @Override
    public IRequestProcessor establishProcessor(ILanguage iLanguage) {
        IRequestProcessor iRequestProcessor = null;
        if (iLanguage != null) {
            String string = iLanguage.getContextCLSID(ROUND_TRIP_CONTEXT);
            iRequestProcessor = this.establishProcessorWithID(string);
        }
        return iRequestProcessor;
    }

    @Override
    public IRequestProcessor establishProcessor(String string) {
        if (string == null) {
            return null;
        }
        IRequestProcessor iRequestProcessor = this.m_ProcessorCache.get(string);
        if (iRequestProcessor == null) {
            iRequestProcessor = this.createProcessor(string);
        }
        return iRequestProcessor;
    }

    @Override
    public boolean establishProcessors(ETList<ILanguage> eTList) {
        boolean bl = false;
        if (eTList == null) {
            return bl;
        }
        int n = eTList.size();
        for (int i = 0; i < n; ++i) {
            if (this.establishProcessor((ILanguage)eTList.get(i)) == null) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean establishProcessors(boolean bl, boolean bl2, IElement iElement) {
        boolean bl3 = false;
        if (bl) {
            INamedElement iNamedElement = null;
            try {
                iNamedElement = (INamedElement)iElement;
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl3 = iNamedElement == null ? this.establishProcessors(iElement, bl2) : this.establishCreateProcessors(iNamedElement, bl2);
        } else {
            bl3 = this.establishProcessors(iElement, bl2);
        }
        return bl3;
    }

    @Override
    public boolean establishProcessors(IElement iElement, boolean bl) {
        ETList<ILanguage> eTList;
        RTStateTester rTStateTester;
        boolean bl2 = false;
        if (iElement != null && (rTStateTester = new RTStateTester()).isElementRoundTripable(iElement) && (bl || rTStateTester.isAppInRoundTripState(iElement)) && (eTList = iElement.getLanguages()) != null) {
            bl2 = this.establishProcessors(eTList);
        }
        return bl2;
    }

    @Override
    public ETPairT<String, Boolean> establishProcessorsForProject(IProject iProject, boolean bl) {
        boolean bl2 = false;
        if (iProject == null) {
            return new ETPairT<Object, Boolean>(null, new Boolean(false));
        }
        String string = iProject.getMode();
        String string2 = null;
        RTStateTester rTStateTester = new RTStateTester();
        if ((bl || rTStateTester.isProjectInRoundTripState(iProject)) && (string2 = iProject.getDefaultLanguage()) != null) {
            String string3 = this.retrieveProcessorIDByLang(string2);
            bl2 = this.establishProcessorWithID(string3) != null;
        }
        return new ETPairT<String, Boolean>(string2, new Boolean(bl2));
    }

    @Override
    public void establishProcessorsForProject(IWSProject iWSProject) {
        IProject iProject;
        IApplication iApplication;
        if (iWSProject == null) {
            return;
        }
        ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
        if (iCoreProduct != null && (iApplication = iCoreProduct.getApplication()) != null && (iProject = iApplication.getProjectByName(iWSProject.getName())) != null) {
            this.establishProcessorsForProject(iProject, false);
        }
    }

    @Override
    public IRequestProcessor establishProcessorWithID(String string) {
        return this.establishProcessor(string);
    }

    @Override
    public ILanguageManager getLanguageManager() {
        ICoreProduct iCoreProduct;
        if (this.m_LanguageManager == null && (iCoreProduct = ProductRetriever.retrieveProduct()) != null) {
            this.m_LanguageManager = iCoreProduct.getLanguageManager();
        }
        return this.m_LanguageManager;
    }

    @Override
    public String retrieveProcessorIDByLang(String string) {
        return this.getLanguageManager().retrieveContextForLanguage(string, ROUND_TRIP_CONTEXT);
    }
}

