/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.reverseengineering.reframework;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IDependencyEvent;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IFileSystemClassLocator;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlutils.ETList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemClassLocator
implements IFileSystemClassLocator {
    private List<String> m_BaseDirectories = new ArrayList<String>();

    @Override
    public void addBaseDirectory(String string) {
        if (string != null && (string = string.trim()).length() > 0 && !this.m_BaseDirectories.contains(string)) {
            this.m_BaseDirectories.add(string);
        }
    }

    @Override
    public ETPairT<String, String> locateFileForClass(String string, String string2, ETList<IDependencyEvent> eTList) {
        String string3 = this.searchForFile("", string2);
        String string4 = null;
        if (string3 == null) {
            string4 = string;
            string3 = this.searchForFile(string4, string2);
        }
        if (string3 == null && eTList != null && eTList.size() > 0) {
            ETPairT<String, String> eTPairT = this.searchDependencies(string2, eTList);
            string3 = eTPairT.getParamOne();
            string4 = eTPairT.getParamTwo();
        }
        if (string3 != null) {
            string4 = string4 != null ? string4 + "::" + string2 : string2;
        }
        return new ETPairT<String, String>(string4, string3);
    }

    @Override
    public String locateFile(String string) {
        return this.searchForFile(string);
    }

    protected String searchForFile(String string) {
        String string2 = StringUtilities.splice(string, "::", File.separator);
        String string3 = this.checkBaseDirectories(string2 + ".java");
        if (string3 == null && (string3 = this.checkBaseDirectories(string2 + ".cls")) == null) {
            string3 = this.checkBaseDirectories(string2 + ".frm");
        }
        return string3;
    }

    protected String checkBaseDirectories(String string) {
        int n = this.m_BaseDirectories.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this.m_BaseDirectories.get(i);
            File file = new File(string2, string);
            if (!file.exists()) continue;
            try {
                return file.getAbsoluteFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    protected String searchForFile(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        return this.searchForFile(string != null && string.length() > 0 ? string + "::" + string2 : string2);
    }

    protected ETPairT<String, String> searchDependencies(String string, ETList<IDependencyEvent> eTList) {
        String string2 = null;
        String string3 = null;
        int n = eTList.size();
        for (int i = 0; i < n; ++i) {
            String string4;
            IDependencyEvent iDependencyEvent = (IDependencyEvent)eTList.get(i);
            if (iDependencyEvent == null || (string4 = iDependencyEvent.getSupplier()) == null || string4.length() <= 0) continue;
            if (iDependencyEvent.getIsClassDependency()) {
                if (!iDependencyEvent.isSameClass(string)) continue;
                string3 = string4;
                string2 = this.searchForFile(string3, "");
                int n2 = string3.lastIndexOf("::");
                if (n2 == -1) break;
                string3 = string3.substring(0, n2);
                break;
            }
            string3 = string4;
            string2 = this.searchForFile(string3, string);
        }
        return new ETPairT<Object, Object>(string2, string3);
    }
}

