/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.reverseengineering.parsingfacilities;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.ClassLoaderListener;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.IClassLoaderListener;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.IREClassLoader;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.IUMLParser;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.IUMLParserEventDispatcher;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.LanguageFacilityFactory;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IClassLocator;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IDependencyEvent;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IFileInformation;
import org.netbeans.modules.uml.core.reverseengineering.reframework.ILanguageLibrary;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IREClass;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.IErrorEvent;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REClassLoader
implements IREClassLoader {
    private IClassLocator m_Locator;
    private FileInformationMap m_FileInfoMap = new FileInformationMap();
    private ClassMap m_ClassMap = new ClassMap();
    private LibraryList m_Libraries = new LibraryList();

    @Override
    public IREClass loadClass(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        IREClass iREClass = this.lookupClass(string);
        if (iREClass == null && (iREClass = this.checkLibraries(string, null)) == null) {
            iREClass = this.searchLocators(null, string, null);
        }
        return iREClass;
    }

    @Override
    public IREClass loadClass(String string, IREClass iREClass) {
        if (string == null || string.length() == 0) {
            return null;
        }
        IREClass iREClass2 = this.lookupClass(string, iREClass);
        if (iREClass2 == null && (iREClass2 = this.checkLibraries(string, iREClass)) == null) {
            iREClass2 = this.checkLocators(string, iREClass);
        }
        return iREClass2;
    }

    @Override
    public ETList<IREClass> getLoadedClasses() {
        ETArrayList<IREClass> eTArrayList = new ETArrayList<IREClass>();
        Iterator iterator = this.m_ClassMap.entrySet().iterator();
        while (iterator.hasNext()) {
            IREClass iREClass = (IREClass)iterator.next().getValue();
            if (iREClass == null) continue;
            eTArrayList.add(iREClass);
        }
        return eTArrayList;
    }

    @Override
    public IREClass loadClassFromFile(String string, String string2) {
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return null;
        }
        this.loadFile(string);
        return this.lookupClass(string2);
    }

    @Override
    public ETList<IREClass> loadClassesFromFile(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        this.loadFile(string);
        IFileInformation iFileInformation = this.getClassInformation(string);
        return this.retrieveClassesFromFileInfo(iFileInformation);
    }

    @Override
    public void loadFile(String string) {
        IUMLParserEventDispatcher iUMLParserEventDispatcher;
        if (string == null || string.length() == 0) {
            return;
        }
        IUMLParser iUMLParser = this.getParser();
        if (iUMLParser != null && (iUMLParserEventDispatcher = iUMLParser.getUMLParserDispatcher()) != null) {
            ClassLoaderListener classLoaderListener = new ClassLoaderListener();
            iUMLParserEventDispatcher.registerForUMLParserEvents(classLoaderListener, string);
            iUMLParser.processStreamFromFile(string);
            iUMLParserEventDispatcher.revokeUMLParserSink(classLoaderListener);
            this.loadFileInformation(string, classLoaderListener);
        }
    }

    @Override
    public List<IDependencyEvent> getDependencies(IREClass iREClass) {
        IFileInformation iFileInformation = this.getClassInformation(iREClass);
        if (iFileInformation != null) {
            return iFileInformation.getDependencies();
        }
        return null;
    }

    @Override
    public IClassLocator getClassLocator() {
        return this.m_Locator;
    }

    @Override
    public void setClassLocator(IClassLocator iClassLocator) {
        this.m_Locator = iClassLocator;
    }

    protected IUMLParser getParser() {
        return new LanguageFacilityFactory().getUMLParser();
    }

    protected void loadFileInformation(String string, IClassLoaderListener iClassLoaderListener) {
        IFileInformation iFileInformation = iClassLoaderListener.getFileInformation();
        if (iFileInformation != null) {
            this.m_FileInfoMap.put(string, iFileInformation);
            this.addClassInformation(iFileInformation);
        }
    }

    protected void addClassInformation(IFileInformation iFileInformation) {
        if (iFileInformation == null) {
            return;
        }
        int n = iFileInformation.getTotalClasses();
        for (int i = 0; i < n; ++i) {
            this.addClassInformation(iFileInformation.getClass(i));
        }
    }

    protected void addClassInformation(IREClass iREClass) {
        Object object;
        if (iREClass == null) {
            return;
        }
        String string = iREClass.getPackage();
        String string2 = iREClass.getName();
        if (string2 != null && string2.length() > 0) {
            object = string != null && string.length() > 0 ? string + "::" + string2 : string2;
            this.m_ClassMap.put(object, iREClass);
        }
        if ((object = iREClass.getAllInnerClasses()) != null) {
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                this.addClassInformation((IREClass)object.get(i));
            }
        }
    }

    protected ETList<IREClass> retrieveClassesFromFileInfo(IFileInformation iFileInformation) {
        if (iFileInformation == null) {
            return null;
        }
        ETArrayList<IREClass> eTArrayList = new ETArrayList<IREClass>();
        int n = iFileInformation.getTotalClasses();
        for (int i = 0; i < n; ++i) {
            IREClass iREClass = iFileInformation.getClass(i);
            if (iREClass == null) continue;
            eTArrayList.add(iREClass);
        }
        return eTArrayList;
    }

    protected IFileInformation getClassInformation(String string) {
        return (IFileInformation)this.m_FileInfoMap.get(string);
    }

    protected IFileInformation getClassInformation(IREClass iREClass) {
        if (iREClass == null) {
            return null;
        }
        return this.getClassInformation(iREClass.getFilename());
    }

    protected IREClass lookupClass(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return (IREClass)this.m_ClassMap.get(string);
    }

    protected IREClass lookupClass(String string, IREClass iREClass) {
        IREClass iREClass2 = this.lookupClass(string);
        if (iREClass2 == null && (iREClass2 = this.lookupInnerClass(string, iREClass)) == null && (iREClass2 = this.lookupInPackage(string, iREClass)) == null) {
            iREClass2 = this.lookupInDependencies(string, iREClass);
        }
        return iREClass2;
    }

    protected IREClass lookupInnerClass(String string, IREClass iREClass) {
        Object object;
        if (string == null || string.length() == 0 || iREClass == null) {
            return null;
        }
        IREClass iREClass2 = null;
        String string2 = iREClass.getName();
        if (string2 != null && string2.length() > 0) {
            object = string2 + "::" + string;
            iREClass2 = this.lookupClass((String)object);
        }
        if (iREClass2 == null && (object = iREClass.getAllInnerClasses()) != null) {
            int n = object.size();
            for (int i = 0; i < n && iREClass2 == null; ++i) {
                IREClass iREClass3 = (IREClass)object.get(i);
                if (iREClass3 == null) continue;
                iREClass2 = this.lookupInnerClass(string, iREClass3);
            }
        }
        return iREClass2;
    }

    protected IREClass lookupInPackage(String string, IREClass iREClass) {
        if (iREClass == null) {
            return null;
        }
        String string2 = iREClass.getPackage();
        if (string2 != null && string2.length() > 0) {
            string2 = string2 + "::" + string;
            return this.lookupClass(string2);
        }
        return null;
    }

    protected IREClass lookupInDependencies(String string, IREClass iREClass) {
        if (iREClass == null) {
            return null;
        }
        IREClass iREClass2 = null;
        IFileInformation iFileInformation = this.getClassInformation(iREClass);
        if (iFileInformation != null) {
            int n = iFileInformation.getTotalDependencies();
            for (int i = 0; i < n && iREClass2 == null; ++i) {
                IDependencyEvent iDependencyEvent = iFileInformation.getDependency(i);
                if (iDependencyEvent == null) continue;
                String string2 = iDependencyEvent.getSupplier();
                boolean bl = iDependencyEvent.getIsClassDependency();
                if (string2 == null || string2.length() <= 0) continue;
                if (bl) {
                    if (!iDependencyEvent.isSameClass(string)) continue;
                    iREClass2 = this.lookupClass(string2);
                    continue;
                }
                string2 = string2 + "::" + string;
                iREClass2 = this.lookupClass(string2);
            }
        }
        return iREClass2;
    }

    @Override
    public void addLibrary(ILanguageLibrary iLanguageLibrary) {
        if (iLanguageLibrary == null) {
            return;
        }
        this.m_Libraries.add(iLanguageLibrary);
    }

    protected IREClass checkLibraries(String string, IREClass iREClass) {
        IFileInformation iFileInformation = this.getClassInformation(iREClass);
        int n = iFileInformation != null ? iFileInformation.getTotalDependencies() : 0;
        IREClass iREClass2 = null;
        int n2 = this.m_Libraries.size();
        for (int i = 0; i < n2; ++i) {
            ILanguageLibrary iLanguageLibrary = (ILanguageLibrary)this.m_Libraries.get(i);
            iREClass2 = iLanguageLibrary.findClass(string);
            if (iREClass2 != null || n <= 0) continue;
            for (int j = 0; j < n && iREClass2 == null; ++j) {
                IDependencyEvent iDependencyEvent = iFileInformation.getDependency(j);
                String string2 = iDependencyEvent.getSupplier();
                if (string2 == null || string2.length() <= 0) continue;
                if (iDependencyEvent.getIsClassDependency()) {
                    if (!iDependencyEvent.isSameClass(string)) continue;
                    iREClass2 = iLanguageLibrary.findClass(string2);
                    continue;
                }
                string2 = string2 + "::" + string;
                iREClass2 = iLanguageLibrary.findClass(string2);
            }
        }
        this.addClassInformation(iREClass2);
        return iREClass2;
    }

    protected IREClass searchLocators(String string, String string2, ETList<IDependencyEvent> eTList) {
        IREClass iREClass = null;
        IClassLocator iClassLocator = this.getClassLocator();
        if (iClassLocator != null) {
            ETPairT<String, String> eTPairT = iClassLocator.locateFileForClass(string, string2, eTList);
            String string3 = eTPairT.getParamOne();
            String string4 = eTPairT.getParamTwo();
            if (string4 != null && string4.length() > 0) {
                iREClass = this.loadClassFromFile(string4, string3);
                this.addClassInformation(iREClass);
            }
        }
        return iREClass;
    }

    protected IREClass checkLocators(String string, IREClass iREClass) {
        if (iREClass == null) {
            return null;
        }
        IREClass iREClass2 = null;
        IFileInformation iFileInformation = this.getClassInformation(iREClass);
        if (iFileInformation != null) {
            ETList<IDependencyEvent> eTList = iFileInformation.getDependencies();
            String string2 = "";
            if (iREClass != null) {
                string2 = iREClass.getPackage();
            }
            if ((iREClass2 = this.searchLocators(string2, string, eTList)) == null) {
                iREClass2 = this.lookupClass(string, iREClass);
            }
        }
        return iREClass2;
    }

    @Override
    public ETList<IErrorEvent> getErrorInFile(String string) {
        IFileInformation iFileInformation = this.getClassInformation(string);
        return iFileInformation != null ? iFileInformation.getErrors() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryList
    extends ETArrayList<ILanguageLibrary> {
        private LibraryList() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassMap
    extends TreeMap<String, IREClass> {
        private ClassMap() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileInformationMap
    extends HashMap<String, IFileInformation> {
        private FileInformationMap() {
        }
    }
}

