/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.metamodel.modelanalysis;

import java.util.TreeMap;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IGeneralization;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IImplementation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IInterface;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.modelanalysis.ElementUtilities;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifierUtilities
extends ElementUtilities {
    public ETList<IClassifier> collectGeneralizingClassifiers(IClassifier iClassifier) {
        ETList<IGeneralization> eTList;
        ETArrayList<IClassifier> eTArrayList = new ETArrayList<IClassifier>();
        if (iClassifier != null && (eTList = iClassifier.getGeneralizations()) != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IClassifier iClassifier2;
                IGeneralization iGeneralization = (IGeneralization)eTList.get(i);
                if (iGeneralization == null || (iClassifier2 = iGeneralization.getGeneral()) == null) continue;
                eTArrayList.add(iClassifier2);
            }
        }
        return eTArrayList;
    }

    public ETList<IClassifier> collectImplementedInterfaces(IClassifier iClassifier) {
        ETList<IImplementation> eTList;
        ETArrayList<IClassifier> eTArrayList = new ETArrayList<IClassifier>();
        if (iClassifier != null && (eTList = iClassifier.getImplementations()) != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IInterface iInterface;
                IImplementation iImplementation = (IImplementation)eTList.get(i);
                if (iImplementation == null || (iInterface = iImplementation.getContract()) == null) continue;
                eTArrayList.add(iInterface);
            }
        }
        return eTArrayList;
    }

    public ETList<IOperation> collectAllOperations(IClassifier iClassifier) {
        ETList<IOperation> eTList;
        if (iClassifier == null) {
            return null;
        }
        ETList<Object> eTList2 = new ETArrayList();
        ETList<IOperation> eTList3 = iClassifier.getOperations();
        if (eTList3 != null) {
            eTList = new TreeMap();
            int n = eTList3.size();
            IOperation iOperation = null;
            for (int i = 0; i < n; ++i) {
                iOperation = (IOperation)eTList3.get(i);
                if (iOperation == null || iOperation.getIsConstructor()) continue;
                boolean bl = this.isOperationRedefinedBy(iOperation, eTList2);
                if (!bl) {
                    String string = iOperation.getName();
                    ((TreeMap)((Object)eTList)).put(string, iOperation);
                    continue;
                }
                eTList2.add(iOperation);
            }
            eTList2.addAll(((TreeMap)((Object)eTList)).values());
        }
        if (eTList2 == null) {
            eTList2 = this.collectOpsFromGeneralizations(iClassifier);
        } else {
            eTList = this.collectOpsFromGeneralizations(iClassifier);
            if (eTList != null) {
                eTList2.addAll(eTList);
            }
        }
        if (eTList2 == null) {
            eTList2 = this.collectOpsFromImplementations(iClassifier);
        } else {
            eTList = this.collectOpsFromImplementations(iClassifier);
            if (eTList != null) {
                eTList2.addAll(eTList);
            }
        }
        return eTList2;
    }

    protected ETList<IOperation> collectOpsFromGeneralizations(IClassifier iClassifier) {
        ETList<IOperation> eTList = null;
        if (iClassifier != null) {
            ETList<IClassifier> eTList2 = this.collectGeneralizingClassifiers(iClassifier);
            eTList = this.collectAllOperations(eTList2);
        }
        return eTList;
    }

    protected ETList<IOperation> collectOpsFromImplementations(IClassifier iClassifier) {
        ETList<IOperation> eTList = null;
        if (iClassifier != null) {
            ETList<IClassifier> eTList2 = this.collectImplementedInterfaces(iClassifier);
            eTList = this.collectAllOperations(eTList2);
        }
        return eTList;
    }

    protected ETList<IOperation> collectAllOperations(ETList<IClassifier> eTList) {
        ETList<IOperation> eTList2 = null;
        if (eTList != null) {
            int n = eTList.size();
            IClassifier iClassifier = null;
            for (int i = 0; i < n; ++i) {
                iClassifier = (IClassifier)eTList.get(i);
                if (iClassifier == null) continue;
                if (eTList2 == null) {
                    eTList2 = this.collectAllOperations(iClassifier);
                    continue;
                }
                eTList2.addAll(this.collectAllOperations(iClassifier));
            }
        }
        return eTList2;
    }
}

