/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.metamodel.core.foundation;

import java.io.File;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.netbeans.modules.uml.UMLCoreModule;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConfigManager;
import org.netbeans.modules.uml.core.support.Debug;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.Validator;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;

public class ConfigManager
implements IConfigManager {
    private String m_HomeLocation = "";
    private String m_PresentationTypes = "";
    private String m_StereotypeIconsLocation = "";
    private String m_Preferences = "";
    private String m_EventFramework = "";
    private String m_DTD = "";
    private String m_DefaultConfigLocation = "";
    private String m_DefaultResources = "";
    private String m_OverriddenResources = "";
    private Hashtable<String, Hashtable<String, HiveElement>> m_Hives = new Hashtable();

    public ConfigManager() {
        this(System.getProperty("netbeans.user", System.getProperty("java.io.tmpdir")) + File.separatorChar + ".uml");
    }

    public ConfigManager(String string) {
        Debug.log((Object)this, "uml config dir=" + string);
        UMLCoreModule.checkInitUml1();
        this.m_HomeLocation = string;
        if (!this.m_HomeLocation.endsWith(File.separator)) {
            this.m_HomeLocation = this.m_HomeLocation + File.separator;
        }
        this.ingestConfigFile();
    }

    public String getHomeLocation() {
        return this.m_HomeLocation;
    }

    public String getLicenseLocation() {
        String string = "";
        if (this.m_HomeLocation.length() > 0) {
            string = this.m_HomeLocation;
            File file = new File(new File(string).getParent(), "License");
            string = file.toString();
        }
        return string;
    }

    public String getDocsLocation() {
        String string = "";
        if (this.m_HomeLocation.length() > 0) {
            string = this.m_HomeLocation;
            string = StringUtilities.changeFinalDirectory(string, "docs");
            string = string + File.separator;
        }
        return null;
    }

    public String getPresentationTypesLocation() {
        return this.getLocation(this.m_PresentationTypes);
    }

    public void setPresentationTypesLocation(String string) {
        this.m_PresentationTypes = string;
    }

    public String getStereotypeIconsLocation() {
        return this.getLocation(this.m_StereotypeIconsLocation);
    }

    public void setStereotypeIconsLocation(String string) {
        this.m_StereotypeIconsLocation = string;
    }

    public String getEventFrameworkLocation() {
        return this.getLocation(this.m_EventFramework);
    }

    public void setEventFrameworkLocation(String string) {
        this.m_EventFramework = string;
    }

    public String getDTDLocation() {
        return this.getLocation(this.m_DTD);
    }

    public void setDTDLocation(String string) {
        this.m_DTD = string;
    }

    public String getID(String string, String string2) {
        return this.getIDs(string, string2, null);
    }

    public String getIDs(String string, String string2, StringBuffer stringBuffer) {
        HiveElement hiveElement;
        String string3 = "";
        Hashtable<String, HiveElement> hashtable = this.m_Hives.get(string);
        if (hashtable != null && (hiveElement = hashtable.get(string2)) != null) {
            string3 = hiveElement.m_Id;
            if (stringBuffer != null && hiveElement.m_CreateTransitionId != null) {
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(hiveElement.m_CreateTransitionId);
            }
        }
        return string3;
    }

    public String getPreferenceLocation() {
        return this.getLocation(this.m_Preferences);
    }

    private String getLocation(String string) {
        String string2 = "";
        if (this.m_HomeLocation.length() > 0) {
            string2 = this.m_HomeLocation;
            string2 = string2 + "config" + File.separator;
            string2 = string2 + string;
        }
        return string2;
    }

    public void setPreferenceLocation(String string) {
        this.m_Preferences = string;
    }

    public String getDefaultConfigLocation() {
        String string = "";
        if (this.m_HomeLocation.length() > 0 && !(string = new File(this.m_HomeLocation, "config").toString()).endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    private void ingestConfigFile() {
        Document document;
        String string;
        boolean bl;
        if (this.m_HomeLocation.length() > 0 && (bl = Validator.verifyFileExists(string = this.getLocation("EssentialConfig.etc"))) && (document = XMLManip.getDOMDocument(string)) != null) {
            this.loadConfigFile(document);
        }
    }

    private void loadConfigFile(Document document) {
        this.loadTopLevelProperties(document);
        this.loadHives(document);
    }

    private void loadHives(Document document) {
        List list = document.selectNodes("//Hive");
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                this.loadHive((Node)list.get(i));
            }
        }
    }

    private void loadHive(Node node) {
        try {
            List list = XMLManip.selectNodeList(node, "./HiveElement");
            if (list != null && list.size() > 0) {
                Hashtable<String, HiveElement> hashtable = new Hashtable<String, HiveElement>();
                for (int i = 0; i < list.size(); ++i) {
                    Node node2 = (Node)list.get(i);
                    String string = XMLManip.getAttributeValue(node2, "name");
                    String string2 = XMLManip.getAttributeValue(node2, "id");
                    String string3 = XMLManip.getAttributeValue(node2, "createTransitionID");
                    if (string.length() <= 0 || string2.length() <= 0) continue;
                    HiveElement hiveElement = new HiveElement(string2, string3);
                    hashtable.put(string, hiveElement);
                }
                String string = XMLManip.getAttributeValue(node, "name");
                if (string.length() > 0) {
                    this.m_Hives.put(string, hashtable);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadTopLevelProperties(Document document) {
        this.m_StereotypeIconsLocation = this.getTopLevelProperty(document, "/EssentialConfig/StereotypeIcons");
        this.m_PresentationTypes = this.getTopLevelProperty(document, "/EssentialConfig/PresentationTypes");
        this.m_DefaultResources = this.getTopLevelProperty(document, "/EssentialConfig/DefaultResources");
        this.m_OverriddenResources = this.getTopLevelProperty(document, "/EssentialConfig/OverriddenResources");
        this.m_Preferences = this.getTopLevelProperty(document, "/EssentialConfig/Preferences");
        this.m_EventFramework = this.getTopLevelProperty(document, "/EssentialConfig/EventFramework");
        this.m_DTD = this.getTopLevelProperty(document, "/EssentialConfig/DTD");
    }

    private String getTopLevelProperty(Document document, String string) {
        String string2 = "";
        try {
            Node node = XMLManip.selectSingleNode((Node)document, string);
            if (node != null) {
                string2 = XMLManip.getAttributeValue(node, "href");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public void setDefaultResourcesLocation(String string) {
        this.m_DefaultResources = string;
    }

    public String getDefaultResourcesLocation() {
        return this.getLocation(this.m_DefaultResources);
    }

    public void setOverriddenResourcesLocation(String string) {
        this.m_OverriddenResources = string;
    }

    public String getOverriddenResourcesLocation() {
        return this.getLocation(this.m_OverriddenResources);
    }

    private class HiveElement {
        private String m_Id = "";
        private String m_CreateTransitionId = "";

        public HiveElement() {
        }

        public HiveElement(String string, String string2) {
            this.m_Id = string;
            this.m_CreateTransitionId = string2;
        }
    }
}

