/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.eventframework;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.eventframework.EventFunctor;
import org.netbeans.modules.uml.core.eventframework.IEventDispatcher;
import org.netbeans.modules.uml.core.eventframework.IValidationSink;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager<Element> {
    private Vector<WeakReference<Object>> m_listeners = new Vector();
    private WeakHashMap<Object, Object> hashedListeners = new WeakHashMap();
    private IEventDispatcher m_dispatcher = null;
    private IValidationSink m_Validator = null;

    public void addListener(Element Element2, IValidationSink<Element> iValidationSink) {
        if (!this.contains(Element2)) {
            this.m_listeners.addElement(new WeakReference<Element>(Element2));
            this.hashedListeners.put(Element2, new Object());
            if (iValidationSink != null) {
                this.setValidator(iValidationSink);
            }
        } else {
            ErrorManager.getDefault().log(1, "Duplicate listener registration was attempted with " + Element2.toString());
        }
    }

    public void removeListener(Element Element2) {
        if (Element2 != null) {
            Iterator<WeakReference<Object>> iterator = this.m_listeners.iterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Object t;
                    WeakReference<Object> weakReference = iterator.next();
                    if (weakReference == null || (t = weakReference.get()) == null || !t.equals(Element2)) continue;
                    iterator.remove();
                }
            }
            this.hashedListeners.remove(Element2);
        }
    }

    private boolean contains(Element Element2) {
        return Element2 != null && this.hashedListeners.get(Element2) != null;
    }

    private void cleanUp() {
        Iterator<WeakReference<Object>> iterator = this.m_listeners.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                WeakReference<Object> weakReference = iterator.next();
                if (weakReference == null) {
                    iterator.remove();
                    continue;
                }
                Object t = weakReference.get();
                if (t != null) continue;
                iterator.remove();
            }
        }
    }

    public void setDispatcher(IEventDispatcher iEventDispatcher) {
        this.m_dispatcher = iEventDispatcher;
    }

    public boolean anyListeners() {
        return this.m_listeners.size() > 0;
    }

    public int getNumListeners() {
        return this.m_listeners.size();
    }

    public void notifyListeners(EventFunctor eventFunctor) {
        if (eventFunctor == null) {
            return;
        }
        this.cleanUp();
        for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
            try {
                eventFunctor.execute(this.m_listeners.elementAt(i).get());
                continue;
            }
            catch (Exception exception) {
                ETSystem.out.println("Error in notifyListeners");
            }
        }
    }

    public void notifyListeners(EventFunctor eventFunctor, Object[] objectArray) {
        if (eventFunctor == null) {
            return;
        }
        this.cleanUp();
        for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
            try {
                eventFunctor.execute(objectArray, this.m_listeners.elementAt(i).get());
                continue;
            }
            catch (Exception exception) {
                ETSystem.out.println("Error in notifyListeners");
            }
        }
    }

    public void notifyListenersWithQualifiedProceed(EventFunctor eventFunctor) {
        this.cleanUp();
        for (int i = this.m_listeners.size() - 1; i > -1; --i) {
            try {
                eventFunctor.execute(this.m_listeners.elementAt(i).get());
                if (eventFunctor.isResultOK()) continue;
                break;
            }
            catch (Exception exception) {
                ETSystem.out.println("Exception in notifyListenersWithQualifiedProceed");
            }
        }
    }

    public IValidationSink getValidator() {
        return this.m_Validator;
    }

    public void setValidator(IValidationSink iValidationSink) {
        this.m_Validator = iValidationSink;
    }
}

