/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.coreapplication;

import java.util.Enumeration;
import java.util.Hashtable;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.coreapplication.ICoreProductManager;
import org.netbeans.modules.uml.core.coreapplication.IProductDescriptor;
import org.netbeans.modules.uml.core.coreapplication.ProductDescriptor;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.applicationcore.ADProduct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreProductManager
implements ICoreProductManager {
    private Hashtable<String, ICoreProduct> m_CoreProducts = new Hashtable();
    private long m_RevokeNum = 0L;
    private static ICoreProductManager m_ROTManager = null;
    public static String s_sProductAlias = "";
    public static int s_nProductAliasPID = 0;

    public static ICoreProductManager instance() {
        if (m_ROTManager == null) {
            m_ROTManager = new CoreProductManager();
        }
        return m_ROTManager;
    }

    private CoreProductManager() {
        this.registerWithROT();
    }

    private void registerWithROT() {
        if (m_ROTManager == null) {
            m_ROTManager = this;
        }
    }

    @Override
    public ICoreProduct getCoreProduct() {
        return m_ROTManager != null ? m_ROTManager.getCoreProduct(this.getPID()) : this.getCoreProduct(this.getPID());
    }

    private int getPID() {
        return s_nProductAliasPID != 0 ? s_nProductAliasPID : 0;
    }

    @Override
    public void setCoreProduct(ICoreProduct iCoreProduct) {
        int n = this.getPID();
        if (m_ROTManager != null) {
            m_ROTManager.setCoreProduct(n, iCoreProduct);
        } else {
            this.setCoreProduct(n, iCoreProduct);
        }
    }

    @Override
    public ICoreProduct getCoreProduct(int n) {
        ICoreProduct iCoreProduct = this.m_CoreProducts.get(Integer.toString(n));
        if (iCoreProduct == null) {
            if (!this.m_CoreProducts.isEmpty()) {
                iCoreProduct = this.m_CoreProducts.elements().nextElement();
            } else {
                iCoreProduct = new ADProduct();
                this.setCoreProduct(iCoreProduct);
                iCoreProduct.initialize();
            }
        }
        return iCoreProduct;
    }

    @Override
    public void setCoreProduct(int n, ICoreProduct iCoreProduct) {
        ICoreProduct iCoreProduct2 = this.m_CoreProducts.get(Integer.toString(n));
        if (iCoreProduct2 != null) {
            iCoreProduct2.quit();
        }
        if (iCoreProduct == null) {
            this.m_CoreProducts.remove(Integer.toString(n));
        } else {
            this.m_CoreProducts.put(Integer.toString(n), iCoreProduct);
        }
    }

    @Override
    public ETList<IProductDescriptor> getProducts() {
        ProductDescriptor[] productDescriptorArray = null;
        ETArrayList<IProductDescriptor> eTArrayList = new ETArrayList<IProductDescriptor>();
        if (this.m_CoreProducts != null && this.m_CoreProducts.size() > 0) {
            Enumeration<String> enumeration = this.m_CoreProducts.keys();
            int n = this.m_CoreProducts.size();
            productDescriptorArray = new ProductDescriptor[n];
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                ProductDescriptor productDescriptor = new ProductDescriptor();
                String string = enumeration.nextElement();
                if (string == null) continue;
                ICoreProduct iCoreProduct = this.m_CoreProducts.get(string);
                productDescriptor.setProcessID(Integer.parseInt(string));
                productDescriptor.setCoreProduct(iCoreProduct);
                eTArrayList.add(n2, productDescriptor);
                ++n2;
            }
        }
        return eTArrayList;
    }

    @Override
    public ICoreProductManager getProductManagerOnROT() {
        return m_ROTManager != null ? m_ROTManager : this;
    }

    @Override
    public void removeFromROT() {
        if (this.m_RevokeNum != 0L && this.m_CoreProducts.size() <= 1) {
            Enumeration<ICoreProduct> enumeration = this.m_CoreProducts.elements();
            while (enumeration.hasMoreElements()) {
                ICoreProduct iCoreProduct = enumeration.nextElement();
                iCoreProduct.preDestroy();
            }
            this.m_CoreProducts.clear();
        }
    }

    @Override
    public void setProductAlias(String string) {
        s_sProductAlias = string;
        s_nProductAliasPID = 0;
        if (this.m_RevokeNum != 0L) {
            this.removeFromROT();
            this.m_RevokeNum = 0L;
        }
    }

    @Override
    public String getProductAlias() {
        return s_sProductAlias != null && s_sProductAlias.length() > 0 ? s_sProductAlias : null;
    }
}

