/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core;

import java.io.File;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.IApplication;
import org.netbeans.modules.uml.core.IQueryManager;
import org.netbeans.modules.uml.core.QueryManager;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.coreapplication.ICoreProductEventDispatcher;
import org.netbeans.modules.uml.core.coreapplication.ICoreProductInitEventsSink;
import org.netbeans.modules.uml.core.eventframework.EventBlocker;
import org.netbeans.modules.uml.core.eventframework.EventDispatchNameKeeper;
import org.netbeans.modules.uml.core.eventframework.EventDispatchRetriever;
import org.netbeans.modules.uml.core.eventframework.IEventPayload;
import org.netbeans.modules.uml.core.metamodel.core.foundation.FactoryRetriever;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElementChangeEventDispatcher;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IExternalElementEventsSink;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IVersionableElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.PreventElementReEntrance;
import org.netbeans.modules.uml.core.metamodel.core.foundation.TypedFactoryRetriever;
import org.netbeans.modules.uml.core.metamodel.core.foundation.UMLXMLManip;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.metamodel.structure.IStructureEventDispatcher;
import org.netbeans.modules.uml.core.metamodel.structure.Project;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.ResultCell;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.URILocator;
import org.netbeans.modules.uml.core.support.umlsupport.Validator;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.InvalidArguments;
import org.netbeans.modules.uml.core.workspacemanagement.ITwoPhaseCommit;
import org.netbeans.modules.uml.core.workspacemanagement.IWSElement;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProjectEventDispatcher;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProjectEventsSink;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspaceEventDispatcher;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspaceManager;
import org.netbeans.modules.uml.core.workspacemanagement.WSProjectEventDispatcher;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceManagementException;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
implements IApplication,
IWSProjectEventsSink,
IExternalElementEventsSink,
ICoreProductInitEventsSink {
    private static final String MD_EXT = ".etd";
    private ArrayList<IProject> m_Projects = new ArrayList();
    private IQueryManager m_QueryManager;
    private IWorkspaceEventDispatcher m_EventDispatcher;
    private boolean m_Destroyed = false;
    public static final String MESSAGING_FACILITY = "UML";

    public Application() {
        this.initialize();
    }

    protected void initialize() {
        this.connectToWorkspace();
        this.establishDispatchers();
        this.establishQueryManager();
    }

    protected void connectToWorkspace() {
        ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
        if (iCoreProduct != null) {
            Object t = EventDispatchRetriever.instance().getDispatcher(EventDispatchNameKeeper.workspaceName());
            if (t != null && t instanceof IWorkspaceEventDispatcher) {
                this.m_EventDispatcher = (IWorkspaceEventDispatcher)t;
            }
            if (this.m_EventDispatcher != null) {
                IWorkspaceManager iWorkspaceManager = iCoreProduct.getWorkspaceManager();
                try {
                    iWorkspaceManager.setEventDispatcher(this.m_EventDispatcher);
                    this.m_EventDispatcher.registerForWSProjectEvents(this);
                }
                catch (InvalidArguments invalidArguments) {
                    invalidArguments.printStackTrace();
                    return;
                }
            }
        }
    }

    protected void establishDispatchers() {
        ICoreProductEventDispatcher iCoreProductEventDispatcher;
        IElementChangeEventDispatcher iElementChangeEventDispatcher = (IElementChangeEventDispatcher)EventDispatchRetriever.instance().getDispatcher(EventDispatchNameKeeper.modifiedName());
        if (iElementChangeEventDispatcher != null) {
            iElementChangeEventDispatcher.registerForExternalElementEventsSink(this);
        }
        if ((iCoreProductEventDispatcher = (ICoreProductEventDispatcher)EventDispatchRetriever.instance().getDispatcher(EventDispatchNameKeeper.coreProduct())) != null) {
            iCoreProductEventDispatcher.registerForInitEvents(this);
        }
    }

    protected void establishQueryManager() {
        this.m_QueryManager = new QueryManager();
        this.m_QueryManager.initialize();
    }

    @Override
    public IProject createProject() {
        return this.createProject("");
    }

    @Override
    public IProject openProject(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null filename");
        }
        IProject iProject = null;
        File file = new File(string);
        if (file.exists() && (iProject = this.getProjectByFileName(file.toString())) == null) {
            IEventPayload iEventPayload;
            IWorkspace iWorkspace;
            boolean bl;
            IStructureEventDispatcher iStructureEventDispatcher;
            String string2 = this.getProjectOpenMessage();
            if (string2 != null && string2.length() > 0) {
                StringUtilities.replaceSubString(string2, "%1", string);
            }
            if ((iStructureEventDispatcher = this.getProjectDispatcher()) != null && (bl = iStructureEventDispatcher.fireProjectPreOpen(iWorkspace = this.getCurrentWorkspace(), string, iEventPayload = iStructureEventDispatcher.createPayload("ProjectPreOpen")))) {
                UMLXMLManip uMLXMLManip = new UMLXMLManip();
                if (UMLXMLManip.verifyDTDExistence(string)) {
                    Document document = Validator.verifyXMLFileFormat(string, "XMI");
                    iProject = this.establishOpenProject(document, string);
                    if (iProject == null) {
                        return null;
                    }
                    if (this.m_QueryManager != null) {
                        String string3 = StringUtilities.getPath(iProject.getFileName());
                        File file2 = new File(string3 = string3 + ".QueryCache");
                        if (file2.exists() && !file2.isDirectory()) {
                            try {
                                FileObject fileObject = FileUtil.toFileObject((File)new File(file2.getCanonicalPath()));
                                if (fileObject != null) {
                                    fileObject.delete();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.m_QueryManager.establishCache(iProject);
                    }
                    iEventPayload = iStructureEventDispatcher.createPayload("ProjectOpened");
                    iStructureEventDispatcher.fireProjectOpened(iProject, iEventPayload);
                }
            }
        }
        return iProject;
    }

    protected IProject establishOpenProject(Document document, String string) {
        IProject iProject = null;
        if (this.m_Projects != null) {
            TypedFactoryRetriever typedFactoryRetriever;
            Node node;
            iProject = this.getProjectByFileName(string);
            Log.out("Establishing open project for file " + string);
            if (iProject == null && document != null && (node = document.selectSingleNode("/XMI/XMI.content/UML:Project")) != null && (iProject = (IProject)(typedFactoryRetriever = new TypedFactoryRetriever()).createTypeAndFill("Project", node)) != null) {
                iProject.setDocument(document);
                iProject.setFileName(string);
                UMLXMLManip.convertRelativeHrefs(string, iProject);
                iProject.loadDefaultImports();
                this.attachProject(iProject);
            }
        }
        return iProject;
    }

    protected void attachProject(IProject iProject) {
        FactoryRetriever factoryRetriever = FactoryRetriever.instance();
        if (factoryRetriever != null) {
            factoryRetriever.addObject(iProject);
        }
        if (!this.m_Projects.contains(iProject)) {
            this.m_Projects.add(iProject);
        }
    }

    protected IWorkspace getCurrentWorkspace() {
        ICoreProduct iCoreProduct = this.getProduct();
        return iCoreProduct.getCurrentWorkspace();
    }

    protected ICoreProduct getProduct() {
        return ProductRetriever.retrieveProduct();
    }

    private IStructureEventDispatcher getProjectDispatcher() {
        EventDispatchRetriever eventDispatchRetriever = EventDispatchRetriever.instance();
        IStructureEventDispatcher iStructureEventDispatcher = null;
        Object t = eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.structure());
        if (t != null && t instanceof IStructureEventDispatcher) {
            iStructureEventDispatcher = (IStructureEventDispatcher)t;
        }
        return iStructureEventDispatcher;
    }

    private String getProjectOpenMessage() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeProject(IProject iProject, boolean bl) {
        PreventElementReEntrance preventElementReEntrance = new PreventElementReEntrance(this);
        try {
            if (preventElementReEntrance.isBlocking()) {
                return;
            }
            IStructureEventDispatcher iStructureEventDispatcher = this.getProjectDispatcher();
            boolean bl2 = true;
            if (iStructureEventDispatcher != null) {
                IEventPayload iEventPayload = iStructureEventDispatcher.createPayload("ProjectPreClose");
                bl2 = iStructureEventDispatcher.fireProjectPreClose(iProject, iEventPayload);
            }
            if (bl2) {
                if (bl) {
                    this.saveProject(iProject);
                }
                int n = this.m_Projects.size();
                for (int i = 0; i < n; ++i) {
                    IProject iProject2 = this.m_Projects.get(i);
                    if (!iProject2.isSame(iProject)) continue;
                    this.m_Projects.remove(i);
                    if (iStructureEventDispatcher == null) break;
                    IEventPayload iEventPayload = iStructureEventDispatcher.createPayload("ProjectClosed");
                    iStructureEventDispatcher.fireProjectClosed(iProject, iEventPayload);
                    break;
                }
                iProject.close();
            }
        }
        finally {
            preventElementReEntrance.releaseBlock();
        }
    }

    @Override
    public void saveProject(IProject iProject) {
        Object object;
        if (iProject != null && (object = iProject.getFileName()) != null && ((String)object).length() > 0 && iProject.getDirty()) {
            iProject.save((String)object, true);
        }
        object = ProductHelper.getProductDiagramManager();
        ETList<IProxyDiagram> eTList = object.getOpenDiagrams();
        for (IProxyDiagram iProxyDiagram : eTList) {
            IDiagram iDiagram = iProxyDiagram.getDiagram();
            if (iDiagram == null || iDiagram.getProject() == null || !iDiagram.getProject().equals(iProject) || !iDiagram.getIsDirty()) continue;
            iDiagram.save();
        }
    }

    @Override
    public void closeAllProjects(boolean bl) {
        ResultCell resultCell;
        boolean bl2;
        if (this.m_Projects != null && (bl2 = (resultCell = new ResultCell()).canContinue())) {
            int n = this.m_Projects.size();
            while (n > 0) {
                IProject iProject = this.m_Projects.get(0);
                this.closeProject(iProject, bl);
                n = this.m_Projects.size();
            }
        }
    }

    @Override
    public ETList<IProject> getProjects() {
        return this.getProjects("etd");
    }

    @Override
    public ETList<IProject> getProjects(String string) {
        ETArrayList<IProject> eTArrayList = new ETArrayList<IProject>();
        try {
            if (this.m_Projects != null && string != null && string.length() > 0) {
                int n = this.m_Projects.size();
                for (int i = 0; i < n; ++i) {
                    String string2;
                    String string3;
                    IProject iProject = this.m_Projects.get(i);
                    if (iProject == null || (string3 = iProject.getFileName()) == null || string3.length() <= 0 || !string.equalsIgnoreCase(string2 = StringUtilities.getExtension(string3))) continue;
                    eTArrayList.add(iProject);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return eTArrayList;
    }

    @Override
    public IProject getProjectByName(String string) {
        if (string != null && this.m_Projects != null) {
            for (IProject iProject : this.m_Projects) {
                if (!string.equals(iProject.getName())) continue;
                return iProject;
            }
        }
        return null;
    }

    @Override
    public IProject getProjectByName(IWorkspace iWorkspace, String string) {
        IProject iProject = null;
        if (iWorkspace == null) {
            iWorkspace = this.getCurrentWorkspace();
        }
        if (this.m_Projects != null && iWorkspace != null) {
            int n = this.m_Projects.size();
            for (int i = 0; i < n; ++i) {
                String string2;
                IProject iProject2 = this.m_Projects.get(i);
                String string3 = iProject2.getName();
                if (!string.equals(string3) || (string2 = iProject2.getFileName()) == null || string2.length() <= 0) continue;
                if (StringUtilities.hasExtension(string2, ".etpat")) {
                    iProject = iProject2;
                    break;
                }
                try {
                    iWorkspace.verifyUniqueElementLocation(string2);
                    iProject = iProject2;
                    break;
                }
                catch (WorkspaceManagementException workspaceManagementException) {
                    workspaceManagementException.printStackTrace();
                }
            }
        }
        return iProject;
    }

    @Override
    public IProject getProjectByFileName(String string) {
        if (this.m_Projects != null) {
            File file = new File(string);
            for (IProject iProject : this.m_Projects) {
                String string2 = iProject.getFileName();
                if (string2 == null || !file.equals(new File(iProject.getFileName()))) continue;
                return iProject;
            }
        }
        return null;
    }

    @Override
    public IProject getProjectByID(String string) {
        IProject iProject = null;
        if (this.m_Projects != null) {
            int n = this.m_Projects.size();
            for (int i = 0; i < n; ++i) {
                String string2;
                IProject iProject2;
                Node node;
                IProject iProject3 = this.m_Projects.get(i);
                if (!(iProject3 instanceof IVersionableElement) || (node = (iProject2 = iProject3).getNode()) == null || (string2 = XMLManip.getAttributeValue(node, "xmi.id")) == null || !string2.equals(string)) continue;
                iProject = iProject3;
                break;
            }
        }
        if (iProject == null) {
            iProject = this.resolveProjectByID(string);
        }
        return iProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProject resolveProjectByID(String string) {
        IProject iProject;
        block8: {
            iProject = null;
            PreventElementReEntrance preventElementReEntrance = new PreventElementReEntrance(this);
            try {
                int n;
                ETList<IWSElement> eTList;
                if (preventElementReEntrance.isBlocking()) {
                    IProject iProject2 = iProject;
                    return iProject2;
                }
                IWorkspace iWorkspace = this.getCurrentWorkspace();
                if (iWorkspace == null || (eTList = iWorkspace.getElementsByDataValue(string)) == null || (n = eTList.size()) <= 0) break block8;
                try {
                    IWSProject iWSProject;
                    IWSElement iWSElement = (IWSElement)eTList.get(0);
                    String string2 = iWSElement.getLocation();
                    if (string2.length() > 0 && (iWSProject = iWorkspace.openWSProjectByLocation(string2)) != null && (iProject = this.openProjectFromWSProject(iWSProject)) != null) {
                        String string3 = iProject.getName();
                    }
                }
                catch (WorkspaceManagementException workspaceManagementException) {
                    // empty catch block
                }
            }
            finally {
                preventElementReEntrance.releaseBlock();
            }
        }
        return iProject;
    }

    @Override
    public IWorkspace createWorkspace(String string, String string2) {
        IWorkspace iWorkspace = null;
        try {
            ICoreProduct iCoreProduct = this.getProduct();
            if (iCoreProduct != null) {
                iWorkspace = iCoreProduct.createWorkspace(string, string2);
            }
        }
        catch (InvalidArguments invalidArguments) {
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            // empty catch block
        }
        return iWorkspace;
    }

    @Override
    public IWorkspace openWorkspace(String string) {
        IWorkspace iWorkspace = null;
        try {
            ICoreProduct iCoreProduct = this.getProduct();
            if (iCoreProduct != null) {
                iWorkspace = iCoreProduct.openWorkspace(string);
            }
        }
        catch (InvalidArguments invalidArguments) {
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            // empty catch block
        }
        return iWorkspace;
    }

    @Override
    public void closeWorkspace(IWorkspace iWorkspace, String string, boolean bl) {
        try {
            ICoreProduct iCoreProduct = this.getProduct();
            if (iCoreProduct != null) {
                iCoreProduct.closeWorkspace(iWorkspace, string, bl);
            }
        }
        catch (InvalidArguments invalidArguments) {
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWSProject importProject(IWorkspace iWorkspace, IProject iProject) {
        boolean bl;
        IWSProject iWSProject = null;
        String string = iProject.getName();
        if (string.length() > 0 && (bl = this.dispatchPreProjectImportEvent(string, iWorkspace))) {
            String string2 = iProject.getFileName();
            IWSProject iWSProject2 = null;
            try {
                EventBlocker.startBlocking();
                iWSProject2 = iWorkspace.createWSProject(string2, string);
            }
            catch (Exception exception) {
            }
            finally {
                EventBlocker.stopBlocking(false);
            }
            if (iWSProject2 != null) {
                this.attachProject(iProject);
                iWSProject = iWSProject2;
                this.addProjectToWSProject(iWSProject2, iProject);
                this.dispatchProjectImported(iWSProject2);
            }
        }
        return iWSProject;
    }

    private void dispatchProjectImported(IWSProject iWSProject) {
        try {
            IWSProjectEventDispatcher iWSProjectEventDispatcher = this.prepareWSProjectDispatcher();
            if (iWSProjectEventDispatcher != null) {
                iWSProjectEventDispatcher.dispatchWSProjectInserted(iWSProject);
            }
        }
        catch (InvalidArguments invalidArguments) {
            // empty catch block
        }
    }

    private IWSProjectEventDispatcher prepareWSProjectDispatcher() {
        WSProjectEventDispatcher wSProjectEventDispatcher = new WSProjectEventDispatcher();
        wSProjectEventDispatcher.setEventDispatcher(this.m_EventDispatcher);
        return wSProjectEventDispatcher;
    }

    private boolean dispatchPreProjectImportEvent(String string, IWorkspace iWorkspace) {
        boolean bl = true;
        try {
            if (iWorkspace != null) {
                IWSProjectEventDispatcher iWSProjectEventDispatcher = this.prepareWSProjectDispatcher();
                bl = iWSProjectEventDispatcher.dispatchWSProjectPreInsert(iWorkspace, string);
            }
        }
        catch (InvalidArguments invalidArguments) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public IProject openProject(IWorkspace iWorkspace, String string) {
        IProject iProject = this.getProjectByName(iWorkspace, string);
        try {
            IWSProject iWSProject;
            if (iProject == null && (iWSProject = iWorkspace.openWSProjectByName(string)) != null) {
                iProject = this.openProjectFromWSProject(iWSProject);
            }
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            // empty catch block
        }
        return iProject;
    }

    @Override
    public IProject openProject(IWorkspace iWorkspace, IWSProject iWSProject) {
        IProject iProject = null;
        String string = iWSProject.getName();
        iProject = this.openProject(iWorkspace, string);
        return iProject;
    }

    @Override
    public void destroy() {
        if (!this.m_Destroyed) {
            this.m_Destroyed = true;
            try {
                if (this.m_QueryManager != null) {
                    this.m_QueryManager.deinitialize();
                    this.m_QueryManager = null;
                }
                this.closeAllProjects(false);
                if (this.m_EventDispatcher != null) {
                    this.m_EventDispatcher.revokeWSProjectSink(this);
                    this.revokeDispatchers();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void revokeDispatchers() {
        ICoreProductEventDispatcher iCoreProductEventDispatcher;
        IElementChangeEventDispatcher iElementChangeEventDispatcher = (IElementChangeEventDispatcher)EventDispatchRetriever.instance().getDispatcher(EventDispatchNameKeeper.modifiedName());
        if (iElementChangeEventDispatcher != null) {
            iElementChangeEventDispatcher.revokeExternalElementEventsSink(this);
        }
        if ((iCoreProductEventDispatcher = (ICoreProductEventDispatcher)EventDispatchRetriever.instance().getDispatcher(EventDispatchNameKeeper.coreProduct())) != null) {
            iCoreProductEventDispatcher.revokeInitSink(this);
        }
    }

    @Override
    public String getInstallLocation() {
        return null;
    }

    @Override
    public int getNumClosedProjects() {
        int n = 0;
        try {
            ETList<IWSProject> eTList;
            IWorkspace iWorkspace = this.getCurrentWorkspace();
            if (iWorkspace != null && (eTList = iWorkspace.getWSProjects()) != null) {
                int n2 = eTList.size();
                for (int i = 0; i < n2; ++i) {
                    String string;
                    IWSProject iWSProject = (IWSProject)eTList.get(i);
                    String string2 = iWSProject.getName();
                    boolean bl = iWSProject.isOpen();
                    if (string2.length() <= 0 || (string = iWSProject.getLocation()).length() <= 0 || bl || !StringUtilities.hasExtension(string, MD_EXT)) continue;
                    ++n;
                }
            }
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public int getNumOpenedProjects() {
        int n = 0;
        if (this.m_Projects != null) {
            int n2 = this.m_Projects.size();
            for (int i = 0; i < n2; ++i) {
                String string;
                IProject iProject = this.m_Projects.get(i);
                String string2 = iProject.getFileName();
                if (string2.length() <= 0 || (string = StringUtilities.getExtension(string2)) == null || !string.equalsIgnoreCase("etd")) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public IQueryManager getQueryManager() {
        return this.m_QueryManager;
    }

    @Override
    public void setQueryManager(IQueryManager iQueryManager) {
        this.m_QueryManager = iQueryManager;
    }

    @Override
    public void onWSProjectPreCreate(IWorkspace iWorkspace, String string, IResultCell iResultCell) {
    }

    @Override
    public void onWSProjectCreated(IWSProject iWSProject, IResultCell iResultCell) {
        String string;
        String string2;
        IProject iProject;
        if (iWSProject != null && (iProject = this.createProject(string2 = this.deriveProjectFileName(iWSProject, string = iWSProject.getName()))) != null) {
            iProject.setName(string);
            try {
                this.addProjectToWSProject(iWSProject, iProject);
            }
            catch (WorkspaceManagementException workspaceManagementException) {
                workspaceManagementException.printStackTrace();
            }
        }
    }

    protected IProject openProjectFromWSProject(IWSProject iWSProject) throws WorkspaceManagementException {
        if (iWSProject == null) {
            throw new IllegalArgumentException("null wsproject");
        }
        IWSElement iWSElement = iWSProject.getElementByName("_MetaData__");
        if (iWSElement != null) {
            IProject iProject = this.openProject(iWSElement.getLocation());
            if (iProject != null) {
                this.establishTwoPhaseConnection(iWSElement, iProject);
            }
            return iProject;
        }
        return null;
    }

    protected IProject retrieveProjectFromWSProject(IWSProject iWSProject) {
        ITwoPhaseCommit iTwoPhaseCommit;
        IWSElement iWSElement;
        IProject iProject = null;
        if (iWSProject != null && (iWSElement = iWSProject.getElementByName("_MetaData__")) != null && (iTwoPhaseCommit = iWSElement.getTwoPhaseCommit()) instanceof IProject) {
            iProject = (IProject)iTwoPhaseCommit;
        }
        return iProject;
    }

    protected void addProjectToWSProject(IWSProject iWSProject, IProject iProject) throws WorkspaceManagementException {
        String string = iProject.getFileName();
        if (string == null || string.length() == 0) {
            string = this.deriveProjectFileName(iWSProject, iProject.getName());
            iProject.setFileName(string);
        }
        IWSElement iWSElement = iWSProject.addElement(string, "_MetaData__", iProject.getXMIID());
        this.establishTwoPhaseConnection(iWSElement, iProject);
    }

    protected void establishTwoPhaseConnection(IWSElement iWSElement, IProject iProject) {
        iWSElement.setTwoPhaseCommit(iProject);
    }

    protected IProject createProject(String string) {
        IStructureEventDispatcher iStructureEventDispatcher = this.getProjectDispatcher();
        boolean bl = true;
        if (iStructureEventDispatcher != null) {
            bl = this.fireProjectPreCreate(iStructureEventDispatcher);
        }
        if (bl) {
            if (this.m_Projects == null) {
                this.m_Projects = new ArrayList();
            }
            try {
                XMLManip xMLManip = XMLManip.instance();
                Document document = xMLManip.getDOMDocument();
                Project project = new Project();
                project.setDocument(document);
                project.prepareNode();
                project.setFileName(string);
                this.attachProject(project);
                if (this.m_QueryManager != null) {
                    this.m_QueryManager.establishCache(project);
                }
                if (iStructureEventDispatcher != null) {
                    iStructureEventDispatcher.fireProjectCreated(project, iStructureEventDispatcher.createPayload("ProjectCreated"));
                }
                return project;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    protected boolean fireProjectPreCreate(IStructureEventDispatcher iStructureEventDispatcher) {
        boolean bl = true;
        IWorkspace iWorkspace = this.getCurrentWorkspace();
        if (iWorkspace != null) {
            IEventPayload iEventPayload = iStructureEventDispatcher.createPayload("ProjectPreCreate");
            bl = iStructureEventDispatcher.fireProjectPreCreate(iWorkspace, iEventPayload);
        }
        return bl;
    }

    protected String deriveProjectFileName(IWSProject iWSProject, String string) {
        if (iWSProject == null) {
            throw new IllegalArgumentException("null project");
        }
        if (string == null || string.length() == 0) {
            string = "_MetaData__";
        }
        string = string + MD_EXT;
        String string2 = iWSProject.getBaseDirectory();
        if (string2 == null) {
            string2 = this.getCurrentWorkspace().getBaseDirectory();
        }
        return new File(string2, string).toString();
    }

    @Override
    public void onWSProjectPreOpen(IWorkspace iWorkspace, String string, IResultCell iResultCell) {
    }

    @Override
    public void onWSProjectOpened(IWSProject iWSProject, IResultCell iResultCell) {
        try {
            this.openProjectFromWSProject(iWSProject);
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            workspaceManagementException.printStackTrace();
        }
    }

    @Override
    public void onWSProjectPreRemove(IWSProject iWSProject, IResultCell iResultCell) {
    }

    @Override
    public void onWSProjectRemoved(IWSProject iWSProject, IResultCell iResultCell) {
        IProject iProject;
        boolean bl = iWSProject.isOpen();
        if (bl && (iProject = this.retrieveProjectFromWSProject(iWSProject)) != null) {
            this.closeProject(iProject, false);
        }
    }

    @Override
    public void onWSProjectPreInsert(IWorkspace iWorkspace, String string, IResultCell iResultCell) {
    }

    @Override
    public void onWSProjectInserted(IWSProject iWSProject, IResultCell iResultCell) {
    }

    @Override
    public void onWSProjectPreRename(IWSProject iWSProject, String string, IResultCell iResultCell) {
    }

    @Override
    public void onWSProjectRenamed(IWSProject iWSProject, String string, IResultCell iResultCell) {
    }

    @Override
    public void onWSProjectPreClose(IWSProject iWSProject, IResultCell iResultCell) {
    }

    @Override
    public void onWSProjectClosed(IWSProject iWSProject, IResultCell iResultCell) {
        IProject iProject = this.retrieveProjectFromWSProject(iWSProject);
        if (iProject != null) {
            this.closeProject(iProject, false);
        }
    }

    @Override
    public void onWSProjectPreSave(IWSProject iWSProject, IResultCell iResultCell) {
    }

    @Override
    public void onWSProjectSaved(IWSProject iWSProject, IResultCell iResultCell) {
        IProject iProject = this.retrieveProjectFromWSProject(iWSProject);
        if (iProject != null) {
            this.saveProject(iProject);
        }
    }

    @Override
    public void onExternalElementPreLoaded(String string, IResultCell iResultCell) {
        try {
            if (string != null && string.length() > 0) {
                URILocator.uriparts(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onExternalElementLoaded(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onPreInitialExtraction(String string, IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onInitialExtraction(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductPreInit(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductInitialized(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductPreQuit(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductPreSaved(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductSaved(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public String getApplicationVersion() {
        return "6.1.4.837";
    }
}

