/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.designtime;

import com.sun.rave.designtime.DisplayAction;
import com.sun.rave.designtime.ResultMessage;
import java.util.ArrayList;

public class Result {
    public static final Result SUCCESS = new Result(true);
    public static final Result FAILURE = new Result(false);
    protected boolean success;
    protected ArrayList messages;
    protected ArrayList options;
    protected String dialogTitle;
    protected String helpKey;

    public Result(boolean success) {
        this.success = success;
    }

    public Result(boolean success, ResultMessage message) {
        this(success);
        this.addMessage(message);
    }

    public Result(boolean success, ResultMessage[] messages) {
        this(success);
        for (int i = 0; messages != null && i < messages.length; ++i) {
            this.addMessage(messages[i]);
        }
    }

    public Result(boolean success, ResultMessage[] messages, DisplayAction[] options) {
        this(success, messages);
        for (int i = 0; options != null && i < options.length; ++i) {
            this.addResultOption(options[i]);
        }
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void addMessage(ResultMessage message) {
        if (message == null) {
            return;
        }
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        if (!this.messages.contains(message)) {
            this.messages.add(message);
        }
    }

    public void addMessages(ResultMessage[] messages) {
        if (messages == null || messages.length < 1) {
            return;
        }
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        for (int i = 0; i < messages.length; ++i) {
            if (this.messages.contains(messages[i])) continue;
            this.messages.add(messages[i]);
        }
    }

    public void removeMessage(ResultMessage message) {
        if (this.messages == null || message == null) {
            return;
        }
        this.messages.remove(message);
        if (this.messages.size() == 0) {
            this.messages = null;
        }
    }

    public void removeMessages(ResultMessage[] messages) {
        if (this.messages == null || messages == null || messages.length < 1) {
            return;
        }
        for (int i = 0; i < messages.length; ++i) {
            this.messages.remove(messages[i]);
        }
        if (this.messages.size() == 0) {
            this.messages = null;
        }
    }

    public int getMessageCount() {
        return this.messages != null ? this.messages.size() : 0;
    }

    public ResultMessage[] getMessages() {
        return this.messages != null ? this.messages.toArray(new ResultMessage[this.messages.size()]) : null;
    }

    public void addResultOption(DisplayAction option) {
        if (option == null) {
            return;
        }
        if (this.options == null) {
            this.options = new ArrayList();
        }
        if (!this.options.contains(option)) {
            this.options.add(option);
        }
    }

    public void addResultOptions(DisplayAction[] options) {
        if (options == null || options.length < 1) {
            return;
        }
        if (this.options == null) {
            this.options = new ArrayList();
        }
        for (int i = 0; i < options.length; ++i) {
            if (this.options.contains(options[i])) continue;
            this.options.add(options[i]);
        }
    }

    public void removeResultOption(DisplayAction option) {
        if (this.options == null || option == null) {
            return;
        }
        this.options.remove(option);
        if (this.options.size() == 0) {
            this.options = null;
        }
    }

    public void removeResultOptions(DisplayAction[] options) {
        if (this.options == null || options == null || options.length < 1) {
            return;
        }
        for (int i = 0; i < options.length; ++i) {
            this.options.remove(options[i]);
        }
        if (this.options.size() == 0) {
            this.options = null;
        }
    }

    public int getResultOptionCount() {
        return this.options != null ? this.options.size() : 0;
    }

    public DisplayAction[] getResultOptions() {
        return this.options != null ? this.options.toArray(new DisplayAction[this.options.size()]) : null;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogHelpKey(String helpKey) {
        this.helpKey = helpKey;
    }

    public String getDialogHelpKey() {
        return this.helpKey;
    }
}

