/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.visualweb.complib.ComplibManifest;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.Version;
import org.netbeans.modules.visualweb.complib.api.ComplibException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Complib
implements Comparable<Complib> {
    private ComplibManifest compLibManifest;
    private List<File> runtimePath;
    private List<File> designTimePath;
    private List<File> javadocPath;
    private List<File> sourcePath;
    private List<File> webResourcePath;
    private List<File> helpPath;

    protected void initCompLibManifest(ComplibManifest complibManifest) {
        this.compLibManifest = complibManifest;
    }

    protected ComplibManifest getCompLibManifest() {
        return this.compLibManifest;
    }

    protected void initPaths() throws ComplibException {
        this.runtimePath = this.convertConfigPathToFileList(this.compLibManifest.getRuntimePath());
        this.designTimePath = this.convertConfigPathToFileList(this.compLibManifest.getDeclaredDesignTimePath());
        this.javadocPath = this.convertConfigPathToFileList(this.compLibManifest.getJavadocPath());
        this.sourcePath = this.convertConfigPathToFileList(this.compLibManifest.getSourcePath());
        this.webResourcePath = this.convertConfigPathToFileList(this.compLibManifest.getWebResourcePath());
        this.helpPath = this.convertConfigPathToFileList(this.compLibManifest.getHelpPath());
    }

    protected abstract List<File> convertConfigPathToFileList(List<String> var1) throws ComplibException;

    public Identifier getIdentifier() {
        return this.compLibManifest.getIdentifier();
    }

    public String getTitle() {
        return this.compLibManifest.getTitle();
    }

    public String getVersionedTitle() {
        return this.getTitle() + " (" + this.getIdentifier().getVersionString() + ")";
    }

    public List<File> getRuntimePath() {
        return this.runtimePath;
    }

    public List<File> getDesignTimePath() {
        return this.designTimePath;
    }

    public List<File> getJavadocPath() {
        return this.javadocPath;
    }

    public List<File> getSourcePath() {
        return this.sourcePath;
    }

    public List<File> getWebResourcePath() {
        return this.webResourcePath;
    }

    public List<File> getHelpPath() {
        return this.helpPath;
    }

    public String getHelpSetFile() {
        return this.compLibManifest.getHelpSetFile();
    }

    public String getHelpPrefix() {
        return this.compLibManifest.getHelpPrefix();
    }

    public List<InitialPaletteFolder> getInitialPaletteFolders() {
        return this.compLibManifest.getInitialPalette();
    }

    public List<InitialPaletteFolder> getComponentItemsInFolders() throws ComplibException {
        return this.compLibManifest.getInitialPalette();
    }

    abstract BeanInfo getBeanInfo(String var1) throws ClassNotFoundException, IntrospectionException;

    boolean isHidden(String string) {
        BeanInfo beanInfo;
        try {
            beanInfo = this.getBeanInfo(string);
        }
        catch (Exception exception) {
            IdeUtil.logWarning(exception);
            return false;
        }
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        return beanDescriptor.isHidden();
    }

    public abstract ClassLoader getClassLoader();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Complib) {
            Complib complib = (Complib)object;
            if (this.getIdentifier().equals(complib.getIdentifier())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    @Override
    public int compareTo(Complib complib) {
        URI uRI;
        URI uRI2 = this.getIdentifier().getNamespaceUri();
        if (!uRI2.equals(uRI = complib.getIdentifier().getNamespaceUri())) {
            return uRI2.compareTo(uRI);
        }
        Version version = this.getIdentifier().getVersion();
        Version version2 = complib.getIdentifier().getVersion();
        return version.compareTo(version2);
    }

    public static class InitialPaletteItem
    extends AbstractParent {
        private String className;

        InitialPaletteItem(String string) {
            this.className = string;
        }

        public String getClassName() {
            return this.className;
        }
    }

    public static class InitialPaletteFolder
    extends AbstractParent {
        private String name;

        InitialPaletteFolder(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractParent {
        private ArrayList<InitialPaletteItem> children = new ArrayList();

        private AbstractParent() {
        }

        public List<InitialPaletteItem> getChildren() {
            return this.children;
        }

        public void appendChild(InitialPaletteItem initialPaletteItem) {
            this.children.add(initialPaletteItem);
        }
    }

    public static class Identifier {
        private URI uri;
        private Version version;

        public Identifier(URI uRI, int n, int n2, int n3) {
            if (uRI == null) {
                throw new IllegalArgumentException("URI must not be null");
            }
            this.uri = uRI;
            this.version = new Version(n, n2, n3);
        }

        public Identifier(String string, String string2) {
            try {
                this.uri = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Invalid library URI", uRISyntaxException);
            }
            try {
                this.version = new Version(string2);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Invalid library version", exception);
            }
        }

        public URI getNamespaceUri() {
            return this.uri;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getNamespaceUriString() {
            return this.uri.toASCIIString();
        }

        public String getVersionString() {
            return this.version.toString();
        }

        public String toString() {
            return this.asString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Identifier) {
                Identifier identifier = (Identifier)object;
                if (this.uri.equals(identifier.uri) && this.getVersionString().equals(identifier.getVersionString())) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.uri.hashCode() + this.version.hashCode();
        }

        public String asString() {
            return "(uri=" + this.getNamespaceUriString() + ", version=" + this.getVersionString() + ")";
        }
    }
}

