/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public class DuplicateCompilerSetPanel
extends JPanel
implements DocumentListener {
    private DialogDescriptor dialogDescriptor = null;
    private CompilerSetManager csm;
    private JComboBox cbFamily;
    private JScrollPane jScrollPane1;
    private JLabel lbBaseDirectory;
    private JLabel lbError;
    private JLabel lbFamily;
    private JLabel lbName;
    private JTextArea taInfo;
    private JTextField tfBaseDirectory;
    private JTextField tfName;

    public DuplicateCompilerSetPanel(CompilerSetManager compilerSetManager, CompilerSet compilerSet) {
        this.initComponents();
        this.csm = compilerSetManager;
        List list = CompilerSet.CompilerFlavor.getFlavors();
        for (CompilerSet.CompilerFlavor compilerFlavor : list) {
            this.cbFamily.addItem(compilerFlavor);
        }
        this.tfBaseDirectory.setText(compilerSet.getDirectory());
        this.cbFamily.setSelectedItem((Object)compilerSet.getCompilerFlavor());
        this.updateDataFamily();
        this.taInfo.setBackground(this.getBackground());
        this.validateData();
        this.setPreferredSize(new Dimension(600, 300));
        this.tfName.getDocument().addDocumentListener(this);
    }

    private static String getString(String string) {
        return NbBundle.getMessage(DuplicateCompilerSetPanel.class, (String)string);
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dialogDescriptor = dialogDescriptor;
        this.validateData();
    }

    private void updateDataFamily() {
        CompilerSet.CompilerFlavor compilerFlavor = (CompilerSet.CompilerFlavor)((Object)this.cbFamily.getSelectedItem());
        String string = this.csm.getUniqueCompilerSetName(compilerFlavor.toString());
        this.tfName.setText(string);
        this.updateDataName();
    }

    private void updateDataName() {
        this.validateData();
    }

    private void validateData() {
        boolean bl = true;
        this.lbError.setText("");
        String string = IpeUtils.replaceOddCharacters(this.tfName.getText().trim(), '_');
        if (bl && string.length() == 0 || string.contains("|")) {
            bl = false;
            this.lbError.setText(DuplicateCompilerSetPanel.getString("NAME_INVALID"));
        }
        if (bl && this.csm.getCompilerSet(string.trim()) != null) {
            bl = false;
            this.lbError.setText(DuplicateCompilerSetPanel.getString("TOOLNAME_ALREADY_EXISTS"));
        }
        if (this.dialogDescriptor != null) {
            this.dialogDescriptor.setValid(bl);
        }
    }

    private void handleUpdate(DocumentEvent documentEvent) {
        this.updateDataName();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public String getBaseDirectory() {
        return this.tfBaseDirectory.getText();
    }

    public CompilerSet.CompilerFlavor getFamily() {
        return (CompilerSet.CompilerFlavor)((Object)this.cbFamily.getSelectedItem());
    }

    public String getCompilerSetName() {
        return IpeUtils.replaceOddCharacters(this.tfName.getText().trim(), '_');
    }

    private void initComponents() {
        this.lbBaseDirectory = new JLabel();
        this.tfName = new JTextField();
        this.lbFamily = new JLabel();
        this.cbFamily = new JComboBox();
        this.lbName = new JLabel();
        this.tfBaseDirectory = new JTextField();
        this.lbError = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taInfo = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.lbBaseDirectory.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("lbBaseDirectory_MN").charAt(0));
        this.lbBaseDirectory.setLabelFor(this.tfBaseDirectory);
        this.lbBaseDirectory.setText(NbBundle.getMessage(DuplicateCompilerSetPanel.class, (String)"AddCompilerSetPanel.lbBaseDirectory.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(16, 16, 0, 0);
        this.add((Component)this.lbBaseDirectory, gridBagConstraints);
        this.tfName.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 16, 16);
        this.add((Component)this.tfName, gridBagConstraints);
        this.tfName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DuplicateCompilerSetPanel.class, (String)"AddCompilerSetPanel.tfName.AccessibleContext.accessibleDescription"));
        this.lbFamily.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("lbFamily_MN").charAt(0));
        this.lbFamily.setLabelFor(this.cbFamily);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle");
        this.lbFamily.setText(resourceBundle.getString("AddCompilerSetPanel.lbFamily.text"));
        this.lbFamily.setToolTipText(resourceBundle.getString("AddCompilerSetPanel.lbFamily.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.add((Component)this.lbFamily, gridBagConstraints);
        this.cbFamily.setEnabled(false);
        this.cbFamily.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DuplicateCompilerSetPanel.this.cbFamilyActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 16);
        this.add((Component)this.cbFamily, gridBagConstraints);
        this.lbName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("lbToolSetName_MN").charAt(0));
        this.lbName.setLabelFor(this.tfName);
        this.lbName.setText(NbBundle.getMessage(DuplicateCompilerSetPanel.class, (String)"AddCompilerSetPanel.lbName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 16, 16, 0);
        this.add((Component)this.lbName, gridBagConstraints);
        this.tfBaseDirectory.setColumns(40);
        this.tfBaseDirectory.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 4, 0, 16);
        this.add((Component)this.tfBaseDirectory, gridBagConstraints);
        this.tfBaseDirectory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DuplicateCompilerSetPanel.class, (String)"AddCompilerSetPanel.tfBaseDirectory.AccessibleContext.accessibleDescription"));
        this.lbError.setForeground(new Color(255, 51, 51));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 16, 16, 16);
        this.add((Component)this.lbError, gridBagConstraints);
        this.jScrollPane1.setBorder(null);
        this.taInfo.setColumns(20);
        this.taInfo.setEditable(false);
        this.taInfo.setLineWrap(true);
        this.taInfo.setText(NbBundle.getMessage(DuplicateCompilerSetPanel.class, (String)"CopyCompilerSetPanel.taInfo.text"));
        this.taInfo.setWrapStyleWord(true);
        this.taInfo.setBorder(null);
        this.jScrollPane1.setViewportView(this.taInfo);
        this.taInfo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DuplicateCompilerSetPanel.class, (String)"AddCompilerSetPanel.taInfo.AccessibleContext.accessibleName"));
        this.taInfo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DuplicateCompilerSetPanel.class, (String)"AddCompilerSetPanel.taInfo.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(16, 16, 0, 16);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DuplicateCompilerSetPanel.class, (String)"AddCompilerSetPanel.AccessibleContext.accessibleDescription"));
    }

    private void cbFamilyActionPerformed(ActionEvent actionEvent) {
        this.updateDataFamily();
    }
}

