/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import org.netbeans.modules.cnd.makewizard.EnterItemsPanel;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.TargetData;

public class MakefileIncludesPanel
extends EnterItemsPanel {
    static final long serialVersionUID = -3932940292545539665L;
    private int key;
    private boolean initialized;

    MakefileIncludesPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = new String(this.getString("LBL_MakefileIncludesPanel"));
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    private void create() {
        this.create(this.getString("LBL_IncDir"), this.getString("MNEM_IncDir").charAt(0), 10);
    }

    protected String getListLabel() {
        return this.getString("LBL_IncludesList");
    }

    protected char getListMnemonic() {
        return this.getString("MNEM_IncludesList").charAt(0);
    }

    public void validateData(ArrayList arrayList, int n) {
        TargetData targetData = this.getMakefileData().getTarget(n);
        String[] stringArray = targetData.getIncludesList();
        if (stringArray == null) {
            this.warn(arrayList, WARN_NO_INC_DIRS, targetData.getName());
        } else {
            int n2;
            String string = this.getMakefileData().getBaseDirectory(true);
            ArrayList<StringBuffer> arrayList2 = new ArrayList<StringBuffer>();
            ArrayList<StringBuffer> arrayList3 = new ArrayList<StringBuffer>();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String string2 = stringArray[n2].toString();
                File file = string2.startsWith(File.separator) ? new File(string2) : new File(string, string2);
                if (file == null) continue;
                if (!file.exists()) {
                    arrayList2.add(new StringBuffer("\t").append(file.getPath()).append("\n"));
                    continue;
                }
                if (file.isDirectory()) continue;
                arrayList3.add(new StringBuffer("\t").append(file.getPath()).append("\n"));
            }
            if (arrayList2.size() > 0) {
                if (arrayList2.size() < 5) {
                    this.warn(arrayList, WARN_DNE_INCDIR, targetData.getName());
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        arrayList.add(arrayList2.get(n2));
                    }
                    arrayList.add(new String("\n"));
                } else {
                    this.warn(arrayList, WARN_DNE_COUNT, targetData.getName(), new Integer(arrayList2.size()).toString());
                }
            }
            if (arrayList3.size() > 0) {
                if (arrayList3.size() < 5) {
                    this.warn(arrayList, WARN_INC_NOT_DIR, targetData.getName());
                    for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                        arrayList.add(arrayList3.get(n2));
                    }
                    arrayList.add(new String("\n"));
                } else {
                    this.warn(arrayList, WARN_INC_NOT_DIR_COUNT, targetData.getName(), new Integer(arrayList3.size()).toString());
                }
            }
        }
    }

    protected EnterItemsPanel.ErrorInfo getErrorInfo() {
        return new EnterItemsPanel.ErrorInfo(this.getString("DLG_MIP_EmptyRE"), this.getString("MSG_NoFilesMatched"));
    }

    protected String validateInput(String string) {
        if (string.startsWith("-I")) {
            return string.substring(2);
        }
        if (string.charAt(0) == '-') {
            return null;
        }
        return string;
    }

    public void addNotify() {
        TargetData targetData = this.getMakefileData().getCurrentTarget();
        this.key = targetData.getKey();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.getList().getModel();
        defaultListModel.removeAllElements();
        String[] stringArray = targetData.getIncludesList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                defaultListModel.addElement(stringArray[i]);
            }
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        TargetData targetData = this.getMakefileData().getTarget(this.key);
        targetData.setIncludesList(this.getListItems());
    }
}

