/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.IOException;
import java.util.Collection;
import org.netbeans.modules.cnd.loaders.CndAbstractDataLoaderExt;
import org.netbeans.modules.cnd.loaders.HDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HDataLoader
extends CndAbstractDataLoaderExt {
    private static HDataLoader instance = null;
    static final long serialVersionUID = -2924582006340980748L;
    private static final String[] hdrExtensions = new String[]{"h", "H", "hpp", "hxx", "SUNWCCh", "tcc"};

    public HDataLoader() {
        super("org.netbeans.modules.cnd.loaders.HDataObject");
        instance = this;
        this.createExtentions(hdrExtensions);
    }

    public static HDataLoader getInstance() {
        if (instance == null) {
            instance = (HDataLoader)SharedClassObject.findObject(HDataLoader.class, (boolean)true);
        }
        return instance;
    }

    public void addExtensions(Collection<String> collection) {
        ExtensionList extensionList = this.getExtensions();
        ExtensionList extensionList2 = (ExtensionList)extensionList.clone();
        for (String string : collection) {
            extensionList2.addExtension(string);
        }
        this.setExtensions(extensionList2);
    }

    @Override
    protected String getMimeType() {
        return "text/x-c++";
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(HDataLoader.class, (String)"PROP_HDataLoader_Name");
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        String string = fileObject.getMIMEType();
        if ("text/x-c++".equals(string)) {
            return fileObject;
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new HDataObject(fileObject, this);
    }

    @Override
    public ExtensionList getDefaultExtensionList() {
        return HDataLoader.arrayToExtensionList(hdrExtensions);
    }

    @Override
    public String getDisplayNameForExtensionList() {
        return NbBundle.getMessage(HDataLoader.class, (String)"HDataLoader_Name_ForExtList");
    }

    @Override
    public String getDefaultDefaultExtension() {
        return hdrExtensions[0];
    }
}

