/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.IOException;
import java.util.Set;
import org.netbeans.modules.cnd.execution.BinaryExecSupport;
import org.netbeans.modules.cnd.loaders.CppEditorSupport;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class CndDataObject
extends MultiDataObject {
    static final long serialVersionUID = -6788084224129713370L;
    private CppEditorSupport cppEditorSupport;
    private BinaryExecSupport binaryExecSupport;

    public CndDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.init();
    }

    protected void init() {
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add(CppEditorSupport.class, new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
                return (T)((Node.Cookie)clazz.cast((Object)CndDataObject.this.createCppEditorSupport()));
            }
        });
        cookieSet.add(BinaryExecSupport.class, new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
                return (T)((Node.Cookie)clazz.cast(CndDataObject.this.createBinaryExecSupport()));
            }
        });
    }

    private synchronized CppEditorSupport createCppEditorSupport() {
        if (this.cppEditorSupport == null) {
            this.cppEditorSupport = new CppEditorSupport((DataObject)this.getPrimaryEntry().getDataObject());
        }
        return this.cppEditorSupport;
    }

    private synchronized BinaryExecSupport createBinaryExecSupport() {
        if (this.binaryExecSupport == null) {
            this.binaryExecSupport = new BinaryExecSupport(this.getPrimaryEntry());
        }
        return this.binaryExecSupport;
    }

    public final Set getDeleteList() {
        return this.secondaryEntries();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
    }

    void removeSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().remove((Node.Cookie)saveCookie);
    }

    public void addCookie(Node.Cookie cookie) {
        this.getCookieSet().add(cookie);
    }

    public void removeCookie(Node.Cookie cookie) {
        this.getCookieSet().remove(cookie);
    }

    protected abstract Node createNodeDelegate();

    public final void removeSecondaryEntryAccess(MultiDataObject.Entry entry) {
        this.removeSecondaryEntry(entry);
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string != null && !CndDataObject.isValidName(string)) {
            throw new IOException(NbBundle.getMessage(CndDataObject.class, (String)"FMT_Not_Valid_FileName", (Object)string));
        }
        return super.handleCreateFromTemplate(dataFolder, string);
    }

    static boolean isValidName(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isISOControl(c)) continue;
            return false;
        }
        return true;
    }
}

