/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.File;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.MapFormat;

public abstract class CndAbstractDataLoader
extends UniFileLoader {
    static final long serialVersionUID = 6801389470714975682L;

    protected CndAbstractDataLoader(String string) {
        super(string);
    }

    protected void createExtentions(String[] stringArray) {
        ExtensionList extensionList = new ExtensionList();
        for (int i = 0; i < stringArray.length; ++i) {
            extensionList.addExtension(stringArray[i]);
        }
        this.setExtensions(extensionList);
    }

    protected abstract String getMimeType();

    protected void initialize() {
        super.initialize();
    }

    protected String actionsContext() {
        return "Loaders/text/x-cnd-sourcefile/Actions/";
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new CndFormat(multiDataObject, fileObject);
    }

    static class CndFormat
    extends FileEntry.Format {
        public CndFormat(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        protected Format createFormat(FileObject fileObject, String string, String string2) {
            int n;
            Properties properties = ((CppSettings)CppSettings.findObject(CppSettings.class, (boolean)true)).getReplaceableStringsProps();
            String string3 = fileObject.getPath().replace('/', '_');
            if (!string3.equals("")) {
                string3 = string3 + "_";
            }
            properties.put("PACKAGE_AND_NAME", string3 + string);
            properties.put("NAME", string);
            properties.put("EXTENSION", string2);
            String string4 = string + "_" + string2;
            String string5 = "";
            for (n = 0; n < string4.length(); ++n) {
                char c = string4.charAt(n);
                string5 = string5 + (Character.isJavaIdentifierPart(c) ? c : (char)'_');
            }
            properties.put("GUARD_NAME", string5.toUpperCase());
            n = string.lastIndexOf(95);
            if (n != -1) {
                string = string.substring(0, n);
            }
            properties.put("CROPPEDNAME", string);
            properties.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
            properties.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
            String string6 = null;
            File file = InstalledFileLocator.getDefault().locate("lib", null, false);
            if (file != null) {
                string6 = file.getParent();
            }
            if (string6 == null) {
                string6 = "";
            }
            properties.put("NBDIR", string6);
            properties.put("QUOTES", "\"");
            MapFormat mapFormat = new MapFormat((Map)properties);
            mapFormat.setLeftBrace("%<%");
            mapFormat.setRightBrace("%>%");
            return mapFormat;
        }
    }
}

