/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.makefile;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.cnd.editor.makefile.MakefileFormatSupport;
import org.netbeans.modules.cnd.editor.makefile.MakefileSyntax;

public class MakefileFormatter
extends ExtFormatter {
    public MakefileFormatter(Class clazz) {
        super(clazz);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof MakefileSyntax;
    }

    public boolean expandTabs() {
        return false;
    }

    public String getIndentString(BaseDocument baseDocument, int n) {
        JTextComponent jTextComponent = Utilities.getFocusedComponent();
        int n2 = jTextComponent.getCaret().getDot();
        try {
            int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2);
            if (n2 == n3) {
                return "\t";
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return super.getIndentString(baseDocument, n);
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new MakefileLayer());
    }

    public FormatSupport createFormatSupport(FormatWriter formatWriter) {
        return new MakefileFormatSupport(formatWriter);
    }

    public class MakefileLayer
    extends AbstractFormatLayer {
        public MakefileLayer() {
            super("Makefile-layer");
        }

        public FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new MakefileFormatSupport(formatWriter);
        }

        public void format(FormatWriter formatWriter) {
            MakefileFormatSupport makefileFormatSupport = (MakefileFormatSupport)this.createFormatSupport(formatWriter);
            FormatTokenPosition formatTokenPosition = makefileFormatSupport.getFormatStartPosition();
            TokenItem tokenItem = makefileFormatSupport.getLastToken();
            if (makefileFormatSupport.isIndentOnly()) {
                makefileFormatSupport.indentLine(formatTokenPosition);
            }
        }

        protected boolean expandTabs() {
            return false;
        }
    }
}

