/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.cnd.editor.filecreation.ExtensionsSettings;
import org.netbeans.modules.cnd.editor.filecreation.NewCndFileChooserPanelGUI;
import org.netbeans.modules.cnd.ui.options.CndOptionsPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NewCndFileChooserPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private NewCndFileChooserPanelGUI gui;
    private final Project project;
    private final SourceGroup[] folders;
    private final WizardDescriptor.Panel<WizardDescriptor> bottomPanel;
    private WizardDescriptor wizard;
    private final ExtensionsSettings es;

    NewCndFileChooserPanel(Project project, SourceGroup[] sourceGroupArray, WizardDescriptor.Panel<WizardDescriptor> panel, ExtensionsSettings extensionsSettings) {
        this.es = extensionsSettings;
        this.folders = sourceGroupArray;
        this.project = project;
        this.bottomPanel = panel;
        if (panel != null) {
            panel.addChangeListener((ChangeListener)this);
        }
        this.gui = null;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new NewCndFileChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.es);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        HelpCtx helpCtx;
        if (this.bottomPanel != null && (helpCtx = this.bottomPanel.getHelp()) != null) {
            return helpCtx;
        }
        return null;
    }

    public boolean isValid() {
        boolean bl;
        boolean bl2 = bl = this.gui != null && this.gui.getTargetName() != null && (this.bottomPanel == null || this.bottomPanel.isValid()) && this.gui.getTargetExtension().length() > 0;
        if (!bl) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)"");
            return false;
        }
        String string = NewCndFileChooserPanel.canUseFileName(this.gui.getTargetGroup().getRootFolder(), this.gui.getTargetFolder(), this.gui.getTargetName(), false);
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
        if (!this.es.isKnownExtension(this.gui.getTargetExtension())) {
            String string2 = NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_new_extension_introduced", (Object)this.gui.getTargetExtension());
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)string2);
        }
        return string == null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        if (this.gui == null) {
            this.getComponent();
        }
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        String string = Templates.getTargetName((WizardDescriptor)this.wizard);
        this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), fileObject, string);
        Object object = this.gui.getClientProperty("NewFileWizard_Title");
        if (object != null) {
            this.wizard.putProperty("NewFileWizard_Title", object);
        }
        this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle(NewCndFileChooserPanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle(NewCndFileChooserPanel.class).getString("LBL_SimpleTargetChooserPanel_Name")});
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings((Object)wizardDescriptor);
        }
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(wizardDescriptor.getValue())) {
            return;
        }
        if (!wizardDescriptor.getValue().equals(WizardDescriptor.CANCEL_OPTION) && this.isValid()) {
            String string;
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings((Object)wizardDescriptor);
            }
            if ((string = this.gui.getTargetName()).indexOf(47) > 0) {
                string = string.substring(string.lastIndexOf(47) + 1);
            }
            FileObject fileObject = this.getTargetFolderFromGUI();
            try {
                Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)fileObject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 4096, null, NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_Cannot_Create_Folder", (Object)this.gui.getTargetFolder()), null, null);
                throw illegalArgumentException;
            }
            Templates.setTargetName((WizardDescriptor)wizardDescriptor, (String)string);
            this.es.setDefaultExtension(this.gui.getTargetExtension());
        }
        wizardDescriptor.putProperty("NewFileWizard_Title", null);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.changeSupport.fireChange();
    }

    private FileObject getTargetFolderFromGUI() {
        Object object;
        FileObject fileObject = this.gui.getTargetGroup().getRootFolder();
        String string = this.gui.getTargetFolder();
        String string2 = this.gui.getTargetName();
        if (string2.indexOf(47) > 0) {
            object = string2.substring(0, string2.lastIndexOf(47));
            string = string == null || "".equals(string) ? object : string + '/' + (String)object;
        }
        if ((object = string == null ? fileObject : fileObject.getFileObject(string)) == null) {
            try {
                object = FileUtil.createFolder((FileObject)fileObject, (String)string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return object;
    }

    public static final String canUseFileName(FileObject fileObject, String string, String string2, boolean bl) {
        String string3 = string + "/" + string2;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        if (bl) {
            if (File.separatorChar == '\\') {
                n = 3;
                bl3 = true;
                bl2 = true;
            } else {
                n = 1;
                bl2 = true;
            }
        }
        if (!bl2 && string2.indexOf(47) != -1 || !bl3 && string2.indexOf(92) != -1) {
            assert (n == 0 || n == 1) : "Invalid error variant: " + n;
            return NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_not_valid_filename", (Object)string2, (Object)new Integer(n));
        }
        if (!NewCndFileChooserPanel.isValidName(string2)) {
            return NbBundle.getMessage(CndOptionsPanel.class, (String)"NAME_INVALID", (Object)string2);
        }
        if (fileObject == null) {
            return NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!fileObject.canWrite()) {
            return NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (NewCndFileChooserPanel.existFileName(fileObject, string3)) {
            return NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_file_already_exist", (Object)string2);
        }
        return null;
    }

    private static boolean existFileName(FileObject fileObject, String string) {
        boolean bl = false;
        File file = FileUtil.toFile((FileObject)fileObject);
        bl = file.exists() ? new File(file, string).exists() : fileObject.getFileObject(string) != null;
        return bl;
    }

    private static boolean isValidName(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isISOControl(c) && !(c == '\"' | c == '$') && c != '#' && c != '\'') continue;
            return false;
        }
        return true;
    }
}

