/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.editor.filecreation.CndExtensionList;
import org.netbeans.modules.cnd.editor.filecreation.CndHandlableExtensions;
import org.openide.util.NbPreferences;

public class ExtensionsSettings {
    private final String name;
    private CndExtensionList savedExtensionsList;
    private static final Map<String, ExtensionsSettings> settingsAccessors = new HashMap<String, ExtensionsSettings>();
    private static final Preferences preferences = NbPreferences.forModule(ExtensionsSettings.class);
    private final String DEFAULT_EXTENSION_PREFIX;
    private static final String EXTENSIONS_LIST_PREFIX = "ext-list-";
    private static final String DELIMITER = ",";

    private ExtensionsSettings(String string, CndHandlableExtensions cndHandlableExtensions) {
        this.name = string;
        this.DEFAULT_EXTENSION_PREFIX = "def-ext-";
        String string2 = preferences.get(EXTENSIONS_LIST_PREFIX + string, null);
        this.savedExtensionsList = string2 == null ? (CndExtensionList)cndHandlableExtensions.getDefaultExtensionList() : new CndExtensionList(string2.split(DELIMITER));
        assert (this.savedExtensionsList.extensions().hasMoreElements());
        String string3 = cndHandlableExtensions.getDefaultDefaultExtension();
        assert (this.savedExtensionsList.isRegistered(string3));
        this.setDefaultExtension(string3, false);
    }

    private ExtensionsSettings(ExtensionsSettings extensionsSettings, String string) {
        this.DEFAULT_EXTENSION_PREFIX = string;
        this.name = extensionsSettings.name;
        this.savedExtensionsList = extensionsSettings.savedExtensionsList;
        String string2 = this.getDefaultExtension(extensionsSettings.getDefaultExtension());
        this.setDefaultExtension(this.isKnownExtension(string2) ? string2 : extensionsSettings.getDefaultExtension());
    }

    public static synchronized ExtensionsSettings getInstance(CndHandlableExtensions cndHandlableExtensions) {
        String string = cndHandlableExtensions.getSettingsName();
        ExtensionsSettings extensionsSettings = settingsAccessors.get(string);
        if (extensionsSettings == null) {
            extensionsSettings = new ExtensionsSettings(string, cndHandlableExtensions);
            settingsAccessors.put(string, extensionsSettings);
        }
        return extensionsSettings;
    }

    public String getDefaultExtension() {
        String string = this.getDefaultExtension("");
        assert (string.length() > 0);
        return string;
    }

    private String getDefaultExtension(String string) {
        return preferences.get(this.DEFAULT_EXTENSION_PREFIX + this.name, string);
    }

    public synchronized void setDefaultExtension(String string) {
        this.setDefaultExtension(string, true);
    }

    private void setDefaultExtension(String string, boolean bl) {
        if (bl && !this.isKnownExtension(string)) {
            this.getExtensionList().addExtension(string);
        }
        preferences.put(this.DEFAULT_EXTENSION_PREFIX + this.name, string);
    }

    public synchronized CndExtensionList getExtensionList() {
        return this.savedExtensionsList;
    }

    public synchronized void setExtensionList(CndExtensionList cndExtensionList) {
        String string = "";
        Enumeration<String> enumeration = cndExtensionList.extensions();
        assert (enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            if (string.length() > 0) {
                string = string + DELIMITER;
            }
            string = string + enumeration.nextElement();
        }
        this.savedExtensionsList = cndExtensionList;
        if (!this.isKnownExtension(this.getDefaultExtension())) {
            this.setDefaultExtension(this.savedExtensionsList.extensions().nextElement(), false);
        }
        preferences.put(EXTENSIONS_LIST_PREFIX + this.name, string);
    }

    public boolean isKnownExtension(String string) {
        if (string == null) {
            return false;
        }
        return this.getExtensionList().isRegistered(string);
    }

    ExtensionsSettings getSpecializedInstance(String string) {
        return new ExtensionsSettings(this, string);
    }
}

