/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.xml;

import java.util.HashMap;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.xml.sax.Attributes;

public abstract class XMLDecoder {
    private HashMap tagMap = new HashMap();
    private XMLDecoder currentDecoder;
    private String currentElement;

    protected abstract String tag();

    protected abstract void start(Attributes var1) throws VersionException;

    protected abstract void end();

    protected abstract void startElement(String var1, Attributes var2);

    protected abstract void endElement(String var1, String var2);

    protected void registerXMLDecoder(XMLDecoder xMLDecoder) {
        this.tagMap.put(xMLDecoder.tag(), xMLDecoder);
    }

    protected void deregisterXMLDecoder(XMLDecoder xMLDecoder) {
        this.tagMap.remove(xMLDecoder.tag());
    }

    void _startElement(String string, Attributes attributes) throws VersionException {
        if (this.checkStartRecursion(string, attributes)) {
            return;
        }
        this.startElement(string, attributes);
    }

    void _endElement(String string, String string2) {
        if (this.checkEndRecursion(string, string2)) {
            return;
        }
        this.endElement(string, string2);
    }

    private boolean checkStartRecursion(String string, Attributes attributes) throws VersionException {
        if (this.currentDecoder != null) {
            this.currentDecoder._startElement(string, attributes);
            return true;
        }
        XMLDecoder xMLDecoder = (XMLDecoder)this.tagMap.get(string);
        if (xMLDecoder != null) {
            xMLDecoder.start(attributes);
            this.currentDecoder = xMLDecoder;
            this.currentElement = string;
            return true;
        }
        return false;
    }

    private boolean checkEndRecursion(String string, String string2) {
        if (this.currentDecoder != null) {
            if (this.currentDecoder.checkEndRecursion(string, string2)) {
                return true;
            }
            if (string.equals(this.currentElement)) {
                this.currentDecoder.end();
                this.currentDecoder = null;
                this.currentElement = null;
                return true;
            }
            this.currentDecoder.endElement(string, string2);
            return true;
        }
        return false;
    }

    private void registerXMLDecoder(String string, XMLDecoder xMLDecoder) {
        this.tagMap.put(string, xMLDecoder);
    }

    protected void checkVersion(Attributes attributes, String string, int n) throws VersionException {
        int n2 = 0;
        String string2 = attributes.getValue("version");
        if (string2 != null) {
            n2 = new Integer(string2);
        }
        if (n2 > n) {
            throw new VersionException(string, n, n2);
        }
    }
}

