/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class CloseWindowAction
extends AbstractAction
implements PropertyChangeListener {
    private TopComponent tc;

    public CloseWindowAction() {
        this.putValue("Name", NbBundle.getMessage(CloseWindowAction.class, (String)"CTL_CloseWindowAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    public CloseWindowAction(TopComponent topComponent) {
        this.tc = topComponent;
        this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_CloseWindowAction"));
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent = this.tc;
        if (topComponent == null) {
            topComponent = TopComponent.getRegistry().getActivated();
        }
        if (topComponent != null) {
            ActionUtils.closeWindow(topComponent);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        this.setEnabled(TopComponent.getRegistry().getActivated() != null);
    }

    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("CloseWindow", object);
        } else {
            super.putValue(string, object);
        }
    }

    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("CloseWindow");
        }
        return super.getValue(string);
    }
}

