/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.repository.util.LongHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlicedLongHashMap<K> {
    private final LongHashMap<K>[] instances;
    private int sliceNumber;

    public SlicedLongHashMap(int n, int n2) {
        this.sliceNumber = n;
        this.instances = new LongHashMap[n];
        for (int i = 0; i < n; ++i) {
            this.instances[i] = new LongHashMap(n2);
        }
    }

    private LongHashMap<K> getDelegate(K k) {
        int n = k.hashCode() % this.sliceNumber;
        if (n < 0) {
            n += this.sliceNumber;
        }
        return this.instances[n];
    }

    public long put(K k, long l) {
        return this.getDelegate(k).put(k, l);
    }

    public long get(K k) {
        return this.getDelegate(k).get(k);
    }

    public long remove(K k) {
        return this.getDelegate(k).remove(k);
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.sliceNumber; ++i) {
            n += this.instances[i].size();
        }
        return n;
    }

    public Collection<K> keySet() {
        ArrayList<K> arrayList = new ArrayList<K>(this.size());
        for (int i = 0; i < this.sliceNumber; ++i) {
            arrayList.addAll(this.instances[i].keySet());
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection<LongHashMap.Entry<K>> entrySet() {
        ArrayList<LongHashMap.Entry<K>> arrayList = new ArrayList<LongHashMap.Entry<K>>(this.size());
        for (int i = 0; i < this.sliceNumber; ++i) {
            arrayList.addAll(this.instances[i].entrySet());
        }
        return Collections.unmodifiableCollection(arrayList);
    }
}

