/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadsCache
implements Executor {
    public static final String PROP_THREAD_STARTED = "threadStarted";
    public static final String PROP_THREAD_DIED = "threadDied";
    public static final String PROP_GROUP_ADDED = "groupAdded";
    private VirtualMachine vm;
    private JPDADebuggerImpl debugger;
    private Map<ThreadGroupReference, List<ThreadGroupReference>> groupMap;
    private Map<ThreadGroupReference, List<ThreadReference>> threadMap;
    private List<ThreadReference> allThreads;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ThreadsCache(JPDADebuggerImpl jPDADebuggerImpl) {
        this.debugger = jPDADebuggerImpl;
        this.groupMap = new HashMap<ThreadGroupReference, List<ThreadGroupReference>>();
        this.threadMap = new HashMap<ThreadGroupReference, List<ThreadReference>>();
        this.allThreads = new ArrayList<ThreadReference>();
        VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
        if (virtualMachine != null) {
            this.setVirtualMachine(virtualMachine);
        }
    }

    public synchronized void setVirtualMachine(VirtualMachine virtualMachine) {
        if (this.vm == virtualMachine) {
            return;
        }
        this.vm = virtualMachine;
        ThreadStartRequest threadStartRequest = virtualMachine.eventRequestManager().createThreadStartRequest();
        ThreadDeathRequest threadDeathRequest = virtualMachine.eventRequestManager().createThreadDeathRequest();
        threadStartRequest.setSuspendPolicy(0);
        threadDeathRequest.setSuspendPolicy(0);
        this.debugger.getOperator().register(threadStartRequest, this);
        this.debugger.getOperator().register(threadDeathRequest, this);
        threadStartRequest.enable();
        threadDeathRequest.enable();
        this.init();
    }

    private synchronized void init() {
        this.allThreads = new ArrayList<ThreadReference>(this.vm.allThreads());
        ArrayList<ThreadGroupReference> arrayList = new ArrayList<ThreadGroupReference>(this.vm.topLevelThreadGroups());
        this.groupMap.put(null, arrayList);
        for (ThreadGroupReference object : arrayList) {
            this.initGroups(object);
        }
        ArrayList arrayList2 = new ArrayList();
        this.threadMap.put(null, arrayList2);
        for (ThreadReference threadReference : this.allThreads) {
            if (threadReference.threadGroup() != null) continue;
            arrayList2.add(threadReference);
        }
    }

    private void initGroups(ThreadGroupReference threadGroupReference) {
        ArrayList<ThreadGroupReference> arrayList = new ArrayList<ThreadGroupReference>(threadGroupReference.threadGroups());
        ArrayList<ThreadReference> arrayList2 = new ArrayList<ThreadReference>(threadGroupReference.threads());
        this.groupMap.put(threadGroupReference, arrayList);
        this.threadMap.put(threadGroupReference, arrayList2);
        for (ThreadGroupReference threadGroupReference2 : arrayList) {
            this.initGroups(threadGroupReference2);
        }
    }

    public synchronized List<ThreadReference> getAllThreads() {
        return Collections.unmodifiableList(new ArrayList<ThreadReference>(this.allThreads));
    }

    public synchronized List<ThreadGroupReference> getTopLevelThreadGroups() {
        List<ThreadGroupReference> list = this.groupMap.get(null);
        if (list == null) {
            if (this.vm == null) {
                return Collections.EMPTY_LIST;
            }
            list = new ArrayList<ThreadGroupReference>(this.vm.topLevelThreadGroups());
            this.groupMap.put(null, list);
        }
        return Collections.unmodifiableList(new ArrayList<ThreadGroupReference>(list));
    }

    public synchronized List<ThreadReference> getThreads(ThreadGroupReference threadGroupReference) {
        List<ThreadReference> list = this.threadMap.get(threadGroupReference);
        list = list == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ThreadReference>(list));
        return list;
    }

    public synchronized List<ThreadGroupReference> getGroups(ThreadGroupReference threadGroupReference) {
        List<ThreadGroupReference> list = this.groupMap.get(threadGroupReference);
        list = list == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ThreadGroupReference>(list));
        return list;
    }

    private List<ThreadGroupReference> addGroups(ThreadGroupReference threadGroupReference) {
        List<ThreadGroupReference> list;
        ArrayList<ThreadGroupReference> arrayList = new ArrayList<ThreadGroupReference>();
        ThreadGroupReference threadGroupReference2 = threadGroupReference.parent();
        if (this.groupMap.get(threadGroupReference2) == null) {
            arrayList.addAll(this.addGroups(threadGroupReference2));
        }
        if (!(list = this.groupMap.get(threadGroupReference2)).contains(threadGroupReference)) {
            list.add(threadGroupReference);
            arrayList.add(threadGroupReference);
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            this.groupMap.put(threadGroupReference, arrayList2);
            this.threadMap.put(threadGroupReference, arrayList3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exec(Event event) {
        Iterator iterator;
        Object object;
        ThreadGroupReference threadGroupReference;
        ThreadReference threadReference;
        if (event instanceof ThreadStartEvent) {
            Object object2;
            threadReference = ((ThreadStartEvent)event).thread();
            threadGroupReference = threadReference.threadGroup();
            object = null;
            iterator = this;
            synchronized (iterator) {
                if (threadGroupReference != null) {
                    object = this.addGroups(threadGroupReference);
                }
                if (!(object2 = this.threadMap.get(threadGroupReference)).contains(threadReference)) {
                    object2.add((ThreadReference)threadReference);
                }
                if (!this.allThreads.contains(threadReference)) {
                    this.allThreads.add(threadReference);
                }
            }
            if (object != null) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object2 = (ThreadGroupReference)iterator.next();
                    this.pcs.firePropertyChange(PROP_GROUP_ADDED, null, object2);
                }
            }
            this.pcs.firePropertyChange(PROP_THREAD_STARTED, null, threadReference);
        }
        if (event instanceof ThreadDeathEvent) {
            threadReference = ((ThreadDeathEvent)event).thread();
            threadGroupReference = threadReference.threadGroup();
            object = this;
            synchronized (object) {
                iterator = this.threadMap.get(threadGroupReference);
                if (iterator != null) {
                    iterator.remove(threadReference);
                }
                this.allThreads.remove(threadReference);
            }
            this.pcs.firePropertyChange(PROP_THREAD_DIED, threadReference, null);
        }
        return true;
    }

    @Override
    public void removed(EventRequest eventRequest) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }
}

