/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;

class ObjectFieldVariable
extends AbstractObjectVariable
implements org.netbeans.api.debugger.jpda.Field {
    protected Field field;
    private ObjectReference objectReference;
    private String genericSignature;

    ObjectFieldVariable(JPDADebuggerImpl jPDADebuggerImpl, ObjectReference objectReference, Field field, String string, ObjectReference objectReference2) {
        super(jPDADebuggerImpl, objectReference, string + '.' + field.name() + "^");
        this.field = field;
        this.objectReference = objectReference2;
    }

    ObjectFieldVariable(JPDADebuggerImpl jPDADebuggerImpl, ObjectReference objectReference, Field field, String string, String string2, ObjectReference objectReference2) {
        this(jPDADebuggerImpl, objectReference, field, string, objectReference2);
        this.genericSignature = string2;
    }

    public String getName() {
        return this.field.name();
    }

    public String getClassName() {
        return this.field.declaringType().name();
    }

    public JPDAClassType getDeclaringClass() {
        return new JPDAClassTypeImpl(this.getDebugger(), (ReferenceType)this.objectReference.type());
    }

    public String getDeclaredType() {
        return this.field.typeName();
    }

    public JPDAClassType getClassType() {
        Value value = this.getInnerValue();
        if (value != null) {
            return super.getClassType();
        }
        try {
            Type type = this.field.type();
            if (type instanceof ReferenceType) {
                return new JPDAClassTypeImpl(this.getDebugger(), (ReferenceType)type);
            }
            return null;
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            return null;
        }
    }

    public boolean isStatic() {
        return this.field.isStatic();
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            boolean bl = false;
            if (this.objectReference != null) {
                this.objectReference.setValue(this.field, value);
                bl = true;
            } else {
                ReferenceType referenceType = this.field.declaringType();
                if (referenceType instanceof ClassType) {
                    ClassType classType = (ClassType)referenceType;
                    classType.setValue(this.field, value);
                    bl = true;
                }
            }
            if (!bl) {
                throw new InvalidExpressionException(this.field.toString());
            }
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
    }

    public ObjectFieldVariable clone() {
        return new ObjectFieldVariable(this.getDebugger(), (ObjectReference)this.getJDIValue(), this.field, this.getID().substring(0, this.getID().length() - ("." + this.field.name() + (this.getJDIValue() instanceof ObjectReference ? "^" : "")).length()), this.genericSignature, this.objectReference);
    }

    public String toString() {
        return "ObjectFieldVariable " + this.field.name();
    }
}

