/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ThreadsCache;

public class JPDAThreadGroupImpl
implements JPDAThreadGroup {
    private ThreadGroupReference tgr;
    private JPDADebuggerImpl debugger;

    public JPDAThreadGroupImpl(ThreadGroupReference threadGroupReference, JPDADebuggerImpl jPDADebuggerImpl) {
        this.tgr = threadGroupReference;
        this.debugger = jPDADebuggerImpl;
    }

    public JPDAThreadGroup getParentThreadGroup() {
        ThreadGroupReference threadGroupReference = this.tgr.parent();
        if (threadGroupReference == null) {
            return null;
        }
        return this.debugger.getThreadGroup(threadGroupReference);
    }

    public JPDAThread[] getThreads() {
        ThreadsCache threadsCache = this.debugger.getThreadsCache();
        if (threadsCache == null) {
            return new JPDAThread[0];
        }
        List<ThreadReference> list = threadsCache.getThreads(this.tgr);
        int n = list.size();
        JPDAThread[] jPDAThreadArray = new JPDAThread[n];
        for (int i = 0; i < n; ++i) {
            jPDAThreadArray[i] = this.debugger.getThread(list.get(i));
        }
        return jPDAThreadArray;
    }

    public JPDAThreadGroup[] getThreadGroups() {
        ThreadsCache threadsCache = this.debugger.getThreadsCache();
        if (threadsCache == null) {
            return new JPDAThreadGroup[0];
        }
        List<ThreadGroupReference> list = threadsCache.getGroups(this.tgr);
        int n = list.size();
        JPDAThreadGroup[] jPDAThreadGroupArray = new JPDAThreadGroup[n];
        for (int i = 0; i < n; ++i) {
            jPDAThreadGroupArray[i] = this.debugger.getThreadGroup(list.get(i));
        }
        return jPDAThreadGroupArray;
    }

    public String getName() {
        return this.tgr.name();
    }

    public void resume() {
        ThreadsCache threadsCache = this.debugger.getThreadsCache();
        if (threadsCache == null) {
            return;
        }
        List<ThreadReference> list = threadsCache.getThreads(this.tgr);
        Iterator<ThreadReference> iterator = list.iterator();
        while (iterator.hasNext()) {
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.debugger.getThread(iterator.next());
            jPDAThreadImpl.notifyToBeResumed();
        }
        this.tgr.resume();
    }

    public void suspend() {
        ThreadsCache threadsCache = this.debugger.getThreadsCache();
        if (threadsCache == null) {
            return;
        }
        this.tgr.suspend();
        List<ThreadReference> list = threadsCache.getThreads(this.tgr);
        Iterator<ThreadReference> iterator = list.iterator();
        while (iterator.hasNext()) {
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.debugger.getThread(iterator.next());
            jPDAThreadImpl.notifySuspended();
        }
    }
}

