/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;

class FieldVariable
extends AbstractVariable
implements org.netbeans.api.debugger.jpda.Field {
    protected Field field;
    private ObjectReference objectReference;

    FieldVariable(JPDADebuggerImpl jPDADebuggerImpl, PrimitiveValue primitiveValue, Field field, String string, ObjectReference objectReference) {
        super(jPDADebuggerImpl, primitiveValue, string + '.' + field.name());
        this.field = field;
        this.objectReference = objectReference;
    }

    public String getName() {
        return this.field.name();
    }

    public String getClassName() {
        return this.field.declaringType().name();
    }

    public JPDAClassType getDeclaringClass() {
        return new JPDAClassTypeImpl(this.getDebugger(), (ReferenceType)this.objectReference.type());
    }

    public String getDeclaredType() {
        return this.field.typeName();
    }

    public boolean isStatic() {
        return this.field.isStatic();
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            boolean bl = false;
            if (this.objectReference != null) {
                this.objectReference.setValue(this.field, value);
                bl = true;
            } else {
                ReferenceType referenceType = this.field.declaringType();
                if (referenceType instanceof ClassType) {
                    ClassType classType = (ClassType)referenceType;
                    classType.setValue(this.field, value);
                    bl = true;
                }
            }
            if (!bl) {
                throw new InvalidExpressionException(this.field.toString());
            }
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
    }

    public FieldVariable clone() {
        FieldVariable fieldVariable = new FieldVariable(this.getDebugger(), (PrimitiveValue)this.getJDIValue(), this.field, this.getID().substring(0, this.getID().length() - ("." + this.field.name() + (this.getJDIValue() instanceof ObjectReference ? "^" : "")).length()), this.objectReference);
        return fieldVariable;
    }

    public String toString() {
        return "FieldVariable " + this.field.name();
    }
}

