/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.ArgumentObjectVariable;
import org.netbeans.modules.debugger.jpda.models.ArgumentVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallStackFrameImpl
implements CallStackFrame {
    private static final boolean IS_JDK_16 = !System.getProperty("java.version").startsWith("1.5");
    static final boolean IS_JDK_160_02 = IS_JDK_16 && !System.getProperty("java.version").equals("1.6.0") && !System.getProperty("java.version").equals("1.6.0_01");
    private StackFrame sf;
    private int depth;
    private JPDADebuggerImpl debugger;
    private EditorContext.Operation currentOperation;
    private boolean valid;
    private Integer hashCode;

    public CallStackFrameImpl(StackFrame stackFrame, int n, JPDADebuggerImpl jPDADebuggerImpl) {
        this.sf = stackFrame;
        this.depth = n;
        this.debugger = jPDADebuggerImpl;
        this.valid = true;
    }

    public synchronized int getLineNumber(String string) {
        if (!this.valid) {
            return 0;
        }
        try {
            return this.getStackFrame().location().lineNumber(string);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return 0;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return 0;
        }
    }

    public synchronized EditorContext.Operation getCurrentOperation(String string) {
        return this.currentOperation;
    }

    public synchronized void setCurrentOperation(EditorContext.Operation operation) {
        this.currentOperation = operation;
    }

    public synchronized String getMethodName() {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().method().name();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return "";
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return "";
        }
    }

    public synchronized String getClassName() {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().declaringType().name();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return "";
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return "";
        }
    }

    public synchronized String getDefaultStratum() {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().declaringType().defaultStratum();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return "";
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return "";
        }
    }

    public synchronized List<String> getAvailableStrata() {
        if (!this.valid) {
            return Collections.emptyList();
        }
        try {
            return this.getStackFrame().location().declaringType().availableStrata();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return Collections.emptyList();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return Collections.emptyList();
        }
    }

    public synchronized String getSourceName(String string) throws AbsentInformationException {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().sourceName(string);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return "";
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return "";
        }
    }

    public synchronized String getSourcePath(String string) throws AbsentInformationException {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().sourcePath(string);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return "";
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return "";
        }
    }

    public LocalVariable[] getLocalVariables() throws AbsentInformationException {
        try {
            String string = this.getStackFrame().location().declaringType().name();
            List<com.sun.jdi.LocalVariable> list = this.getStackFrame().visibleVariables();
            int n = list.size();
            LocalVariable[] localVariableArray = new LocalVariable[n];
            for (int i = 0; i < n; ++i) {
                AbstractVariable abstractVariable;
                Value value;
                com.sun.jdi.LocalVariable localVariable = list.get(i);
                LocalVariable localVariable2 = (LocalVariable)this.debugger.getLocalVariable(localVariable, value = this.getStackFrame().getValue(localVariable));
                if (localVariable2 instanceof Local) {
                    abstractVariable = (Local)localVariable2;
                    ((Local)abstractVariable).setFrame(this);
                    ((Local)abstractVariable).setClassName(string);
                } else {
                    abstractVariable = (ObjectLocalVariable)localVariable2;
                    ((ObjectLocalVariable)abstractVariable).setFrame(this);
                    ((ObjectLocalVariable)abstractVariable).setClassName(string);
                }
                localVariableArray[i] = localVariable2;
            }
            return localVariableArray;
        }
        catch (NativeMethodException nativeMethodException) {
            throw new AbsentInformationException("native method");
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new AbsentInformationException("thread is running");
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return new LocalVariable[0];
        }
    }

    LocalVariable getLocalVariable(String string) throws AbsentInformationException {
        try {
            String string2 = this.getStackFrame().location().declaringType().name();
            com.sun.jdi.LocalVariable localVariable = this.getStackFrame().visibleVariableByName(string);
            if (localVariable == null) {
                return null;
            }
            Value value = this.getStackFrame().getValue(localVariable);
            LocalVariable localVariable2 = (LocalVariable)this.debugger.getLocalVariable(localVariable, value);
            if (localVariable2 instanceof Local) {
                Local local = (Local)localVariable2;
                local.setFrame(this);
                local.setInnerValue(value);
                local.setClassName(string2);
            } else {
                ObjectLocalVariable objectLocalVariable = (ObjectLocalVariable)localVariable2;
                objectLocalVariable.setFrame(this);
                objectLocalVariable.setInnerValue(value);
                objectLocalVariable.setClassName(string2);
            }
            return localVariable2;
        }
        catch (NativeMethodException nativeMethodException) {
            throw new AbsentInformationException("native method");
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new AbsentInformationException("thread is running");
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return null;
        }
    }

    public LocalVariable[] getMethodArguments() {
        StackFrame stackFrame = this.getStackFrame();
        String string = this.debugger.getEngineContext().getURL(stackFrame, this.getDefaultStratum());
        List<Value> list = CallStackFrameImpl.getArgumentValues(stackFrame);
        if (list == null) {
            return null;
        }
        EditorContext.MethodArgument[] methodArgumentArray = EditorContextBridge.getContext().getArguments(string, stackFrame.location().lineNumber());
        if (methodArgumentArray == null) {
            return null;
        }
        LocalVariable[] localVariableArray = new LocalVariable[methodArgumentArray.length];
        for (int i = 0; i < localVariableArray.length; ++i) {
            Value value = list.get(i);
            localVariableArray[i] = value instanceof ObjectReference ? new ArgumentObjectVariable(this.debugger, (ObjectReference)value, methodArgumentArray[i].getName(), methodArgumentArray[i].getType()) : new ArgumentVariable(this.debugger, (PrimitiveValue)value, methodArgumentArray[i].getName(), methodArgumentArray[i].getType());
        }
        return localVariableArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<LocalVariable> findOperationArguments(EditorContext.Operation var1_1) {
        if (!CallStackFrameImpl.IS_JDK_160_02) {
            return null;
        }
        var2_2 = this.debugger;
        var3_3 = (JPDAThreadImpl)this.getThread();
        var4_4 = var2_2.LOCK;
        synchronized (var4_4) {
            var5_5 = var3_3;
            synchronized (var5_5) {
                var6_6 = var3_3.getThreadReference();
                var7_7 = var6_6.virtualMachine();
                var8_8 = var7_7.eventRequestManager().createStepRequest(var6_6, -1, 1);
                var8_8.addCountFilter(1);
                var8_8.setSuspendPolicy(1);
                var8_8.enable();
                var8_8.putProperty("silent", Boolean.TRUE);
                var9_9 = new Boolean[]{null};
                this.debugger.getOperator().register(var8_8, new Executor(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean exec(Event event) {
                        Boolean[] booleanArray = var9_9;
                        synchronized (var9_9) {
                            var9_9[0] = true;
                            var9_9.notify();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void removed(EventRequest eventRequest) {
                        Boolean[] booleanArray = var9_9;
                        synchronized (var9_9) {
                            var9_9[0] = false;
                            var9_9.notify();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }
                });
                var6_6.resume();
                var10_10 /* !! */  = var9_9;
                synchronized (var9_9) {
                    block32: {
                        if (var9_9[0] == null) {
                            try {
                                var9_9.wait();
                            }
                            catch (InterruptedException var11_11) {
                                // empty catch block
                            }
                        }
                        if (Boolean.FALSE.equals(var9_9[0])) {
                            // ** MonitorExit[var10_10 /* !! */ ] (shouldn't be in output)
                            return null;
                        }
                        // ** MonitorExit[var10_10 /* !! */ ] (shouldn't be in output)
                        var10_10 /* !! */  = null;
                        var11_12 = null;
                        try {
                            try {
                                var10_10 /* !! */  = var6_6.frames(0, 1).get(0);
                                var11_12 = CallStackFrameImpl.getArgumentValues((StackFrame)var10_10 /* !! */ );
                            }
                            catch (IncompatibleThreadStateException var12_25) {
                                ErrorManager.getDefault().notify((Throwable)var12_25);
                                var13_27 = null;
                                var15_14 = null;
                                var7_7.eventRequestManager().deleteEventRequest(var8_8);
                                this.debugger.getOperator().unregister(var8_8);
                                try {
                                    if (var10_10 /* !! */  == null) return var13_27;
                                    var6_6.popFrames((StackFrame)var10_10 /* !! */ );
                                }
                                catch (IncompatibleThreadStateException var16_19) {
                                    ErrorManager.getDefault().notify((Throwable)var16_19);
                                    return null;
                                }
                                catch (NativeMethodException var16_20) {
                                    return null;
                                }
                                catch (InternalException var16_21) {
                                    if (var16_21.errorCode() != 32) throw var16_21;
                                    return null;
                                }
                                return var13_27;
                            }
                            var15_13 = null;
                            var7_7.eventRequestManager().deleteEventRequest(var8_8);
                            this.debugger.getOperator().unregister(var8_8);
                        }
                        catch (Throwable var14_30) {
                            var15_15 = null;
                            var7_7.eventRequestManager().deleteEventRequest(var8_8);
                            this.debugger.getOperator().unregister(var8_8);
                            ** try [egrp 6[TRYBLOCK] [8, 9, 10 : 302->319)] { 
lbl69:
                            // 1 sources

                            if (var10_10 /* !! */  == null) throw var14_30;
                            var6_6.popFrames((StackFrame)var10_10 /* !! */ );
                            throw var14_30;
lbl72:
                            // 1 sources

                            catch (IncompatibleThreadStateException var16_22) {
                                ErrorManager.getDefault().notify((Throwable)var16_22);
                                return null;
                            }
lbl75:
                            // 1 sources

                            catch (NativeMethodException var16_23) {
                                return null;
                            }
lbl77:
                            // 1 sources

                            catch (InternalException var16_24) {
                                if (var16_24.errorCode() != 32) throw var16_24;
                                return null;
                            }
                        }
                        ** try [egrp 6[TRYBLOCK] [8, 9, 10 : 302->319)] { 
lbl81:
                        // 1 sources

                        if (var10_10 /* !! */  != null) {
                            var6_6.popFrames((StackFrame)var10_10 /* !! */ );
                        }
                        break block32;
lbl84:
                        // 1 sources

                        catch (IncompatibleThreadStateException var16_16) {
                            ErrorManager.getDefault().notify((Throwable)var16_16);
                            return null;
                        }
lbl87:
                        // 1 sources

                        catch (NativeMethodException var16_17) {
                            return null;
                        }
lbl89:
                        // 1 sources

                        catch (InternalException var16_18) {
                            if (var16_18.errorCode() != 32) throw var16_18;
                            return null;
                        }
                    }
                    if (var11_12 == null) return null;
                    try {
                        var13_28 = this.debugger.getSession();
                        var12_26 = EditorContextBridge.getContext().getArguments(var2_2.getEngineContext().getURL(var6_6.frames(0, 1).get(0), var13_28.getCurrentLanguage()), var1_1);
                    }
                    catch (IncompatibleThreadStateException var13_29) {
                        ErrorManager.getDefault().notify((Throwable)var13_29);
                        return null;
                    }
                    if (var12_26 == null) return null;
                    var13_28 = new ArrayList<E>(var11_12.size());
                    var14_31 = 0;
                    while (var14_31 < var11_12.size()) {
                        var15_13 = var11_12.get(var14_31);
                        if (var15_13 instanceof ObjectReference) {
                            var13_28.add(new ArgumentObjectVariable(var2_2, (ObjectReference)var15_13, var12_26[var14_31].getName(), var15_13.type().name()));
                        } else {
                            var13_28.add(new ArgumentVariable(var2_2, (PrimitiveValue)var15_13, var12_26[var14_31].getName(), var15_13 != null ? var15_13.type().name() : null));
                        }
                        ++var14_31;
                    }
                    return var13_28;
                }
            }
        }
    }

    private static List<Value> getArgumentValues(StackFrame stackFrame) {
        if (!IS_JDK_16) {
            return null;
        }
        try {
            if (stackFrame.location().method().isNative()) {
                throw new NativeMethodException(stackFrame.location().method().name());
            }
            Method method = stackFrame.getClass().getMethod("getArgumentValues", new Class[0]);
            Object object = method.invoke((Object)stackFrame, new Object[0]);
            return (List)object;
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
        }
        catch (SecurityException securityException) {
            ErrorManager.getDefault().notify((Throwable)securityException);
        }
        return Collections.emptyList();
    }

    public synchronized This getThisVariable() {
        ObjectReference objectReference;
        if (!this.valid) {
            return null;
        }
        try {
            objectReference = this.getStackFrame().thisObject();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return null;
        }
        if (objectReference == null) {
            return null;
        }
        return new ThisVariable(this.debugger, objectReference, "");
    }

    public void makeCurrent() {
        this.debugger.setCurrentCallStackFrame(this);
    }

    public synchronized boolean isObsolete() {
        return this.getStackFrame().location().method().isObsolete();
    }

    public boolean canPop() {
        if (!this.debugger.canPopFrames()) {
            return false;
        }
        ThreadReference threadReference = this.getStackFrame().thread();
        try {
            if (threadReference.frameCount() <= 1) {
                return false;
            }
            List<StackFrame> list = threadReference.frames(0, 2);
            if (list.get(0).location().method().isNative() || list.get(1).location().method().isNative()) {
                return false;
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return false;
        }
        return true;
    }

    public void popFrame() {
        this.debugger.popFrames(this.sf.thread(), this.getStackFrame());
    }

    public JPDAThread getThread() {
        return this.debugger.getThread(this.sf.thread());
    }

    public StackFrame getStackFrame() {
        return this.sf;
    }

    public int getFrameDepth() {
        return this.depth;
    }

    public boolean equals(Object object) {
        try {
            return object instanceof CallStackFrameImpl && this.sf.equals(((CallStackFrameImpl)object).sf);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            return this.sf == ((CallStackFrameImpl)object).sf;
        }
    }

    public synchronized int hashCode() {
        if (this.hashCode == null) {
            try {
                this.hashCode = new Integer(this.sf.hashCode());
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                this.valid = false;
                this.hashCode = new Integer(super.hashCode());
            }
        }
        return this.hashCode;
    }
}

