/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public abstract class ClassBasedBreakpoint
extends BreakpointImpl {
    private String sourceRoot;
    private final Object SOURCE_ROOT_LOCK = new Object();
    private SourceRootsChangedListener srChListener;
    private PropertyChangeListener weakSrChListener;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");

    public ClassBasedBreakpoint(JPDABreakpoint jPDABreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super(jPDABreakpoint, null, jPDADebuggerImpl, session);
    }

    public ClassBasedBreakpoint(JPDABreakpoint jPDABreakpoint, BreakpointsReader breakpointsReader, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super(jPDABreakpoint, breakpointsReader, jPDADebuggerImpl, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSourceRoot(String string) {
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            this.sourceRoot = string;
            if (string != null && this.srChListener == null) {
                this.srChListener = new SourceRootsChangedListener();
                this.weakSrChListener = WeakListeners.propertyChange((PropertyChangeListener)this.srChListener, (Object)this.getDebugger().getEngineContext());
                this.getDebugger().getEngineContext().addPropertyChangeListener(this.weakSrChListener);
            } else if (string == null) {
                this.srChListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getSourceRoot() {
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            return this.sourceRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove() {
        super.remove();
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            if (this.srChListener != null) {
                this.getDebugger().getEngineContext().removePropertyChangeListener(this.weakSrChListener);
                this.srChListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEnabled() {
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            String string = this.getSourceRoot();
            if (string == null) {
                return true;
            }
            String[] stringArray = this.getDebugger().getEngineContext().getSourceRoots();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return true;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Breakpoint " + this.getBreakpoint() + " NOT submitted because it's source root " + string + " is not contained in debugger's source roots: " + Arrays.asList(stringArray));
            }
            String[] stringArray2 = this.getDebugger().getEngineContext().getProjectSourceRoots();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!string.equals(stringArray2[i])) continue;
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(ClassBasedBreakpoint.class, (String)"MSG_DisabledSourceRoot", (Object)string));
                break;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEnabled(String string, String[] stringArray) {
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            String string2;
            String string3 = this.getSourceRoot();
            if (string3 == null) {
                return true;
            }
            String string4 = this.getDebugger().getEngineContext().getURL(string, true);
            if (string4 == null) {
                ErrorManager.getDefault().log(16, "No URL found for source path " + string);
                return false;
            }
            stringArray[0] = string2 = this.getDebugger().getEngineContext().getSourceRoot(string4);
            return string3.equals(string2);
        }
    }

    protected void setClassRequests(String[] stringArray, String[] stringArray2, int n) {
        this.setClassRequests(stringArray, stringArray2, n, true);
    }

    protected void setClassRequests(String[] stringArray, String[] stringArray2, int n, boolean bl) {
        try {
            int n2;
            int n3;
            EventRequest eventRequest;
            if ((n & 1) != 0) {
                eventRequest = this.getEventRequestManager().createClassPrepareRequest();
                n3 = stringArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    eventRequest.addClassFilter(stringArray[n2]);
                    logger.fine("Set class load request: " + stringArray[n2]);
                }
                n3 = stringArray2.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    eventRequest.addClassExclusionFilter(stringArray2[n2]);
                    logger.fine("Set class load exclusion request: " + stringArray2[n2]);
                }
                this.addEventRequest(eventRequest, bl);
            }
            if ((n & 2) != 0) {
                eventRequest = this.getEventRequestManager().createClassUnloadRequest();
                n3 = stringArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    eventRequest.addClassFilter(stringArray[n2]);
                    logger.fine("Set class unload request: " + stringArray[n2]);
                }
                n3 = stringArray2.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    eventRequest.addClassExclusionFilter(stringArray2[n2]);
                    logger.fine("Set class unload exclusion request: " + stringArray2[n2]);
                }
                this.addEventRequest(eventRequest, false);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    protected boolean checkLoadedClasses(String string, String[] stringArray) {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        boolean bl = string.startsWith("*") || string.endsWith("*");
        logger.fine("Check loaded classes: " + string + ", will load all classes: " + bl);
        boolean bl2 = false;
        try {
            Iterator<ReferenceType> iterator = null;
            iterator = bl ? virtualMachine.allClasses().iterator() : virtualMachine.classesByName(string).iterator();
            while (iterator.hasNext()) {
                String string2;
                ReferenceType referenceType = iterator.next();
                if (iterator == null || !ClassBasedBreakpoint.match(string2 = referenceType.name(), string)) continue;
                boolean bl3 = false;
                if (stringArray != null) {
                    for (String string3 : stringArray) {
                        if (!ClassBasedBreakpoint.match(string2, string3)) continue;
                        bl3 = true;
                        break;
                    }
                }
                if (bl3) continue;
                logger.fine(" Class loaded: " + referenceType);
                this.classLoaded(referenceType);
                bl2 = true;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return bl2;
    }

    public boolean exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            logger.fine(" Class loaded: " + ((ClassPrepareEvent)event).referenceType());
            this.classLoaded(((ClassPrepareEvent)event).referenceType());
        } else if (event instanceof ClassUnloadEvent) {
            logger.fine(" Class unloaded: " + ((ClassPrepareEvent)event).referenceType());
            this.classUnloaded(((ClassUnloadEvent)event).className());
        }
        return true;
    }

    public void removed(EventRequest eventRequest) {
    }

    protected void classLoaded(ReferenceType referenceType) {
    }

    protected void classUnloaded(String string) {
    }

    private class SourceRootsChangedListener
    implements PropertyChangeListener {
        private SourceRootsChangedListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("sourceRoots".equals(propertyChangeEvent.getPropertyName())) {
                ClassBasedBreakpoint.this.update();
            }
        }
    }
}

