/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java6Methods {
    private static final boolean IS_JDK_16 = !System.getProperty("java.version").startsWith("1.5");

    private Java6Methods() {
    }

    public static boolean isJDK6() {
        return IS_JDK_16;
    }

    public static long[] instanceCounts(VirtualMachine virtualMachine, List<ReferenceType> list) {
        try {
            Method method = VirtualMachine.class.getMethod("instanceCounts", List.class);
            Object object = method.invoke((Object)virtualMachine, list);
            return (long[])object;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return new long[list.size()];
        }
    }

    public static List<ObjectReference> instances(ReferenceType referenceType, long l) {
        try {
            Method method = ReferenceType.class.getMethod("instances", Long.TYPE);
            Object object = method.invoke((Object)referenceType, l);
            return (List)object;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return new ArrayList<ObjectReference>();
        }
    }

    public static List<ObjectReference> referringObjects(ObjectReference objectReference, long l) {
        try {
            Method method = ObjectReference.class.getMethod("referringObjects", Long.TYPE);
            Object object = method.invoke((Object)objectReference, l);
            return (List)object;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return new ArrayList<ObjectReference>();
        }
    }
}

