/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard.i18n;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.mobility.project.ui.wizard.i18n.LocalizationSupportPanel;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class LocalizationSupportPanelGUI
extends JPanel
implements ActionListener,
ItemListener,
DocumentListener {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private static final ListCellRenderer CELL_RENDERER = new NodeCellRenderer();
    private Project project;
    private AntProjectHelper helper;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private Document pkgComboBoxDocument = null;
    private JLabel cClassLabel;
    private JTextField cClassTextField;
    private JLabel cResourceLabel;
    private JTextField cResourceTextField;
    private JLabel clsLabel;
    private JTextField clsTextField;
    private JLabel dsLabel;
    private JTextField dsTextField;
    private JLabel emLabel;
    private JTextField emTextField;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JComboBox pkgComboBox;
    private JLabel pkgLabel;
    private JLabel prjLabel;
    private JTextField prjTextField;
    private JLabel rnLabel;
    private JTextField rnTextField;
    private JSeparator targetSeparator;

    public LocalizationSupportPanelGUI() {
        this.initComponents();
        this.initAccessibility();
        Component component = this.pkgComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            this.pkgComboBoxDocument = ((JTextField)component).getDocument();
            this.pkgComboBoxDocument.addDocumentListener(this);
        }
        this.pkgComboBox.setRenderer(CELL_RENDERER);
        this.pkgComboBox.addActionListener(this);
    }

    public String getTargetClassName() {
        return LocalizationSupportPanelGUI.normalizedString(this.clsTextField.getText());
    }

    public String getTargetMessageFileName() {
        return LocalizationSupportPanelGUI.normalizedString(this.rnTextField.getText());
    }

    public String getTargetMessageFileNameExt() {
        return this.getTargetMessageFileName() + ".properties";
    }

    public String getTargetDefaultStringValue() {
        return LocalizationSupportPanelGUI.normalizedString(this.dsTextField.getText());
    }

    public String getTargetDefaultErrorMessageValue() {
        return LocalizationSupportPanelGUI.normalizedString(this.emTextField.getText());
    }

    public String getCreatedClass() {
        return this.cClassTextField.getText();
    }

    public String getCreatedMessageFile() {
        return this.cResourceTextField.getText();
    }

    private static String normalizedString(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() <= 0) {
            return null;
        }
        return string;
    }

    void initValues(Project project, FileObject fileObject, FileObject fileObject2) {
        this.project = project;
        this.helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        this.prjTextField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        SourceGroup sourceGroup = this.getPreselectedGroup(sourceGroupArray, fileObject2);
        if (sourceGroup != null) {
            ModelItem modelItem = new ModelItem(sourceGroup);
            ModelItem[] modelItemArray = modelItem.getChildren();
            this.pkgComboBox.setModel(new DefaultComboBoxModel<ModelItem>(modelItemArray));
            ModelItem modelItem2 = this.getPreselectedPackage(modelItem, fileObject2);
            if (modelItem2 != null) {
                this.pkgComboBox.setSelectedItem(modelItem2);
            }
        } else {
            this.pkgComboBox.setModel(new DefaultComboBoxModel());
        }
        this.clsTextField.setText(fileObject.getName());
        this.addThisListeners();
        this.updateCreatedClassName();
        this.updateCreatedMessageFileName();
    }

    private void addThisListeners() {
        this.clsTextField.getDocument().addDocumentListener(this);
        this.rnTextField.getDocument().addDocumentListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.pkgComboBox == actionEvent.getSource()) {
            this.updateCreatedClassName();
            this.updateCreatedMessageFileName();
            this.fireChange();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.clsTextField.getDocument()) {
            this.updateCreatedClassName();
            this.fireChange();
        } else if (documentEvent.getDocument() == this.rnTextField.getDocument()) {
            this.updateCreatedMessageFileName();
            this.fireChange();
        } else if (this.pkgComboBoxDocument != null && documentEvent.getDocument() == this.pkgComboBoxDocument) {
            this.updateCreatedClassName();
            this.updateCreatedMessageFileName();
            this.fireChange();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    private SourceGroup getPreselectedGroup(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        if (fileObject != null) {
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                if (!sourceGroupArray[i].getRootFolder().equals(fileObject) && !FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
                return sourceGroupArray[i];
            }
        }
        return sourceGroupArray.length >= 0 ? sourceGroupArray[0] : null;
    }

    private ModelItem getPreselectedPackage(ModelItem modelItem, FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        ModelItem[] modelItemArray = modelItem.getChildren();
        FileObject fileObject2 = modelItem.group.getRootFolder();
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject).replace('/', '.');
        for (int i = 0; i < modelItemArray.length; ++i) {
            if (!modelItemArray[i].toString().equals(string)) continue;
            return modelItemArray[i];
        }
        return null;
    }

    public FileObject getRootFolder() {
        return this.helper.resolveFileObject(this.helper.getStandardPropertyEvaluator().getProperty("src.dir"));
    }

    public File getFolder() {
        FileObject fileObject = this.getRootFolder();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        return new File(file, this.getPackageFileName());
    }

    public String getPackageFileName() {
        String string = this.pkgComboBox.getEditor().getItem().toString();
        if (ModelItem.DEFAULT_PACKAGE_DISPLAY_NAME.equals(string)) {
            string = "";
        }
        return string.replace('.', '/');
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void updateCreatedClassName() {
        this.updateCreatedFileTextField(this.getTargetClassName(), ".java", this.cClassTextField);
    }

    private void updateCreatedMessageFileName() {
        this.updateCreatedFileTextField(this.getTargetMessageFileName(), ".properties", this.cResourceTextField);
    }

    private void updateCreatedFileTextField(String string, String string2, JTextField jTextField) {
        File file;
        File file2;
        if (string != null && string.length() > 0 && (file2 = FileUtil.toFile((FileObject)this.project.getProjectDirectory())) != null && (file = this.getFolder()) != null) {
            File file3 = new File(file, string + string2);
            jTextField.setText(file3.getAbsolutePath());
            return;
        }
        jTextField.setText("");
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.clsLabel = new JLabel();
        this.clsTextField = new JTextField();
        this.rnLabel = new JLabel();
        this.rnTextField = new JTextField();
        this.prjLabel = new JLabel();
        this.prjTextField = new JTextField();
        this.pkgLabel = new JLabel();
        this.pkgComboBox = new JComboBox();
        this.cClassLabel = new JLabel();
        this.cClassTextField = new JTextField();
        this.cResourceLabel = new JLabel();
        this.cResourceTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.dsLabel = new JLabel();
        this.dsTextField = new JTextField();
        this.emLabel = new JLabel();
        this.emTextField = new JTextField();
        this.jPanel4 = new JPanel();
        this.setMinimumSize(new Dimension(245, 230));
        this.setName(NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"TITLE_File"));
        this.setPreferredSize(new Dimension(245, 232));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.clsLabel.setLabelFor(this.clsTextField);
        Mnemonics.setLocalizedText((JLabel)this.clsLabel, (String)NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"LBL_File_MIDPClassName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.jPanel1.add((Component)this.clsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.clsTextField, gridBagConstraints);
        this.rnLabel.setLabelFor(this.rnTextField);
        Mnemonics.setLocalizedText((JLabel)this.rnLabel, (String)NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"LBL_Resource_FileName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel1.add((Component)this.rnLabel, gridBagConstraints);
        this.rnTextField.setText(NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"TXT_DefValue_MessagesFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.rnTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.prjLabel.setLabelFor(this.prjTextField);
        Mnemonics.setLocalizedText((JLabel)this.prjLabel, (String)NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"LBL_File_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.prjLabel, gridBagConstraints);
        this.prjTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.prjTextField, gridBagConstraints);
        this.pkgLabel.setLabelFor(this.pkgComboBox);
        Mnemonics.setLocalizedText((JLabel)this.pkgLabel, (String)NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"LBL_File_Package"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.pkgLabel, gridBagConstraints);
        this.pkgComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 11, 0);
        this.add((Component)this.pkgComboBox, gridBagConstraints);
        this.cClassLabel.setLabelFor(this.cClassTextField);
        Mnemonics.setLocalizedText((JLabel)this.cClassLabel, (String)NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"LBL_File_Created_Class"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.cClassLabel, gridBagConstraints);
        this.cClassTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.cClassTextField, gridBagConstraints);
        this.cResourceLabel.setLabelFor(this.cResourceTextField);
        Mnemonics.setLocalizedText((JLabel)this.cResourceLabel, (String)NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"LBL_File_Created_Resource"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.cResourceLabel, gridBagConstraints);
        this.cResourceTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.cResourceTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.dsLabel.setLabelFor(this.dsTextField);
        Mnemonics.setLocalizedText((JLabel)this.dsLabel, (String)NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"LBL_Resource_DefaultString"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.dsLabel, gridBagConstraints);
        this.dsTextField.setText(NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"TXT_DefValue_DefaultString"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.dsTextField, gridBagConstraints);
        this.emLabel.setLabelFor(this.emTextField);
        Mnemonics.setLocalizedText((JLabel)this.emLabel, (String)NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"LBL_Resource_ErrorMessage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.emLabel, gridBagConstraints);
        this.emTextField.setText(NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"TXT_DefValue_ErrorMessage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.emTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel4, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"ACSN_I18N"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LocalizationSupportPanelGUI.class, (String)"ACSD_I18N"));
    }

    private static class NodeCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public NodeCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof ModelItem) {
                ModelItem modelItem = (ModelItem)object;
                this.setText(modelItem.getDisplayName());
                this.setIcon(modelItem.getIcon());
            } else {
                this.setText(object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private static class ModelItem {
        public static final String DEFAULT_PACKAGE_DISPLAY_NAME = NbBundle.getMessage(LocalizationSupportPanel.class, (String)"LBL_DefaultPackage");
        private final Icon icon;
        private Node node;
        protected SourceGroup group;
        private ModelItem[] children;

        public ModelItem(SourceGroup sourceGroup) {
            this.group = sourceGroup;
            this.icon = sourceGroup.getIcon(false);
        }

        public ModelItem(Node node) {
            this.node = node;
            this.icon = new ImageIcon(node.getIcon(1));
        }

        public String getDisplayName() {
            if (this.group != null) {
                return this.group.getDisplayName();
            }
            String string = this.node.getName();
            return string.length() == 0 ? DEFAULT_PACKAGE_DISPLAY_NAME : string;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            if (this.group != null) {
                return this.getDisplayName();
            }
            return this.node.getName();
        }

        public ModelItem[] getChildren() {
            if (this.group == null) {
                return null;
            }
            if (this.children == null) {
                Node node = PackageView.createPackageView((SourceGroup)this.group);
                if (node == null) {
                    return null;
                }
                Children children = node.getChildren();
                if (children == null) {
                    return null;
                }
                Node[] nodeArray = children.getNodes(true);
                this.children = new ModelItem[nodeArray.length];
                for (int i = 0; i < nodeArray.length; ++i) {
                    this.children[i] = new ModelItem(nodeArray[i]);
                }
            }
            return this.children;
        }
    }
}

