/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.customizer.NewConfigurationPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveConfigurationPanel
extends JPanel
implements DocumentListener {
    private final JButton saveBtn;
    private final Collection<String> templateNames;
    private ErrorPanel errorPanel;
    private JLabel jLabel1;
    private JTextField jTextFieldName;

    public SaveConfigurationPanel(String string, Collection<String> collection, JButton jButton) {
        this.templateNames = collection;
        this.initComponents();
        this.initAccessibility();
        this.jTextFieldName.setText(string);
        this.jTextFieldName.setSelectionStart(0);
        this.jTextFieldName.setSelectionEnd(string.length());
        this.saveBtn = jButton;
        this.jTextFieldName.getDocument().addDocumentListener(this);
        this.changedUpdate(null);
    }

    @Override
    public String getName() {
        return this.jTextFieldName.getText();
    }

    @Override
    public final boolean isValid() {
        String string = this.jTextFieldName.getText();
        if (J2MEProjectUtils.ILEGAL_CONFIGURATION_NAMES.contains(string)) {
            this.errorPanel.setErrorBundleMessage("ERR_SaveCfg_ReservedWord");
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)string)) {
            this.errorPanel.setErrorBundleMessage("ERR_SaveCfg_MustBeJavaIdentifier");
            return false;
        }
        if (this.templateNames.contains(string)) {
            this.errorPanel.setErrorBundleMessage("ERR_SaveCfg_NameExists");
            return true;
        }
        this.errorPanel.setErrorBundleMessage(null);
        return true;
    }

    @Override
    public final void changedUpdate(DocumentEvent documentEvent) {
        if (this.saveBtn != null) {
            this.saveBtn.setEnabled(this.isValid());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.errorPanel = new ErrorPanel();
        this.setPreferredSize(new Dimension(400, 100));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.jTextFieldName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SaveConfigurationPanel.class, (String)"LBL_SaveConfigPanel_TemplateName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 12);
        this.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jTextFieldName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SaveConfigurationPanel.class, (String)"ADSC_SaveConfigPanel_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConfigurationPanel.class, (String)"ACSN_SaveConfigPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConfigurationPanel.class, (String)"ACSD_SaveConfigPanel"));
    }
}

