/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIDletScanner
implements Runnable {
    private final ProjectProperties props;
    private J2MEPlatform activePlatform;
    private final HashMap<FileObject, HashSet<String>> roots2icons = new HashMap();
    private final HashMap<FileObject, HashSet<String>> roots2midlets = new HashMap();
    private final HashMap<FileObject, HashSet<DefaultComboBoxModel>> roots2iconModels = new HashMap();
    private final HashMap<FileObject, HashSet<DefaultComboBoxModel>> roots2midletModelts = new HashMap();
    private final HashSet<ChangeListener> listeners = new HashSet();
    private boolean parsing = false;
    private static Reference<MIDletScanner> cache = new WeakReference<Object>(null);
    private static Pattern p = Pattern.compile("\\s+extends\\s+(javax\\.microedition\\.midlet\\.)?MIDlet");

    public static MIDletScanner getDefault(ProjectProperties projectProperties) {
        MIDletScanner mIDletScanner = cache.get();
        if (mIDletScanner == null || mIDletScanner.props != projectProperties) {
            mIDletScanner = new MIDletScanner(projectProperties);
            cache = new WeakReference<MIDletScanner>(mIDletScanner);
        }
        return mIDletScanner;
    }

    private MIDletScanner(ProjectProperties projectProperties) {
        this.props = projectProperties;
    }

    public boolean isScanning() {
        return this.parsing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(DefaultComboBoxModel defaultComboBoxModel, DefaultComboBoxModel defaultComboBoxModel2, String string, ChangeListener changeListener) {
        MIDletScanner mIDletScanner = this;
        synchronized (mIDletScanner) {
            J2MEPlatform j2MEPlatform;
            for (FileObject javaPlatformArray2 : this.getRootsFor(string)) {
                if (defaultComboBoxModel2 != null) {
                    defaultComboBoxModel2.removeAllElements();
                    j2MEPlatform = this.roots2iconModels.get(javaPlatformArray2);
                    if (j2MEPlatform == null) {
                        j2MEPlatform = new HashSet();
                        this.roots2iconModels.put(javaPlatformArray2, (HashSet<DefaultComboBoxModel>)j2MEPlatform);
                    }
                    j2MEPlatform.add((DefaultComboBoxModel)defaultComboBoxModel2);
                }
                if (defaultComboBoxModel == null) continue;
                defaultComboBoxModel.removeAllElements();
                j2MEPlatform = this.roots2midletModelts.get(javaPlatformArray2);
                if (j2MEPlatform == null) {
                    j2MEPlatform = new HashSet();
                    this.roots2midletModelts.put(javaPlatformArray2, (HashSet<DefaultComboBoxModel>)j2MEPlatform);
                }
                j2MEPlatform.add((DefaultComboBoxModel)defaultComboBoxModel);
            }
            String string2 = (String)this.props.get(VisualPropertySupport.translatePropertyName(string, "platform.active", true));
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
            for (int i = 0; string2 != null && i < javaPlatformArray.length; ++i) {
                j2MEPlatform = (J2MEPlatform)javaPlatformArray[i];
                if (!string2.equals(j2MEPlatform.getDisplayName())) continue;
                this.activePlatform = j2MEPlatform;
                break;
            }
            this.listeners.add(changeListener);
            if (!this.parsing) {
                this.parsing = true;
                RequestProcessor.getDefault().post((Runnable)this);
            }
        }
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
        this.listeners.clear();
    }

    private Collection<FileObject> getArchiveRoots(FileObject[] fileObjectArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(fileObjectArray.length);
        for (FileObject fileObject : fileObjectArray) {
            arrayList.add(FileUtil.isArchiveFile((FileObject)fileObject) ? FileUtil.getArchiveRoot((FileObject)fileObject) : fileObject);
        }
        return arrayList;
    }

    private HashSet<FileObject> getRootsFor(String string) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        hashSet.add(this.props.getSourceRoot());
        List list = (List)this.props.get(VisualPropertySupport.translatePropertyName(string, "libs.classpath", true));
        if (list == null) {
            list = (List)this.props.get("libs.classpath");
        }
        if (list == null) {
            return hashSet;
        }
        for (VisualClassPathItem visualClassPathItem : list) {
            Object object;
            Object object2;
            if (2 == visualClassPathItem.getType()) {
                object2 = (AntArtifact)visualClassPathItem.getElement();
                if (object2 == null) continue;
                hashSet.addAll(this.getArchiveRoots(object2.getArtifactFiles()));
                continue;
            }
            if (0 == visualClassPathItem.getType() || 4 == visualClassPathItem.getType()) {
                object2 = (File)visualClassPathItem.getElement();
                if (object2 == null) continue;
                try {
                    object = FileUtil.toFileObject((File)object2);
                    if (object == null) continue;
                    hashSet.add((FileObject)(FileUtil.isArchiveFile((FileObject)object) ? FileUtil.getArchiveRoot((FileObject)object) : object));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            if (1 != visualClassPathItem.getType() || (object2 = (Library)visualClassPathItem.getElement()) == null) continue;
            object = object2.getContent("classpath").iterator();
            while (object.hasNext()) {
                FileObject fileObject = URLMapper.findFileObject((URL)((URL)object.next()));
                if (fileObject == null) continue;
                hashSet.add(FileUtil.isArchiveFile((FileObject)fileObject) ? FileUtil.getArchiveRoot((FileObject)fileObject) : fileObject);
            }
        }
        hashSet.remove(null);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileObject fileObject = null;
        while (true) {
            HashSet<String> hashSet;
            HashSet<String> hashSet2;
            MIDletScanner mIDletScanner = this;
            synchronized (mIDletScanner) {
                HashSet<DefaultComboBoxModel> hashSet3 = this.roots2iconModels.remove(fileObject);
                if (hashSet3 != null) {
                    this.fillModels(hashSet3, this.roots2icons.get(fileObject));
                }
                if ((hashSet3 = this.roots2midletModelts.remove(fileObject)) != null) {
                    this.fillModels(hashSet3, this.roots2midlets.get(fileObject));
                }
                if ((fileObject = this.getNextRoot()) == null) {
                    this.parsing = false;
                    this.fireStateChanged();
                    return;
                }
                if (this.roots2icons.containsKey(fileObject)) {
                    continue;
                }
                hashSet2 = new HashSet<String>();
                hashSet = new HashSet<String>();
                this.roots2icons.put(fileObject, hashSet2);
                this.roots2midlets.put(fileObject, hashSet);
            }
            try {
                this.scanForMIDletsAndIcons(fileObject, hashSet2, hashSet);
            }
            catch (Exception exception) {
            }
        }
    }

    private FileObject getNextRoot() {
        if (!this.roots2iconModels.isEmpty()) {
            return this.roots2iconModels.keySet().iterator().next();
        }
        if (!this.roots2midletModelts.isEmpty()) {
            return this.roots2midletModelts.keySet().iterator().next();
        }
        return null;
    }

    private void fillModels(HashSet<DefaultComboBoxModel> hashSet, HashSet<String> hashSet2) {
        for (DefaultComboBoxModel defaultComboBoxModel : hashSet) {
            for (String string : hashSet2) {
                if (defaultComboBoxModel.getIndexOf(string) >= 0) continue;
                defaultComboBoxModel.addElement(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForMIDletsAndIcons(FileObject fileObject, HashSet<String> hashSet, HashSet<String> hashSet2) {
        String string = fileObject.getPath();
        int n = string.length();
        Enumeration enumeration = fileObject.getChildren(true);
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.isData()) continue;
            String string2 = fileObject2.getExt().toLowerCase();
            if ("png".equals(string2)) {
                object2 = fileObject2.getPath().substring(n);
                if (!((String)object2).startsWith("/")) {
                    object2 = "/" + (String)object2;
                }
                object = this;
                synchronized (object) {
                    hashSet.add((String)object2);
                    continue;
                }
            }
            if (!"java".equals(string2) && !"class".equals(string2) || !(this.activePlatform != null ? this.isMIDlet2(fileObject, fileObject2) : this.isMIDlet(fileObject2))) continue;
            object2 = this;
            synchronized (object2) {
                object = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
                hashSet2.add(((String)object).substring(0, ((String)object).length() - string2.length() - 1).replace('/', '.').replace('\\', '.'));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMIDlet(FileObject fileObject) {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("javax/microedition/midlet/MIDlet") < 0 && !p.matcher(string).find()) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private boolean isMIDlet2(FileObject fileObject, final FileObject fileObject2) {
        final Boolean[] booleanArray = new Boolean[]{false};
        ClassPath classPath = this.activePlatform.getBootstrapLibraries();
        ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        ClassPath classPath4 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath3, classPath2});
        final ClassPath classPath5 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source"), classPath3});
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)classPath, (ClassPath)classPath4, (ClassPath)classPath5);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    TypeElement typeElement = compilationController.getElements().getTypeElement("javax.microedition.midlet.MIDlet");
                    if (typeElement == null) {
                        return;
                    }
                    String string = classPath5.getResourceName(fileObject2);
                    if (string == null) {
                        return;
                    }
                    string = string.substring(0, string.lastIndexOf(46)).replace('/', '.');
                    TypeElement typeElement2 = compilationController.getElements().getTypeElement(string);
                    if (typeElement2 == null) {
                        return;
                    }
                    Set<Modifier> set = typeElement2.getModifiers();
                    if (set.contains((Object)Modifier.ABSTRACT) || !set.contains((Object)Modifier.PUBLIC)) {
                        return;
                    }
                    Types types = compilationController.getTypes();
                    booleanArray[0] = types.isSubtype(types.erasure(typeElement2.asType()), types.erasure(typeElement.asType()));
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return booleanArray[0];
    }
}

