/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public class J2MEProjectUtils {
    public static final Set<String> ILEGAL_CONFIGURATION_NAMES = new HashSet<String>(Arrays.asList("preprocessed", "compiled", "obfuscated", "preverified"));

    private J2MEProjectUtils() {
    }

    public static Project getActiveProject(TopComponent topComponent) {
        Node[] nodeArray = topComponent == null ? TopComponent.getRegistry().getActivatedNodes() : topComponent.getActivatedNodes();
        Project project = null;
        if (nodeArray != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
                if (dataObject == null) continue;
                Project project2 = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
                if (project != null && project2 != null && !project.equals(project2)) {
                    return null;
                }
                project = project2;
            }
        }
        return project;
    }

    public static Project getActiveProject() {
        return J2MEProjectUtils.getActiveProject(null);
    }

    public static Project getProjectForDocument(Document document) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject != null) {
            return FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        return null;
    }

    public static ProjectConfigurationProvider getConfigProviderForDoc(Document document) {
        Project project = J2MEProjectUtils.getProjectForDocument(document);
        if (project != null) {
            return (ProjectConfigurationProvider)project.getLookup().lookup(ProjectConfigurationProvider.class);
        }
        return null;
    }

    public static ProjectConfigurationsHelper getCfgHelperForDoc(Document document) {
        Project project = J2MEProjectUtils.getProjectForDocument(document);
        if (project != null) {
            return (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        }
        return null;
    }

    public static String evaluateProperty(AntProjectHelper antProjectHelper, String string, String string2) {
        String string3;
        PropertyEvaluator propertyEvaluator = antProjectHelper.getStandardPropertyEvaluator();
        if (string2 != null && string2.length() > 0 && (string3 = propertyEvaluator.getProperty("configs." + string2 + "." + string)) != null) {
            return string3;
        }
        return propertyEvaluator.getProperty(string);
    }

    public static String evaluateProperty(AntProjectHelper antProjectHelper, String string) {
        PropertyEvaluator propertyEvaluator = antProjectHelper.getStandardPropertyEvaluator();
        String string2 = propertyEvaluator.getProperty("config.active");
        return J2MEProjectUtils.evaluateProperty(antProjectHelper, string, string2);
    }

    public static URL deJar(URL uRL) {
        if (uRL == null) {
            return null;
        }
        URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
        return uRL2 == null ? uRL : uRL2;
    }

    public static URL wrapJar(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toExternalForm().toLowerCase();
        if (string.endsWith(".jar") || string.endsWith(".zip")) {
            return FileUtil.getArchiveRoot((URL)uRL);
        }
        if (!string.endsWith("/")) {
            try {
                return new URL(uRL.toExternalForm() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
        }
        return uRL;
    }

    public static boolean isParentOf(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return false;
        }
        return J2MEProjectUtils.deJar(uRL2).toExternalForm().startsWith(J2MEProjectUtils.deJar(uRL).toExternalForm());
    }

    public static String detectConfiguration(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return null;
        }
        String string = J2MEProjectUtils.deJar(uRL).toExternalForm();
        String string2 = J2MEProjectUtils.deJar(uRL2).toExternalForm();
        if (!string2.startsWith(string)) {
            return null;
        }
        if ((string2 = string2.substring(string.length())).startsWith("/")) {
            string2 = string2.substring(1);
        }
        int n = string2.indexOf(47);
        int n2 = string2.indexOf(47, n + 1);
        if (n < 0 || n2 < 0) {
            return null;
        }
        String string3 = string2.substring(n + 1, n2);
        return (string2.startsWith("build") || string2.startsWith("dist")) && !ILEGAL_CONFIGURATION_NAMES.contains(string3) ? string3 : null;
    }
}

