/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.javascript.editing.JsFormatter;
import org.netbeans.modules.javascript.hints.spi.Edit;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class EditList {
    private BaseDocument doc;
    private List<Edit> edits;
    private boolean format;

    public EditList(BaseDocument baseDocument) {
        this.doc = baseDocument;
        this.edits = new ArrayList<Edit>();
    }

    public String toString() {
        return "EditList(" + this.edits + ")";
    }

    public EditList replace(int n, int n2, String string, boolean bl, int n3) {
        this.edits.add(new Edit(n, n2, string, bl, n3));
        return this;
    }

    public void applyToDocument(BaseDocument baseDocument) {
        EditList editList = new EditList(baseDocument);
        editList.format = this.format;
        editList.edits = this.edits;
        editList.apply();
    }

    public void apply() {
        this.apply(-1);
    }

    public void format() {
        this.format = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position apply(int n) {
        if (this.edits.size() == 0) {
            if (n >= 0) {
                try {
                    return this.doc.createPosition(0);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            return null;
        }
        Position position = null;
        Collections.sort(this.edits);
        Collections.reverse(this.edits);
        JsFormatter jsFormatter = new JsFormatter();
        try {
            this.doc.atomicLock();
            int n2 = this.edits.get((int)0).offset;
            Position position2 = this.doc.createPosition(n2, Position.Bias.Forward);
            int n3 = 0;
            for (Edit edit : this.edits) {
                if (edit.removeLen > 0) {
                    this.doc.remove(edit.offset, edit.removeLen);
                    n3 -= edit.removeLen;
                }
                if (edit.insertText == null) continue;
                this.doc.insertString(edit.offset, edit.insertText, null);
                n3 += edit.insertText.length();
                int n4 = edit.offset + edit.insertText.length();
                if (edit.getOffset() <= n && n4 >= n) {
                    position = this.doc.createPosition(n);
                }
                if (!edit.format) continue;
                jsFormatter.reindent((Document)this.doc, edit.offset, n4);
            }
            if (this.format) {
                int n5 = this.edits.get((int)(this.edits.size() - 1)).offset;
                n2 = position2.getOffset();
                jsFormatter.reindent((Document)this.doc, n5, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        finally {
            this.doc.atomicUnlock();
        }
        return position;
    }

    public OffsetRange getRange() {
        int n;
        int n2 = n = this.edits.get((int)0).offset;
        for (Edit edit : this.edits) {
            if (edit.offset < n) {
                n = edit.offset;
            }
            if (edit.offset <= n2) continue;
            n2 = edit.offset;
        }
        return new OffsetRange(n, n2);
    }

    public int firstLine(BaseDocument baseDocument) {
        OffsetRange offsetRange = this.getRange();
        return NbDocument.findLineNumber((StyledDocument)((StyledDocument)baseDocument), (int)offsetRange.getStart());
    }
}

