/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.FunctionAstElement;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.javascript.hints.MoreInfoFix;
import org.netbeans.modules.javascript.hints.UnsupportedCalls;
import org.netbeans.modules.javascript.hints.spi.AstRule;
import org.netbeans.modules.javascript.hints.spi.Description;
import org.netbeans.modules.javascript.hints.spi.Fix;
import org.netbeans.modules.javascript.hints.spi.HintSeverity;
import org.netbeans.modules.javascript.hints.spi.RuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrongJsDoc
implements AstRule {
    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return JsUtils.isJsFile((FileObject)compilationInfo.getFileObject());
    }

    @Override
    public Set<Integer> getKinds() {
        return Collections.singleton(105);
    }

    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        String string2;
        Object object2;
        JsParseResult jsParseResult;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        Node node = ruleContext.node;
        AstElement astElement = (AstElement)node.element;
        if (astElement == null && (jsParseResult = AstUtilities.getParseResult((CompilationInfo)compilationInfo)) != null) {
            jsParseResult.getStructure();
            astElement = (AstElement)node.element;
            if (astElement == null) {
                return;
            }
        }
        if (astElement.getKind() != ElementKind.METHOD && astElement.getKind() != ElementKind.CONSTRUCTOR) {
            return;
        }
        if (!(astElement instanceof FunctionAstElement)) {
            assert (false) : astElement;
            return;
        }
        jsParseResult = (FunctionAstElement)astElement;
        Map map = astElement.getDocProps();
        if (map == null || map.size() == 0) {
            return;
        }
        boolean bl = false;
        for (Object object2 : map.keySet()) {
            if (((String)object2).startsWith("@")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        List list2 = jsParseResult.getParameters();
        object2 = null;
        ArrayList<String> arrayList = null;
        Object object3 = list2.iterator();
        while (object3.hasNext()) {
            string2 = (String)object3.next();
            if (map.containsKey(string2)) continue;
            if (object2 == null) {
                object2 = new ArrayList();
            }
            object2.add(string2);
        }
        for (String string2 : map.keySet()) {
            if (string2.startsWith("@") || list2.contains(string2)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string2);
        }
        if (object2 != null || arrayList != null) {
            if (object2 != null && arrayList != null) {
                object3 = NbBundle.getMessage(WrongJsDoc.class, (String)"WrongParamsBoth", (Object)object2, arrayList);
            } else if (object2 != null) {
                object3 = NbBundle.getMessage(WrongJsDoc.class, (String)"WrongParamsMissing", (Object)object2);
            } else {
                assert (arrayList != null);
                object3 = NbBundle.getMessage(WrongJsDoc.class, (String)"WrongParamsExtra", arrayList);
            }
            string2 = AstUtilities.getNameRange((Node)node);
            OffsetRange offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)string2);
            if (offsetRange == OffsetRange.NONE) {
                return;
            }
            if (offsetRange.getEnd() < ruleContext.doc.getLength()) {
                try {
                    int n = Utilities.getRowEnd((BaseDocument)ruleContext.doc, (int)offsetRange.getStart());
                    if (n < offsetRange.getEnd() && n > offsetRange.getStart()) {
                        offsetRange = new OffsetRange(offsetRange.getStart(), n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            List<Fix> list3 = Collections.singletonList(new MoreInfoFix("wrongjsdoc"));
            Description description = new Description(this, (String)object3, compilationInfo.getFileObject(), offsetRange, list3, 1450);
            list.add(description);
        }
    }

    @Override
    public String getId() {
        return "WrongJsDoc";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(UnsupportedCalls.class, (String)"WrongJsDoc");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(UnsupportedCalls.class, (String)"WrongJsDocDesc");
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public boolean showInTasklist() {
        return true;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }
}

