/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.BrowserVersion;
import org.netbeans.modules.javascript.editing.SupportedBrowsers;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.javascript.hints.MoreInfoFix;
import org.netbeans.modules.javascript.hints.spi.Description;
import org.netbeans.modules.javascript.hints.spi.EditList;
import org.netbeans.modules.javascript.hints.spi.ErrorRule;
import org.netbeans.modules.javascript.hints.spi.HintSeverity;
import org.netbeans.modules.javascript.hints.spi.PreviewableFix;
import org.netbeans.modules.javascript.hints.spi.RuleContext;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrictWarning
implements ErrorRule {
    public static final String ANON_NO_RETURN_VALUE = "msg.anon.no.return.value";
    public static final String BAD_OCTAL_LITERAL = "msg.bad.octal.literal";
    public static final String DUP_PARAMS = "msg.dup.parms";
    public static final String NO_RETURN_VALUE = "msg.no.return.value";
    public static final String NO_SIDE_EFFECTS = "msg.no.side.effects";
    public static final String RESERVED_KEYWORD = "msg.reserved.keyword";
    public static final String RETURN_INCONSISTENT = "msg.return.inconsistent";
    public static final String TRAILING_COMMA = "msg.trailing.comma";
    public static final String VAR_HIDES_ARG = "msg.var.hides.arg";
    public static final String VAR_REDECL = "msg.var.redecl";
    public static final String[] KNOWN_STRICT_ERROR_KEYS = new String[]{"msg.trailing.comma", "msg.bad.octal.literal", "msg.reserved.keyword", "msg.dup.parms", "msg.return.inconsistent", "msg.no.return.value", "msg.anon.no.return.value", "msg.var.hides.arg", "msg.var.redecl", "msg.no.side.effects"};
    private String key;
    private HintSeverity defaultSeverity = HintSeverity.WARNING;

    public StrictWarning(String string) {
        this.key = string;
    }

    @Override
    public Set<String> getCodes() {
        return Collections.singleton(this.key);
    }

    @Override
    public void run(RuleContext ruleContext, Error error, List<Description> list) {
        Object object;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        BaseDocument baseDocument = ruleContext.doc;
        OffsetRange offsetRange = null;
        int n = error.getStartPosition();
        int n2 = LexUtilities.getLexerOffset((CompilationInfo)compilationInfo, (int)n);
        if (TRAILING_COMMA.equals(this.key)) {
            if (!SupportedBrowsers.getInstance().isSupported(BrowserVersion.IE7)) {
                ruleContext.remove = true;
                return;
            }
            n = (Integer)error.getParameters()[0];
            n2 = LexUtilities.getLexerOffset((CompilationInfo)compilationInfo, (int)n);
            offsetRange = new OffsetRange(n2, n2 + 1);
        } else if (RESERVED_KEYWORD.equals(this.key)) {
            String string = (String)error.getParameters()[1];
            offsetRange = new OffsetRange(n2 - string.length(), n2);
        } else if (error.getParameters() != null) {
            Node node = (Node)error.getParameters()[0];
            boolean bl = RETURN_INCONSISTENT.equals(this.key);
            if (bl) {
                for (object = node; object != null; object = object.getParentNode()) {
                    if (object.getType() != 4) continue;
                    node = object;
                    break;
                }
            }
            if (node.getType() == 124 && !"text/javascript".equals(compilationInfo.getFileObject().getMIMEType())) {
                ruleContext.remove = true;
                return;
            }
            object = AstUtilities.getRange((Node)node);
            offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)object);
        } else {
            int n3 = n2;
            try {
                int n4 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n3);
                if (n4 <= n3 && n3 == (n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3))) {
                    n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
                    n4 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n3) + 1;
                }
                offsetRange = new OffsetRange(n3, n4);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                offsetRange = OffsetRange.NONE;
            }
        }
        if (offsetRange != OffsetRange.NONE) {
            List<Object> list2;
            offsetRange = StrictWarning.limitErrorToLine(baseDocument, offsetRange, n2);
            if (this.key.equals(TRAILING_COMMA)) {
                list2 = new ArrayList<RemoveTrailingCommaFix>(2);
                list2.add(new RemoveTrailingCommaFix(compilationInfo, n2));
                list2.add(new MoreInfoFix(this.key));
            } else {
                list2 = Collections.singletonList(new MoreInfoFix(this.key));
            }
            String string = this.getDisplayName();
            if (string.indexOf("{0}") != -1) {
                string = error.getDisplayName();
            }
            object = new Description(this, string, compilationInfo.getFileObject(), offsetRange, list2, 500);
            list.add((Description)object);
        }
    }

    static OffsetRange limitErrorToLine(BaseDocument baseDocument, OffsetRange offsetRange, int n) {
        try {
            if (offsetRange.getStart() == 0) {
                int n2 = Math.max(offsetRange.getStart(), Utilities.getRowStart((BaseDocument)baseDocument, (int)n));
                int n3 = Math.max(n2, Math.min(offsetRange.getEnd(), baseDocument.getLength()));
                if ((n3 = Math.min(n3, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2))) == n2) {
                    n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3);
                }
                offsetRange = new OffsetRange(n2, n3);
            } else {
                int n4 = offsetRange.getStart();
                int n5 = Math.min(Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4), offsetRange.getEnd());
                offsetRange = new OffsetRange(n4, n5);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return offsetRange;
    }

    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return true;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(StrictWarning.class, (String)this.key);
    }

    public void setDefaultSeverity(HintSeverity hintSeverity) {
        this.defaultSeverity = hintSeverity;
    }

    @Override
    public boolean showInTasklist() {
        return true;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    @Override
    public String getId() {
        return this.key;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(StrictWarning.class, (String)(this.key + ".desc"));
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static class RemoveTrailingCommaFix
    implements PreviewableFix {
        private CompilationInfo info;
        private int offset;

        public RemoveTrailingCommaFix(CompilationInfo compilationInfo, int n) {
            this.info = compilationInfo;
            this.offset = n;
        }

        public String getDescription() {
            return NbBundle.getMessage(StrictWarning.class, (String)"RemoveTrailingCommaFix");
        }

        public void implement() throws Exception {
            EditList editList = this.getEditList();
            if (editList != null) {
                editList.apply();
            }
        }

        public EditList getEditList() throws Exception {
            BaseDocument baseDocument = (BaseDocument)this.info.getDocument();
            EditList editList = new EditList(baseDocument);
            editList.replace(this.offset, 1, null, false, 0);
            return editList;
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

