/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.jlayout;

import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.service.layout.jlayout.AccessiblityUtils;
import com.tomsawyer.editor.service.layout.jlayout.TSESymmetricTab;
import com.tomsawyer.service.TSServiceInputData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class TSESymmetricTabExt
extends TSESymmetricTab {
    public static TSEResourceBundleWrapper tsBundle = TSEResourceBundleWrapper.getSystemLabelBundle();

    public TSESymmetricTabExt(TSEGraph tSEGraph, TSServiceInputData tSServiceInputData, JDialog jDialog) {
        super(tSEGraph, tSServiceInputData, jDialog);
        this.setA11yFeatures();
    }

    protected JPanel makeSpacingOptionsPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(0);
        this.nodeSpacingField = this.createDoubleField(4, 0.0, 1000.0);
        JLabel jLabel = this.createLabel("Node_Spacing", "Node_Spacing", (Component)this.nodeSpacingField);
        JPanel jPanel2 = this.createBoxLayoutPanel(1);
        jPanel2.add(jLabel);
        JPanel jPanel3 = this.createBoxLayoutPanel(1);
        this.nodeSpacingField.setAlignmentX(1.0f);
        jPanel3.add((Component)this.nodeSpacingField);
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Spacing_Options", 0, 5, 5, 5);
        return jPanel;
    }

    protected JPanel makeLayoutQualityPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(0);
        JPanel jPanel2 = this.createBoxLayoutPanel(1);
        this.qualityDraftRadioButton = this.createRadioButton("Draft");
        this.qualityDefaultRadioButton = this.createRadioButton("Default");
        this.qualityProofRadioButton = this.createRadioButton("Proof");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.qualityDraftRadioButton);
        buttonGroup.add(this.qualityDefaultRadioButton);
        buttonGroup.add(this.qualityProofRadioButton);
        jPanel2.add(this.qualityDraftRadioButton);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel2.add(this.qualityDefaultRadioButton);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel2.add(this.qualityProofRadioButton);
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(30, 0)));
        this.createCompoundBorder(jPanel, "Layout_Quality", 0, 5, 5, 5);
        return jPanel;
    }

    protected JPanel createBoxLayoutPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, n));
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(0.0f);
        return jPanel;
    }

    protected JLabel createLabel(String string, String string2, Component component) {
        JLabel jLabel = new JLabel(tsBundle.getStringSafely(string) + ":");
        jLabel.setForeground(this.labelColor);
        jLabel.setAlignmentX(0.0f);
        jLabel.setAlignmentY(0.0f);
        jLabel.setLabelFor(component);
        if (string2 != null) {
            jLabel.setDisplayedMnemonic(AccessiblityUtils.getMnemonic(string2));
        }
        return jLabel;
    }

    public void createCompoundBorder(JPanel jPanel, String string, int n, int n2, int n3, int n4) {
        String string2 = tsBundle.getStringSafely(string);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string2);
        titledBorder.setTitleColor(this.labelColor);
        jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(n, n2, n3, n4)));
    }

    protected int normalizeComponentDimensions(List list, boolean bl, boolean bl2) {
        return 0;
    }

    public void setA11yFeatures() {
        Font font = this.getFont();
        this.qualityDraftRadioButton.setMnemonic(AccessiblityUtils.getMnemonic("Draft"));
        this.qualityDraftRadioButton.setFont(font);
        this.qualityDefaultRadioButton.setFont(font);
        this.qualityProofRadioButton.setFont(font);
        AccessiblityUtils.setAccessibleProperties((Component)this.nodeSpacingField, null, "Node_Spacing");
        AccessiblityUtils.setAccessibleProperties(this.qualityDraftRadioButton, null, "Draft");
        AccessiblityUtils.setAccessibleProperties(this.qualityDefaultRadioButton, null, "Default");
        AccessiblityUtils.setAccessibleProperties(this.qualityProofRadioButton, null, "Proof");
        this.getAccessibleContext().setAccessibleDescription(this.getAccessibleContext().getAccessibleName());
    }
}

